/*
 * Decompiled with CFR 0.152.
 */
package me.moallemi.gradle.advancedbuildversion.gradleextensions;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import me.moallemi.gradle.advancedbuildversion.gradleextensions.VersionCodeConfig$WhenMappings;
import me.moallemi.gradle.advancedbuildversion.gradleextensions.VersionCodeType;
import me.moallemi.gradle.advancedbuildversion.utils.GitWrapper;
import org.gradle.StartParameter;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.invocation.Gradle;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0007\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0013\u001a\u00020\u000bH\u0002J\b\u0010\u0014\u001a\u00020\u000bH\u0002J\b\u0010\u0015\u001a\u00020\u000bH\u0002J\b\u0010\u0016\u001a\u00020\u000bH\u0002J\u001f\u0010\u0007\u001a\u00020\u00172\u0012\u0010\u0018\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\u0019\"\u00020\t\u00a2\u0006\u0002\u0010\u001aJ\r\u0010\u001b\u001a\u00020\u0017H\u0000\u00a2\u0006\u0002\b\u001cJ\u000e\u0010\n\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u000bJ\u000e\u0010\u000f\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u0010R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lme/moallemi/gradle/advancedbuildversion/gradleextensions/VersionCodeConfig;", "", "project", "Lorg/gradle/api/Project;", "gitWrapper", "Lme/moallemi/gradle/advancedbuildversion/utils/GitWrapper;", "(Lorg/gradle/api/Project;Lme/moallemi/gradle/advancedbuildversion/utils/GitWrapper;)V", "dependsOnTasks", "", "", "lastLegacyCode", "", "versionCode", "getVersionCode", "()I", "versionCodeType", "Lme/moallemi/gradle/advancedbuildversion/gradleextensions/VersionCodeType;", "versionPropsFile", "Ljava/io/File;", "byAutoIncrementOneStep", "byDate", "byDateAutoIncrement", "byGitCommitCount", "", "paths", "", "([Ljava/lang/String;)V", "increaseVersionCodeIfPossible", "increaseVersionCodeIfPossible$gradle_advanced_build_version", "lastCode", "type", "Companion", "gradle-advanced-build-version"})
public final class VersionCodeConfig {
    private VersionCodeType versionCodeType;
    private List<String> dependsOnTasks;
    private int lastLegacyCode;
    private final File versionPropsFile;
    private final Project project;
    private final GitWrapper gitWrapper;
    private static final String KEY_VERSION_CODE = "AI_VERSION_CODE";
    public static final Companion Companion = new Companion(null);

    public final void dependsOnTasks(String ... paths) {
        Intrinsics.checkParameterIsNotNull((Object)paths, (String)"paths");
        this.dependsOnTasks = ArraysKt.toList((Object[])paths);
    }

    public final void versionCodeType(@NotNull VersionCodeType type) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)type), (String)"type");
        this.versionCodeType = type;
    }

    public final void lastLegacyCode(int lastCode) {
        this.lastLegacyCode = lastCode;
    }

    public final int getVersionCode() {
        int n;
        switch (VersionCodeConfig$WhenMappings.$EnumSwitchMapping$0[this.versionCodeType.ordinal()]) {
            case 1: {
                n = this.byDate();
                break;
            }
            case 2: {
                n = this.byAutoIncrementOneStep();
                break;
            }
            case 3: {
                n = this.byDateAutoIncrement();
                break;
            }
            case 4: {
                n = this.byGitCommitCount();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return this.lastLegacyCode + n;
    }

    public final void increaseVersionCodeIfPossible$gradle_advanced_build_version() {
        Iterable $this$forEach$iv = this.dependsOnTasks;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String dependentTask = (String)element$iv;
            boolean bl = false;
            Gradle gradle = this.project.getGradle();
            Intrinsics.checkExpressionValueIsNotNull((Object)gradle, (String)"project.gradle");
            StartParameter startParameter = gradle.getStartParameter();
            Intrinsics.checkExpressionValueIsNotNull((Object)startParameter, (String)"project.gradle.startParameter");
            List list = startParameter.getTaskNames();
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"project.gradle.startParameter.taskNames");
            Iterable $this$forEach$iv2 = list;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                String taskName = (String)element$iv2;
                boolean bl2 = false;
                String string = taskName;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"taskName");
                if (!StringsKt.contains((CharSequence)string, (CharSequence)dependentTask, (boolean)true) || this.versionCodeType != VersionCodeType.AUTO_INCREMENT_ONE_STEP || !this.versionPropsFile.canRead()) continue;
                Properties versionProps = new Properties();
                versionProps.load(new FileInputStream(this.versionPropsFile));
                ((Map)versionProps).put(KEY_VERSION_CODE, String.valueOf(this.getVersionCode()));
                File file = this.versionPropsFile;
                Properties properties = versionProps;
                Charset charset = Charsets.UTF_8;
                boolean bl3 = false;
                Object object = file;
                boolean bl4 = false;
                object = new FileOutputStream((File)object);
                bl4 = false;
                OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)object, charset);
                properties.store(outputStreamWriter, null);
            }
        }
    }

    private final int byDate() {
        Calendar calendar = Calendar.getInstance(Locale.ENGLISH);
        Intrinsics.checkExpressionValueIsNotNull((Object)calendar, (String)"Calendar.getInstance(Locale.ENGLISH)");
        Calendar calendar2 = calendar;
        int year = (calendar2.get(1) - 2000) * 100000000;
        int month = (calendar2.get(2) + 1) * 1000000;
        int day = calendar2.get(5) * 10000;
        int hour = calendar2.get(11) * 100;
        int minutes = calendar2.get(12);
        return year + month + day + hour + minutes;
    }

    private final int byAutoIncrementOneStep() {
        int n;
        if (this.versionPropsFile.canRead()) {
            Properties versionProps = new Properties();
            versionProps.load(new FileInputStream(this.versionPropsFile));
            Object object = versionProps.get(KEY_VERSION_CODE);
            if (object != null && (object = object.toString()) != null) {
                Object object2 = object;
                boolean bl = false;
                n = Integer.parseInt((String)object2) + 1;
            } else {
                n = 1;
            }
        } else {
            throw (Throwable)new GradleException("Could not read version.properties file in path " + this.versionPropsFile.getAbsolutePath() + '.' + " Please create this file and add it to your VCS (git, svn, ...).");
        }
        return n;
    }

    private final int byDateAutoIncrement() {
        SimpleDateFormat formatter = new SimpleDateFormat("yyMMddHHmm", Locale.ENGLISH);
        String string = formatter.format(new Date());
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"formatter.format(Date())");
        String string2 = string;
        boolean bl = false;
        return Integer.parseInt(string2) - 1400000000;
    }

    private final int byGitCommitCount() {
        return this.gitWrapper.getCommitsNumberInBranch();
    }

    public VersionCodeConfig(@NotNull Project project, @NotNull GitWrapper gitWrapper) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)gitWrapper, (String)"gitWrapper");
        this.project = project;
        this.gitWrapper = gitWrapper;
        this.versionCodeType = VersionCodeType.AUTO_INCREMENT_ONE_STEP;
        this.dependsOnTasks = CollectionsKt.listOf((Object)"release");
        StringBuilder stringBuilder = new StringBuilder();
        File file = this.project.getBuildFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"project.buildFile");
        this.versionPropsFile = new File(stringBuilder.append(file.getParent()).append("/version.properties").toString());
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lme/moallemi/gradle/advancedbuildversion/gradleextensions/VersionCodeConfig$Companion;", "", "()V", "KEY_VERSION_CODE", "", "gradle-advanced-build-version"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

