/*
 * Decompiled with CFR 0.152.
 */
package me.moallemi.gradle.advancedbuildversion.utils;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.initialization.dsl.ScriptHandler;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000.\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u001a\u0012\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0001H\u0002\u001a\u0006\u0010\u000e\u001a\u00020\b\u001a\"\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u0001H\u0002\u001a\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00102\u0006\u0010\t\u001a\u00020\nH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0014"}, d2={"ANDROID_GRADLE_PLUGIN_ATTRIBUTE_ID", "", "ANDROID_GRADLE_PLUGIN_GROUP", "GRADLE_MIN_VERSION", "Lorg/gradle/util/GradleVersion;", "getGRADLE_MIN_VERSION", "()Lorg/gradle/util/GradleVersion;", "checkAndroidGradleVersion", "", "project", "Lorg/gradle/api/Project;", "checkAndroidVersion", "", "version", "checkMinimumGradleVersion", "findClassPathDependencyVersion", "Lorg/gradle/api/artifacts/Dependency;", "group", "attributeId", "getAndroidPluginVersion", "gradle-advanced-build-version"})
public final class CompatibilityManagerKt {
    @NotNull
    private static final GradleVersion GRADLE_MIN_VERSION;
    @NotNull
    public static final String ANDROID_GRADLE_PLUGIN_GROUP = "com.android.tools.build";
    @NotNull
    public static final String ANDROID_GRADLE_PLUGIN_ATTRIBUTE_ID = "gradle";

    public static final void checkAndroidGradleVersion(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Dependency androidGradlePlugin = CompatibilityManagerKt.getAndroidPluginVersion(project);
        if (androidGradlePlugin == null) {
            throw (Throwable)new IllegalStateException("The Android Gradle plugin not found. gradle-advanced-build-version only works with Android gradle library.");
        }
        if (!CompatibilityManagerKt.checkAndroidVersion(androidGradlePlugin.getVersion())) {
            throw (Throwable)new GradleException("gradle-advanced-build-version does not support Android Gradle plugin " + androidGradlePlugin.getVersion());
        }
        if (!project.getPlugins().hasPlugin("com.android.application")) {
            throw (Throwable)new GradleException("gradle-advanced-build-version only works with android application modules");
        }
    }

    public static final void checkMinimumGradleVersion() {
        if (GRADLE_MIN_VERSION.compareTo(GradleVersion.current()) > 0) {
            throw (Throwable)new GradleException("\"gradle-advanced-build-version\" plugin requires at least minimum version " + GRADLE_MIN_VERSION + ". Detected version " + GradleVersion.current() + '.');
        }
    }

    private static final boolean checkAndroidVersion(String version) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = CollectionsKt.listOf((Object[])new String[]{"3.", "4."});
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    String string = version;
                    if (!(string != null ? StringsKt.startsWith$default((String)string, (String)it, (boolean)false, (int)2, null) : false)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static final Dependency getAndroidPluginVersion(Project project) {
        Dependency dependency = CompatibilityManagerKt.findClassPathDependencyVersion(project, ANDROID_GRADLE_PLUGIN_GROUP, ANDROID_GRADLE_PLUGIN_ATTRIBUTE_ID);
        if (dependency == null) {
            Project project2 = project.getRootProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project.rootProject");
            dependency = CompatibilityManagerKt.findClassPathDependencyVersion(project2, ANDROID_GRADLE_PLUGIN_GROUP, ANDROID_GRADLE_PLUGIN_ATTRIBUTE_ID);
        }
        return dependency;
    }

    private static final Dependency findClassPathDependencyVersion(Project project, String group, String attributeId) {
        Object v4;
        block1: {
            ScriptHandler scriptHandler = project.getBuildscript();
            Intrinsics.checkExpressionValueIsNotNull((Object)scriptHandler, (String)"project.buildscript");
            Configuration configuration = scriptHandler.getConfigurations().getByName("classpath");
            Intrinsics.checkExpressionValueIsNotNull((Object)configuration, (String)"project.buildscript.conf\u2026ns.getByName(\"classpath\")");
            DependencySet dependencySet = configuration.getDependencies();
            Intrinsics.checkExpressionValueIsNotNull((Object)dependencySet, (String)"project.buildscript.conf\u2026\"classpath\").dependencies");
            Iterable iterable = (Iterable)dependencySet;
            boolean bl = false;
            Iterable iterable2 = iterable;
            boolean bl2 = false;
            for (Object t : iterable2) {
                Dependency it = (Dependency)t;
                boolean bl3 = false;
                Dependency dependency = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)dependency, (String)"it");
                if (!(Intrinsics.areEqual((Object)group, (Object)dependency.getGroup()) && Intrinsics.areEqual((Object)it.getName(), (Object)attributeId))) continue;
                v4 = t;
                break block1;
            }
            v4 = null;
        }
        return v4;
    }

    @NotNull
    public static final GradleVersion getGRADLE_MIN_VERSION() {
        return GRADLE_MIN_VERSION;
    }

    static {
        GradleVersion gradleVersion = GradleVersion.version((String)"5.0");
        Intrinsics.checkExpressionValueIsNotNull((Object)gradleVersion, (String)"GradleVersion.version(\"5.0\")");
        GRADLE_MIN_VERSION = gradleVersion;
    }
}

