/*
 * Decompiled with CFR 0.152.
 */
package me.moocar.logbackgelf;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.CoreConstants;
import ch.qos.logback.core.LayoutBase;
import java.util.HashMap;
import java.util.Map;
import me.moocar.logbackgelf.GelfConverter;
import me.moocar.logbackgelf.util.InternetUtils;

public class GelfLayout
extends LayoutBase<ILoggingEvent> {
    private String facility = "GELF";
    private boolean useLoggerName = false;
    private String hostName;
    private boolean useThreadName = false;
    private boolean useMarker = false;
    private boolean appendLineSeparator = false;
    private String messagePattern = "%m%rEx";
    private String shortMessagePattern = null;
    private Map<String, String> additionalFields = new HashMap<String, String>();
    private Map<String, String> staticAdditionalFields = new HashMap<String, String>();
    private boolean includeFullMDC;
    private int shortMessageLength = 255;
    private GelfConverter converter;

    public boolean isAppendLineSeparator() {
        return this.appendLineSeparator;
    }

    public void setAppendLineSeparator(boolean appendLineSeparator) {
        this.appendLineSeparator = appendLineSeparator;
    }

    public boolean isUseMarker() {
        return this.useMarker;
    }

    public void setUseMarker(boolean useMarker) {
        this.useMarker = useMarker;
    }

    public String getFacility() {
        return this.facility;
    }

    public void setFacility(String facility) {
        this.facility = facility;
    }

    public boolean isUseLoggerName() {
        return this.useLoggerName;
    }

    public void setUseLoggerName(boolean useLoggerName) {
        this.useLoggerName = useLoggerName;
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public boolean isUseThreadName() {
        return this.useThreadName;
    }

    public void setUseThreadName(boolean useThreadName) {
        this.useThreadName = useThreadName;
    }

    public Map<String, String> getAdditionalFields() {
        return this.additionalFields;
    }

    public void setAdditionalFields(Map<String, String> additionalFields) {
        this.additionalFields = additionalFields;
    }

    public Map<String, String> getStaticAdditionalFields() {
        return this.staticAdditionalFields;
    }

    public void setStaticAdditionalFields(Map<String, String> staticAdditionalFields) {
        this.staticAdditionalFields = staticAdditionalFields;
    }

    public int getShortMessageLength() {
        return this.shortMessageLength;
    }

    public void setShortMessageLength(int shortMessageLength) {
        this.shortMessageLength = shortMessageLength;
    }

    public String getMessagePattern() {
        return this.messagePattern;
    }

    public void setMessagePattern(String messagePattern) {
        this.messagePattern = messagePattern;
    }

    public String getShortMessagePattern() {
        return this.shortMessagePattern;
    }

    public void setShortMessagePattern(String shortMessagePattern) {
        this.shortMessagePattern = shortMessagePattern;
    }

    public boolean isIncludeFullMDC() {
        return this.includeFullMDC;
    }

    public void setIncludeFullMDC(boolean includeFullMDC) {
        this.includeFullMDC = includeFullMDC;
    }

    public String doLayout(ILoggingEvent event) {
        String eventString = this.converter.toGelf(event);
        return this.isAppendLineSeparator() ? eventString + CoreConstants.LINE_SEPARATOR : eventString;
    }

    public void start() {
        super.start();
        this.createConverter();
    }

    private void createConverter() {
        try {
            if (this.hostName == null) {
                this.hostName = InternetUtils.getLocalHostName();
            }
            this.converter = new GelfConverter(this.facility, this.useLoggerName, this.useThreadName, this.useMarker, this.additionalFields, this.staticAdditionalFields, this.shortMessageLength, this.hostName, this.messagePattern, this.shortMessagePattern, this.includeFullMDC);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to initialize converter", e);
        }
    }

    public String getContentType() {
        return "application/json";
    }
}

