/*
 * Decompiled with CFR 0.152.
 */
package me.moocar.logbackgelf;

import java.io.IOException;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import me.moocar.logbackgelf.MessageIdProvider;

public class GelfChunkingOutputStream
extends OutputStream {
    private final int MAX_CHUNKS = 128;
    private final byte[] CHUNKED_GELF_ID_BYTES = new byte[]{30, 15};
    private final int MESSAGE_ID_LENGTH = 8;
    private final int SEQ_COUNT_POSITION = this.CHUNKED_GELF_ID_BYTES.length + 8 + 1;
    private final byte[] packetBytes;
    private final byte[][] chunks;
    private final int maxPacketSize;
    private final MessageIdProvider messageIdProvider;
    private final InetAddress address;
    private final int port;
    private DatagramSocket socket;
    private int chunkIndex = 0;
    private int position = 0;
    private boolean chunked = false;
    private boolean maxChunksReached = false;
    private byte[] messageID;

    public GelfChunkingOutputStream(InetAddress address, int port, int maxPacketSize, MessageIdProvider messageIdProvider) {
        this.address = address;
        this.port = port;
        this.maxPacketSize = maxPacketSize;
        this.messageIdProvider = messageIdProvider;
        this.chunks = new byte[128][maxPacketSize];
        this.packetBytes = new byte[maxPacketSize];
    }

    public void start() throws SocketException, UnknownHostException {
        this.socket = new DatagramSocket();
        this.socket.connect(this.address, this.port);
    }

    @Override
    public void write(int b) throws IOException {
        if (this.maxChunksReached) {
            return;
        }
        if (!this.chunked) {
            this.writeUnchunked((byte)b);
        } else {
            this.writeChunked((byte)b);
        }
    }

    private void writeUnchunked(byte b) throws IOException {
        if (this.position < this.maxPacketSize) {
            this.packetBytes[this.position++] = b;
        } else {
            this.startChunking();
            this.write(b);
        }
    }

    private void startChunking() throws IOException {
        this.chunked = true;
        this.messageID = this.messageIdProvider.get();
        this.chunkIndex = -1;
        for (byte packetByte : this.packetBytes) {
            this.write(packetByte);
        }
    }

    private void writeChunked(byte b) throws IOException {
        if (this.position == this.maxPacketSize) {
            if (this.chunkIndex == 127) {
                this.maxChunksReached = true;
            } else {
                ++this.chunkIndex;
                this.position = 0;
                this.writeHeader();
                this.write(b);
            }
        } else {
            this.chunks[this.chunkIndex][this.position++] = b;
        }
    }

    private void writeHeader() {
        this.chunks[this.chunkIndex][this.position++] = this.CHUNKED_GELF_ID_BYTES[0];
        this.chunks[this.chunkIndex][this.position++] = this.CHUNKED_GELF_ID_BYTES[1];
        for (byte messageIDByte : this.messageID) {
            this.chunks[this.chunkIndex][this.position++] = messageIDByte;
        }
        this.chunks[this.chunkIndex][this.position++] = (byte)this.chunkIndex;
        ++this.position;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws IOException {
        try {
            if (this.chunkIndex == 0 && this.position == 0) {
                return;
            }
            if (this.maxChunksReached) {
                return;
            }
            if (this.chunked) {
                this.flushChunked();
            } else {
                this.sendBytes(this.packetBytes, this.position);
            }
        }
        finally {
            this.reset();
        }
    }

    private void flushChunked() throws IOException {
        this.fillInSequenceCounts();
        for (int i = 0; i < this.chunkIndex; ++i) {
            this.sendBytes(this.chunks[i], this.maxPacketSize);
        }
        this.sendBytes(this.chunks[this.chunkIndex], this.position);
    }

    private void fillInSequenceCounts() {
        for (int i = 0; i <= this.chunkIndex; ++i) {
            this.chunks[i][this.SEQ_COUNT_POSITION] = (byte)(this.chunkIndex + 1);
        }
    }

    private void sendBytes(byte[] bytes, int length) throws IOException {
        DatagramPacket packet = new DatagramPacket(bytes, 0, length);
        this.socket.send(packet);
    }

    private void reset() {
        this.position = 0;
        this.chunkIndex = 0;
        this.chunked = false;
        this.maxChunksReached = false;
    }
}

