/*
 * Decompiled with CFR 0.152.
 */
package me.moocar.logbackgelf;

import ch.qos.logback.classic.PatternLayout;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.StackTraceElementProxy;
import ch.qos.logback.classic.util.LevelToSyslogSeverity;
import ch.qos.logback.core.Layout;
import ch.qos.logback.core.LayoutBase;
import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.lang.reflect.Method;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import me.moocar.logbackgelf.Field;
import me.moocar.logbackgelf.InternetUtils;

public class GelfLayout<E extends ILoggingEvent>
extends LayoutBase<E> {
    private final String DEFAULT_FULL_MESSAGE_PATTERN = "%rEx%m";
    private final String DEFAULT_SHORT_MESSAGE_PATTERN = "%ex{short}%.100m";
    private boolean useLoggerName = false;
    private boolean useThreadName = false;
    private boolean useMarker = false;
    private Map<String, String> additionalFields = new HashMap<String, String>();
    private Map<String, String> fieldTypes = new HashMap<String, String>();
    private Map<String, String> staticFields = new HashMap<String, String>();
    private String host = this.getLocalHostName();
    private final Gson gson;
    private Layout fullMessageLayout;
    private Layout shortMessageLayout;
    private boolean includeFullMDC = false;
    static Map<String, Method> primitiveTypes = new HashMap<String, Method>();

    public GelfLayout() {
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES);
        this.gson = gsonBuilder.create();
    }

    public void start() {
        if (this.fullMessageLayout == null) {
            this.fullMessageLayout = this.initNewPatternLayout("%rEx%m");
        }
        if (this.shortMessageLayout == null) {
            this.shortMessageLayout = this.initNewPatternLayout("%ex{short}%.100m");
        }
        super.start();
    }

    private PatternLayout initNewPatternLayout(String pattern) {
        PatternLayout layout = new PatternLayout();
        layout.setPattern(pattern);
        layout.setContext(this.getContext());
        layout.start();
        return layout;
    }

    public String doLayout(E event) {
        return this.gson.toJson(this.mapFields(event));
    }

    private Map<String, Object> mapFields(E logEvent) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("host", this.host);
        map.put("full_message", this.fullMessageLayout.doLayout(logEvent));
        map.put("short_message", this.shortMessageLayout.doLayout(logEvent));
        this.stackTraceField((Map<String, Object>)map, (ILoggingEvent)logEvent);
        map.put("timestamp", (double)logEvent.getTimeStamp() / 1000.0);
        map.put("version", "1.1");
        map.put("level", LevelToSyslogSeverity.convert(logEvent));
        this.additionalFields((Map<String, Object>)map, (ILoggingEvent)logEvent);
        this.staticAdditionalFields(map);
        return map;
    }

    private void stackTraceField(Map<String, Object> map, ILoggingEvent eventObject) {
        StackTraceElement[] callStackTraces;
        StackTraceElementProxy[] proxyStackTraces;
        IThrowableProxy throwableProxy = eventObject.getThrowableProxy();
        if (throwableProxy != null && (proxyStackTraces = throwableProxy.getStackTraceElementProxyArray()) != null && proxyStackTraces.length > 0 && (callStackTraces = eventObject.getCallerData()) != null && callStackTraces.length > 0) {
            StackTraceElement lastStack = callStackTraces[0];
            map.put("_file", lastStack.getFileName());
            map.put("_line", String.valueOf(lastStack.getLineNumber()));
        }
    }

    private void additionalFields(Map<String, Object> map, ILoggingEvent eventObject) {
        block8: {
            Map mdc;
            if (this.useLoggerName) {
                map.put("_loggerName", eventObject.getLoggerName());
            }
            if (this.useMarker && this.eventHasMarker(eventObject)) {
                map.put("_marker", eventObject.getMarker().toString());
            }
            if (this.useThreadName) {
                map.put("_threadName", eventObject.getThreadName());
            }
            if ((mdc = eventObject.getMDCPropertyMap()) == null) break block8;
            if (this.includeFullMDC) {
                for (Map.Entry e : mdc.entrySet()) {
                    if (this.additionalFields.containsKey(e.getKey())) {
                        map.put(this.additionalFields.get(e.getKey()), this.convertFieldType(e.getValue(), this.additionalFields.get(e.getKey())));
                        continue;
                    }
                    map.put("_" + (String)e.getKey(), this.convertFieldType(e.getValue(), "_" + (String)e.getKey()));
                }
            } else {
                for (String key : this.additionalFields.keySet()) {
                    String field = (String)mdc.get(key);
                    if (field == null) continue;
                    map.put(this.additionalFields.get(key), this.convertFieldType(field, key));
                }
            }
        }
    }

    private Object convertFieldType(Object value, String type) {
        if (primitiveTypes.containsKey(this.fieldTypes.get(type))) {
            try {
                value = primitiveTypes.get(this.fieldTypes.get(type)).invoke(null, value);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        return value;
    }

    private boolean eventHasMarker(ILoggingEvent eventObject) {
        return eventObject.getMarker() != null;
    }

    private void staticAdditionalFields(Map<String, Object> map) {
        for (String key : this.staticFields.keySet()) {
            map.put(key, this.staticFields.get(key));
        }
    }

    private String getLocalHostName() {
        try {
            return InternetUtils.getLocalHostName();
        }
        catch (SocketException e) {
            return "UNKNOWN";
        }
        catch (UnknownHostException e) {
            return "UNKNOWN";
        }
    }

    public boolean isUseLoggerName() {
        return this.useLoggerName;
    }

    public void setUseLoggerName(boolean useLoggerName) {
        this.useLoggerName = useLoggerName;
    }

    public boolean isUseMarker() {
        return this.useMarker;
    }

    public void setUseMarker(boolean useMarker) {
        this.useMarker = useMarker;
    }

    public boolean isUseThreadName() {
        return this.useThreadName;
    }

    public void setUseThreadName(boolean useThreadName) {
        this.useThreadName = useThreadName;
    }

    public Map<String, String> getAdditionalFields() {
        return this.additionalFields;
    }

    public void setAdditionalFields(Map<String, String> additionalFields) {
        this.additionalFields = additionalFields;
    }

    public Map<String, String> getStaticFields() {
        return this.staticFields;
    }

    public void setStaticFields(Map<String, String> staticFields) {
        this.staticFields = staticFields;
    }

    public boolean isIncludeFullMDC() {
        return this.includeFullMDC;
    }

    public void setIncludeFullMDC(boolean includeFullMDC) {
        this.includeFullMDC = includeFullMDC;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void addAdditionalField(String keyValue) {
        String[] splitted = keyValue.split(":");
        if (splitted.length != 2) {
            throw new IllegalArgumentException("additionalField must be of the format key:value, where key is the MDC key, and value is the GELF field name. But found '" + keyValue + "' instead.");
        }
        this.additionalFields.put(splitted[0], splitted[1]);
    }

    public void addStaticAdditionalField(String keyValue) {
        String[] splitted = keyValue.split(":");
        if (splitted.length != 2) {
            throw new IllegalArgumentException("staticAdditionalField must be of the format key:value, where key is the additional field key (therefore should have a leading underscore), and value is a static string. e.g. _node_name:www013");
        }
        this.staticFields.put(splitted[0], splitted[1]);
    }

    public void addStaticField(Field entry) {
        this.staticFields.put(entry.getKey(), entry.getValue());
    }

    public void addFieldType(String keyValue) {
        String[] splitted = keyValue.split(":");
        if (splitted.length != 2 || !primitiveTypes.containsKey(splitted[1])) {
            throw new IllegalArgumentException("fieldType must be of the format key:value, where key is the field key, and value is the type to convert to (one of " + primitiveTypes.keySet() + ")");
        }
        this.fieldTypes.put(splitted[0], splitted[1]);
    }

    public Map<String, String> getFieldTypes() {
        return this.fieldTypes;
    }

    public void setFieldTypes(Map<String, String> fieldTypes) {
        this.fieldTypes = fieldTypes;
    }

    public Layout getFullMessageLayout() {
        return this.fullMessageLayout;
    }

    public void setFullMessageLayout(Layout fullMessageLayout) {
        this.fullMessageLayout = fullMessageLayout;
    }

    public Layout getShortMessageLayout() {
        return this.shortMessageLayout;
    }

    public void setShortMessageLayout(Layout shortMessageLayout) {
        this.shortMessageLayout = shortMessageLayout;
    }

    static {
        try {
            primitiveTypes.put("int", Integer.class.getDeclaredMethod("parseInt", String.class));
            primitiveTypes.put("Integer", Integer.class.getDeclaredMethod("parseInt", String.class));
            primitiveTypes.put("long", Long.class.getDeclaredMethod("parseLong", String.class));
            primitiveTypes.put("Long", Long.class.getDeclaredMethod("parseLong", String.class));
            primitiveTypes.put("float", Float.class.getDeclaredMethod("parseFloat", String.class));
            primitiveTypes.put("Float", Float.class.getDeclaredMethod("parseFloat", String.class));
            primitiveTypes.put("double", Double.class.getDeclaredMethod("parseDouble", String.class));
            primitiveTypes.put("Double", Double.class.getDeclaredMethod("parseDouble", String.class));
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
    }
}

