/*
 * Decompiled with CFR 0.152.
 */
package me.moocar.logbackgelf;

import ch.qos.logback.core.OutputStreamAppender;
import java.io.IOException;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.security.NoSuchAlgorithmException;
import me.moocar.logbackgelf.GelfChunkingOutputStream;
import me.moocar.logbackgelf.InternetUtils;
import me.moocar.logbackgelf.MessageIdProvider;

public class GelfUDPAppender<E>
extends OutputStreamAppender<E> {
    private final String REMOTE_HOST = "localhost";
    private final int DEFAULT_PORT = 12201;
    private final int DEFAULT_MAX_PACKET_SIZE = 512;
    private String remoteHost = "localhost";
    private int port = 12201;
    private int maxPacketSize = 512;

    public void start() {
        if (this.isStarted()) {
            return;
        }
        int errorCount = 0;
        if (this.port <= 0) {
            ++errorCount;
            this.addError("No port was configured for appender" + this.name + " For more information, please visit http://logback.qos.ch/codes.html#socket_no_port");
        }
        if (this.remoteHost == null) {
            ++errorCount;
            this.addError("No remote host was configured for appender" + this.name + " For more information, please visit http://logback.qos.ch/codes.html#socket_no_host");
        }
        InetAddress address = null;
        if (errorCount == 0) {
            try {
                address = InternetUtils.getInetAddress(this.remoteHost);
            }
            catch (Exception e) {
                this.addError(e.getMessage());
                ++errorCount;
            }
        }
        String hostname = null;
        if (errorCount == 0) {
            try {
                hostname = InternetUtils.getLocalHostName();
            }
            catch (SocketException e) {
                this.addError("Error creating localhostname", e);
                ++errorCount;
            }
            catch (UnknownHostException e) {
                this.addError("Could not create hostname");
                ++errorCount;
            }
        }
        MessageIdProvider messageIdProvider = null;
        if (errorCount == 0) {
            try {
                messageIdProvider = new MessageIdProvider(hostname);
            }
            catch (NoSuchAlgorithmException e) {
                ++errorCount;
                this.addError("Error creating digest", e);
            }
        }
        if (errorCount == 0) {
            GelfChunkingOutputStream os = new GelfChunkingOutputStream(address, this.port, this.maxPacketSize, messageIdProvider);
            try {
                os.start();
                this.setOutputStream(os);
                super.start();
            }
            catch (SocketException e) {
                this.addError("Could not connect to remote host", e);
            }
            catch (UnknownHostException e) {
                this.addError("unknown host: " + this.remoteHost);
            }
        }
    }

    protected void writeOut(E event) {
        try {
            super.writeOut(event);
        }
        catch (IOException e) {
            this.addError("IO Exception in UDP output stream", e);
        }
    }

    public String getRemoteHost() {
        return this.remoteHost;
    }

    public void setRemoteHost(String remoteHost) {
        this.remoteHost = remoteHost;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getMaxPacketSize() {
        return this.maxPacketSize;
    }

    public void setMaxPacketSize(int maxPacketSize) {
        this.maxPacketSize = maxPacketSize;
    }
}

