/*
 * Decompiled with CFR 0.152.
 */
package patdroid.core;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import patdroid.core.ClassInfo;
import patdroid.core.MethodInfo;
import patdroid.util.Log;

public final class ClassDetail {
    static final ClassDetail missingDetail = new ClassDetail(null, new ClassInfo[0], 0, new MethodInfo[0], new HashMap<String, ClassInfo>(), new HashMap<String, ClassInfo>(), true);
    private final ClassInfo superClass;
    private final ClassInfo[] interfaces;
    private final HashMap<MethodInfoWrapper, MethodInfo> methods;
    private final HashMap<String, ClassInfo> fields;
    private final HashMap<String, ClassInfo> staticFields;
    private final boolean isFrameworkClass;
    public ArrayList<ClassInfo> derivedClasses = new ArrayList();
    public final int accessFlags;

    ClassDetail(ClassInfo superClass, ClassInfo[] interfaces, int accessFlags, MethodInfo[] methods, HashMap<String, ClassInfo> fields, HashMap<String, ClassInfo> staticFields, boolean isFrameworkClass) {
        this.accessFlags = accessFlags;
        this.superClass = superClass;
        this.interfaces = interfaces;
        this.methods = new HashMap();
        for (MethodInfo mi : methods) {
            this.methods.put(new MethodInfoWrapper(mi), mi);
        }
        this.fields = fields;
        this.staticFields = new HashMap<String, ClassInfo>(staticFields);
        this.isFrameworkClass = isFrameworkClass;
    }

    private ClassDetail(ClassInfo superClass, ClassInfo[] interfaces, int accessFlags, HashMap<MethodInfoWrapper, MethodInfo> methods, HashMap<String, ClassInfo> fields, HashMap<String, ClassInfo> staticFields, boolean isFrameworkClass) {
        this.accessFlags = accessFlags;
        this.superClass = superClass;
        this.interfaces = interfaces;
        this.methods = new HashMap<MethodInfoWrapper, MethodInfo>(methods);
        this.fields = fields;
        this.staticFields = new HashMap<String, ClassInfo>(staticFields);
        this.isFrameworkClass = isFrameworkClass;
    }

    public Collection<MethodInfo> getAllMethods() {
        return this.methods.values();
    }

    public ClassInfo getFieldType(String fieldName) {
        ClassInfo r = this.fields.get(fieldName);
        if (r != null) {
            return r;
        }
        if (this.superClass == null) {
            Log.warnwarn("failed to find field: " + fieldName);
            return null;
        }
        return this.superClass.getDetails().getFieldType(fieldName);
    }

    public ClassInfo getStaticFieldType(String fieldName) {
        ClassInfo r = this.staticFields.get(fieldName);
        if (r != null) {
            return r;
        }
        if (this.superClass == null) {
            Log.warnwarn("failed to find static field: " + fieldName);
            return null;
        }
        return this.superClass.getDetails().getStaticFieldType(fieldName);
    }

    public HashMap<String, ClassInfo> getAllFieldsHere() {
        return this.fields;
    }

    public HashMap<String, ClassInfo> getAllStaticFieldsHere() {
        return this.staticFields;
    }

    public MethodInfo findMethodHere(MethodInfo mproto) {
        return this.methods.get(new MethodInfoWrapper(mproto));
    }

    public MethodInfo findMethod(MethodInfo mproto) {
        ArrayDeque<ClassDetail> q = new ArrayDeque<ClassDetail>();
        q.push(this);
        while (!q.isEmpty()) {
            ClassDetail detail = (ClassDetail)q.pop();
            MethodInfo mi = detail.findMethodHere(mproto);
            if (mi != null) {
                return mi;
            }
            if (detail.superClass != null) {
                q.push(detail.superClass.getDetails());
            }
            for (ClassInfo i : detail.interfaces) {
                q.push(i.getDetails());
            }
        }
        return null;
    }

    public MethodInfo[] findMethods(String name) {
        ArrayList<MethodInfo> result = new ArrayList<MethodInfo>();
        ArrayDeque<ClassDetail> q = new ArrayDeque<ClassDetail>();
        q.push(this);
        while (!q.isEmpty()) {
            ClassDetail detail = (ClassDetail)q.pop();
            MethodInfo[] mis = detail.findMethodsHere(name);
            for (MethodInfo mi : mis) {
                boolean overrided = false;
                for (MethodInfo mi0 : result) {
                    if (!mi0.canOverride(mi)) continue;
                    overrided = true;
                    break;
                }
                if (overrided) continue;
                result.add(mi);
            }
            if (detail.superClass != null) {
                q.push(detail.superClass.getDetails());
            }
            for (ClassInfo i : detail.interfaces) {
                q.push(i.getDetails());
            }
        }
        return result.toArray(new MethodInfo[result.size()]);
    }

    public MethodInfo[] findMethodsHere(String name) {
        ArrayList<MethodInfo> result = new ArrayList<MethodInfo>();
        for (MethodInfo m : this.methods.values()) {
            if (!m.name.equals(name)) continue;
            result.add(m);
        }
        return result.toArray(new MethodInfo[result.size()]);
    }

    public final boolean isConvertibleTo(ClassInfo type) {
        ClassDetail that = type.getDetails();
        if (this == that) {
            return true;
        }
        if (this.superClass != null && this.superClass.isConvertibleTo(type)) {
            return true;
        }
        for (ClassInfo c : this.interfaces) {
            if (!c.isConvertibleTo(type)) continue;
            return true;
        }
        return false;
    }

    public final ClassInfo getSuperClass() {
        return this.superClass;
    }

    public ClassDetail changeSuperClass(ClassInfo superClass) {
        ClassDetail details = new ClassDetail(superClass, this.interfaces, this.accessFlags, this.methods, this.fields, this.staticFields, this.isFrameworkClass);
        details.derivedClasses = this.derivedClasses;
        return details;
    }

    public final boolean isFrameworkClass() {
        return this.isFrameworkClass;
    }

    public final void updateDerivedClasses(ClassInfo ci) {
        ArrayDeque<ClassDetail> a = new ArrayDeque<ClassDetail>();
        if (this.superClass != null) {
            a.add(this.superClass.getDetails());
        }
        for (ClassInfo i : this.interfaces) {
            a.add(i.getDetails());
        }
        while (!a.isEmpty()) {
            ClassDetail detail = (ClassDetail)a.pop();
            detail.derivedClasses.add(ci);
            detail.derivedClasses.addAll(this.derivedClasses);
            if (detail.superClass != null) {
                a.add(detail.superClass.getDetails());
            }
            for (ClassInfo i : detail.interfaces) {
                a.add(i.getDetails());
            }
        }
    }

    public final void removeDerivedClasses(ClassInfo ci) {
        ArrayDeque<ClassDetail> a = new ArrayDeque<ClassDetail>();
        if (this.superClass != null) {
            a.add(this.superClass.getDetails());
        }
        for (ClassInfo i : this.interfaces) {
            a.add(i.getDetails());
        }
        while (!a.isEmpty()) {
            ClassDetail detail = (ClassDetail)a.pop();
            detail.derivedClasses.remove(ci);
            detail.derivedClasses.removeAll(this.derivedClasses);
            if (detail.superClass != null) {
                a.add(detail.superClass.getDetails());
            }
            for (ClassInfo i : detail.interfaces) {
                a.add(i.getDetails());
            }
        }
    }

    private final class MethodInfoWrapper {
        private final MethodInfo m;
        private final int signatureHash;

        public MethodInfoWrapper(MethodInfo m) {
            this.m = m;
            this.signatureHash = m.computeSignatureHash();
        }

        public int hashCode() {
            return this.signatureHash;
        }

        public boolean equals(Object o) {
            return this.signatureHash == ((MethodInfoWrapper)o).signatureHash;
        }

        public String toString() {
            return this.m.toString();
        }
    }
}

