/*
 * Decompiled with CFR 0.152.
 */
package patdroid.core;

import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import patdroid.core.ClassDetail;
import patdroid.core.ClassDetailLoader;
import patdroid.core.MethodInfo;
import patdroid.util.Log;

public final class ClassInfo {
    private static final HashMap<String, ClassInfo> classes = new HashMap();
    public static ClassDetailLoader rootDetailLoader = new ClassDetailLoader();
    public static final ClassInfo rootObject = ClassInfo.findOrCreateClass(Object.class);
    public static final ClassInfo primitiveWide = ClassInfo.findOrCreateClass("AndroidWide");
    public static final ClassInfo primitiveVoid = ClassInfo.findOrCreateClass(Void.TYPE);
    public static final ClassInfo primitiveLong = ClassInfo.findOrCreateClass(Long.TYPE);
    public static final ClassInfo primitiveBoolean = ClassInfo.findOrCreateClass(Boolean.TYPE);
    public static final ClassInfo primitiveByte = ClassInfo.findOrCreateClass(Byte.TYPE);
    public static final ClassInfo primitiveInt = ClassInfo.findOrCreateClass(Integer.TYPE);
    public static final ClassInfo primitiveShort = ClassInfo.findOrCreateClass(Short.TYPE);
    public static final ClassInfo primitiveChar = ClassInfo.findOrCreateClass(Character.TYPE);
    public static final ClassInfo primitiveDouble = ClassInfo.findOrCreateClass(Double.TYPE);
    public static final ClassInfo primitiveFloat = ClassInfo.findOrCreateClass(Float.TYPE);
    private static final Set<ClassInfo> primitives;
    public final String fullName;
    boolean isMissing;
    ClassDetail details;

    private ClassInfo(String fullName) {
        this.fullName = fullName;
        classes.put(fullName, this);
    }

    public static Collection<ClassInfo> getAllClasses() {
        return classes.values();
    }

    public static ClassInfo findClass(String fullName) {
        return classes.get(fullName);
    }

    public static ClassInfo findOrCreateClass(String fullName) {
        ClassInfo u = ClassInfo.findClass(fullName);
        if (u == null && (u = new ClassInfo(fullName)).isArray()) {
            ClassInfo.findOrCreateClass(fullName.substring(1));
        }
        return u;
    }

    public static ClassInfo[] findOrCreateClass(String[] fullNames) {
        ClassInfo[] a = new ClassInfo[fullNames.length];
        for (int i = 0; i < fullNames.length; ++i) {
            a[i] = ClassInfo.findOrCreateClass(fullNames[i]);
        }
        return a;
    }

    public static ClassInfo findOrCreateClass(Class<?> c) {
        return c == null ? null : ClassInfo.findOrCreateClass(c.getName());
    }

    public static ClassInfo[] findOrCreateClass(Class<?>[] l) {
        ClassInfo[] a = new ClassInfo[l.length];
        for (int i = 0; i < a.length; ++i) {
            a[i] = ClassInfo.findOrCreateClass(l[i]);
        }
        return a;
    }

    public static String dumpClassHierarchy() {
        return classes.keySet().toString();
    }

    public boolean isFrameworkClass() {
        return this.getDetails().isFrameworkClass();
    }

    public boolean isMissing() {
        return this.isMissing;
    }

    public ClassInfo getFieldType(String fieldName) {
        return this.isMissing ? null : this.getDetails().getFieldType(fieldName);
    }

    public ClassInfo getStaticFieldType(String fieldName) {
        return this.isMissing ? null : this.getDetails().getStaticFieldType(fieldName);
    }

    public HashMap<String, ClassInfo> getAllFieldsHere() {
        return this.isMissing ? null : this.getDetails().getAllFieldsHere();
    }

    public HashMap<String, ClassInfo> getAllStaticFieldsHere() {
        return this.isMissing ? null : this.getDetails().getAllStaticFieldsHere();
    }

    public Collection<MethodInfo> getAllMethods() {
        if (this.isMissing) {
            return null;
        }
        return this.getDetails().getAllMethods();
    }

    public MethodInfo findMethodHere(MethodInfo mproto) {
        return this.isMissing ? null : this.getDetails().findMethodHere(mproto);
    }

    public MethodInfo findMethodHere(String name, ClassInfo[] paramTypes) {
        return this.findMethodHere(MethodInfo.makePrototype(name, null, paramTypes, 0));
    }

    public MethodInfo findMethodHere(String name, Class<?> ... paramTypes) {
        return this.findMethodHere(name, ClassInfo.findOrCreateClass(paramTypes));
    }

    public MethodInfo[] findMethodsHere(String name) {
        return this.isMissing ? null : this.getDetails().findMethodsHere(name);
    }

    public MethodInfo[] findMethods(String name) {
        return this.isMissing ? null : this.getDetails().findMethods(name);
    }

    public MethodInfo findMethod(MethodInfo mproto) {
        return this.isMissing ? null : this.getDetails().findMethod(mproto);
    }

    public MethodInfo findMethod(String name, ClassInfo[] paramTypes) {
        return this.findMethod(MethodInfo.makePrototype(name, null, paramTypes, 0));
    }

    public MethodInfo findMethod(String name, Class<?> ... paramTypes) {
        return this.findMethod(name, ClassInfo.findOrCreateClass(paramTypes));
    }

    public boolean isConvertibleTo(ClassInfo type) {
        if (type.isPrimitive()) {
            return type == primitiveVoid || this.isPrimitive();
        }
        return this.getDetails().isConvertibleTo(type);
    }

    public String toString() {
        return this.fullName;
    }

    public int hashCode() {
        return this.fullName.hashCode();
    }

    public boolean isArray() {
        return this.fullName.startsWith("[");
    }

    public ClassInfo getElementClass() {
        Log.doAssert(this.isArray(), "Try getting the element class of a non-array class " + this);
        char first = this.fullName.charAt(1);
        switch (first) {
            case 'C': {
                return primitiveChar;
            }
            case 'I': {
                return primitiveInt;
            }
            case 'B': {
                return primitiveByte;
            }
            case 'Z': {
                return primitiveBoolean;
            }
            case 'F': {
                return primitiveFloat;
            }
            case 'D': {
                return primitiveDouble;
            }
            case 'S': {
                return primitiveShort;
            }
            case 'J': {
                return primitiveLong;
            }
            case 'V': {
                return primitiveVoid;
            }
            case 'L': {
                return ClassInfo.findOrCreateClass(this.fullName.substring(2, this.fullName.length() - 1));
            }
            case '[': {
                return ClassInfo.findOrCreateClass(this.fullName.substring(1));
            }
        }
        Log.err("unknown element type for:" + this.fullName);
        return null;
    }

    public ClassInfo getSuperClass() {
        return this.getDetails().getSuperClass();
    }

    public void setSuperClass(ClassInfo superClass) {
        ClassDetail origDetails = this.getDetails();
        origDetails.removeDerivedClasses(this);
        this.details = origDetails.changeSuperClass(superClass);
        this.details.updateDerivedClasses(this);
    }

    public boolean isInnerClass() {
        return this.fullName.lastIndexOf(36) != -1;
    }

    public ClassInfo getOuterClass() {
        Log.doAssert(this.isInnerClass(), "Try getting the outer class from a non-inner class" + this);
        return ClassInfo.findOrCreateClass(this.fullName.substring(0, this.fullName.lastIndexOf(36)));
    }

    public boolean isPrimitive() {
        return primitives.contains(this);
    }

    public boolean isFinal() {
        return !this.isMissing && Modifier.isFinal(this.getDetails().accessFlags);
    }

    public boolean isInterface() {
        return !this.isMissing && Modifier.isInterface(this.getDetails().accessFlags);
    }

    public boolean isAbstract() {
        return !this.isMissing && Modifier.isAbstract(this.getDetails().accessFlags);
    }

    public MethodInfo getDefaultConstructor() {
        return this.findMethodHere("<init>", new ClassInfo[]{this});
    }

    public MethodInfo getStaticInitializer() {
        return this.findMethod("<clinit>", new Class[0]);
    }

    public String getShortName() {
        int idx = this.fullName.lastIndexOf(46);
        if (idx == -1) {
            return this.fullName;
        }
        return this.fullName.substring(idx + 1, this.fullName.length());
    }

    public ClassDetail getDetails() {
        if (this.details != null) {
            return this.details;
        }
        try {
            rootDetailLoader.load(this);
            return this.details;
        }
        catch (ClassNotFoundException e) {
            Log.debug("Cannot find framework class: " + this.fullName);
        }
        catch (ExceptionInInitializerError e) {
            Log.warn("Framework class not visible: " + this.fullName);
        }
        catch (NoClassDefFoundError e) {
            Log.warn("Cannot find framework class def: " + this.fullName);
        }
        this.isMissing = true;
        return ClassDetail.missingDetail;
    }

    public boolean isAlmostFinal() {
        return this.getDetails().derivedClasses.size() == 0;
    }

    static {
        HashSet<ClassInfo> h = new HashSet<ClassInfo>();
        h.add(primitiveWide);
        h.add(primitiveVoid);
        h.add(primitiveLong);
        h.add(primitiveBoolean);
        h.add(primitiveByte);
        h.add(primitiveInt);
        h.add(primitiveShort);
        h.add(primitiveChar);
        h.add(primitiveDouble);
        h.add(primitiveFloat);
        primitives = Collections.unmodifiableSet(h);
    }
}

