/*
 * Decompiled with CFR 0.152.
 */
package patdroid.core;

import java.util.HashMap;
import patdroid.core.ClassInfo;
import patdroid.util.Log;

public final class FieldInfo {
    public final ClassInfo owner;
    public final String fieldName;

    public FieldInfo(ClassInfo owner, String fieldName) {
        this.owner = owner;
        this.fieldName = fieldName;
    }

    public boolean equals(Object o) {
        if (!(o instanceof FieldInfo)) {
            return false;
        }
        FieldInfo that = (FieldInfo)o;
        return this.owner == that.owner && this.fieldName.equals(that.fieldName);
    }

    public int hashCode() {
        return this.owner.hashCode() ^ this.fieldName.hashCode();
    }

    public String toString() {
        return this.owner.toString() + "." + this.fieldName;
    }

    public final ClassInfo getFieldType() {
        return this.owner.getFieldType(this.fieldName);
    }

    public boolean isValid() {
        return this.owner.getFieldType(this.fieldName) != null;
    }

    public FieldInfo bind() {
        ClassInfo theClass = this.owner;
        HashMap<String, ClassInfo> fields;
        while ((fields = theClass.getAllFieldsHere()) == null || !fields.containsKey(this.fieldName)) {
            ClassInfo superClass = theClass.getSuperClass();
            if (superClass == null) {
                Log.warn("field bind failed");
                return new FieldInfo(theClass, this.fieldName);
            }
            theClass = superClass;
        }
        return new FieldInfo(theClass, this.fieldName);
    }
}

