/*
 * Decompiled with CFR 0.152.
 */
package patdroid.core;

import java.lang.reflect.Modifier;
import java.util.Arrays;
import patdroid.core.ClassInfo;
import patdroid.core.TryBlockInfo;
import patdroid.dalvik.Instruction;

public final class MethodInfo {
    public static final String STATIC_INITIALIZER = "<clinit>";
    public static final String CONSTRUCTOR = "<init>";
    public final ClassInfo myClass;
    public final String name;
    public final int modifiers;
    public final ClassInfo[] paramTypes;
    public final ClassInfo returnType;
    public Instruction[] insns;
    public TryBlockInfo[] tbs;
    public Object extra;

    public MethodInfo(ClassInfo myClass, String name, ClassInfo returnType, ClassInfo[] paramTypes, int accessFlags) {
        this.myClass = myClass;
        this.name = name;
        this.returnType = returnType;
        this.paramTypes = paramTypes;
        this.modifiers = accessFlags;
    }

    public static MethodInfo makePrototype(String name, ClassInfo returnType, ClassInfo[] paramTypes, int accessFlags) {
        return new MethodInfo(null, name, returnType, paramTypes, accessFlags);
    }

    public MethodInfo getPrototype() {
        return MethodInfo.makePrototype(this.name, this.returnType, this.paramTypes, this.modifiers);
    }

    public int computeSignatureHash() {
        int prime = 31;
        int result = 1;
        result = result * 31 + this.name.hashCode();
        for (ClassInfo t : this.paramTypes) {
            result = result * 31 + System.identityHashCode(t);
        }
        return result;
    }

    public boolean hasSameSignature(MethodInfo m) {
        if (!m.name.equals(this.name) || m.paramTypes.length != this.paramTypes.length) {
            return false;
        }
        for (int i = 0; i < this.paramTypes.length; ++i) {
            if (this.paramTypes[i] == m.paramTypes[i]) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        String s = this.myClass == null ? "" : this.myClass.toString();
        return s + "/" + this.name + Arrays.deepToString(this.paramTypes);
    }

    public boolean canOverride(MethodInfo m) {
        return this == m || this.myClass.isConvertibleTo(m.myClass) && this.hasSameSignature(m);
    }

    public boolean isStatic() {
        return Modifier.isStatic(this.modifiers);
    }

    public boolean isNative() {
        return Modifier.isNative(this.modifiers);
    }

    public boolean isConstructor() {
        return this.name.equals(CONSTRUCTOR);
    }

    public boolean isAbstract() {
        return Modifier.isAbstract(this.modifiers);
    }

    public boolean isFinal() {
        return Modifier.isFinal(this.modifiers);
    }
}

