/*
 * Decompiled with CFR 0.152.
 */
package patdroid.core;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import patdroid.core.ClassInfo;
import patdroid.util.Log;

public final class PrimitiveInfo {
    public static PrimitiveInfo trueValue = new PrimitiveInfo(true);
    public static PrimitiveInfo falseValue = new PrimitiveInfo(false);
    public static Map<ClassInfo, PrimitiveInfo> primitiveZeros;
    private final ClassInfo kind;
    public final int low32;
    public final int high32;

    private PrimitiveInfo(ClassInfo kind, int low32, int high32) {
        this.kind = kind;
        this.low32 = low32;
        this.high32 = high32;
    }

    private PrimitiveInfo(ClassInfo kind, long l) {
        this.kind = kind;
        this.low32 = (int)l;
        this.high32 = (int)(l >> 32);
    }

    public PrimitiveInfo(int value) {
        this(ClassInfo.primitiveInt, value, 0);
    }

    public PrimitiveInfo(long value) {
        this(ClassInfo.primitiveLong, value);
    }

    public PrimitiveInfo(double value) {
        this(ClassInfo.primitiveDouble, Double.doubleToLongBits(value));
    }

    public PrimitiveInfo(float value) {
        this(ClassInfo.primitiveFloat, Float.floatToIntBits(value), 0);
    }

    public PrimitiveInfo(boolean value) {
        this(ClassInfo.primitiveBoolean, value ? 1 : 0, 0);
    }

    public static PrimitiveInfo fromObject(Object o) {
        if (o instanceof Integer) {
            return new PrimitiveInfo((Integer)o);
        }
        if (o instanceof Short) {
            return new PrimitiveInfo(((Short)o).intValue());
        }
        if (o instanceof Byte) {
            return new PrimitiveInfo(((Byte)o).intValue());
        }
        if (o instanceof Long) {
            return new PrimitiveInfo((Long)o);
        }
        if (o instanceof Float) {
            return new PrimitiveInfo(((Float)o).floatValue());
        }
        if (o instanceof Double) {
            return new PrimitiveInfo((Double)o);
        }
        if (o instanceof Boolean) {
            return new PrimitiveInfo((Boolean)o);
        }
        Log.err("unsupported object to ValueInfo" + o.getClass().toString());
        return null;
    }

    public final ClassInfo getKind() {
        return this.kind;
    }

    private long getLong() {
        return (long)this.high32 << 32 | (long)this.low32 & 0xFFFFFFFFL;
    }

    public final int intValue() {
        Log.doAssert(this.isInteger(), "invalid type");
        return this.low32;
    }

    public final long longValue() {
        Log.doAssert(this.isLong(), "invalid type");
        return this.getLong();
    }

    public final double doubleValue() {
        Log.doAssert(this.isDouble(), "invalid type");
        return Double.longBitsToDouble(this.getLong());
    }

    public final float floatValue() {
        Log.doAssert(this.isFloat(), "invalid type");
        return Float.intBitsToFloat(this.low32);
    }

    public final boolean booleanValue() {
        Log.doAssert(this.isBoolean(), "invalid type");
        return this.low32 == 1;
    }

    public PrimitiveInfo unsafeCastTo(ClassInfo target_type) {
        Log.doAssert(target_type.isPrimitive(), "must cast to a primitive type");
        if (target_type == ClassInfo.primitiveChar || target_type == ClassInfo.primitiveShort || target_type == ClassInfo.primitiveByte) {
            target_type = ClassInfo.primitiveInt;
        }
        return new PrimitiveInfo(target_type, this.low32, this.high32);
    }

    public final PrimitiveInfo castTo(ClassInfo target_type) {
        Log.doAssert(target_type.isPrimitive(), "must cast to a primitive type");
        PrimitiveInfo v = null;
        if (target_type == ClassInfo.primitiveInt) {
            int val = 0;
            if (this.isLong()) {
                val = (int)this.longValue();
            } else if (this.isInteger()) {
                val = this.intValue();
            } else if (this.isBoolean()) {
                val = this.booleanValue() ? 1 : 0;
            } else if (this.isFloat()) {
                val = (int)this.floatValue();
            } else if (this.isDouble()) {
                val = (int)this.doubleValue();
            }
            v = new PrimitiveInfo(val);
        } else if (target_type == ClassInfo.primitiveLong) {
            long val = 0L;
            if (this.isLong()) {
                val = this.longValue();
            } else if (this.isInteger()) {
                val = this.intValue();
            } else if (this.isBoolean()) {
                val = this.booleanValue() ? 1L : 0L;
            } else if (this.isFloat()) {
                val = (long)this.floatValue();
            } else if (this.isDouble()) {
                val = (long)this.doubleValue();
            }
            v = new PrimitiveInfo(val);
        } else if (target_type == ClassInfo.primitiveFloat) {
            float val = 0.0f;
            if (this.isLong()) {
                val = this.longValue();
            } else if (this.isInteger()) {
                val = this.intValue();
            } else if (this.isBoolean()) {
                val = this.booleanValue() ? 1.0f : 0.0f;
            } else if (this.isFloat()) {
                val = this.floatValue();
            } else if (this.isDouble()) {
                val = (float)this.doubleValue();
            }
            v = new PrimitiveInfo(val);
        } else if (target_type == ClassInfo.primitiveDouble) {
            double val = 0.0;
            if (this.isLong()) {
                val = this.longValue();
            } else if (this.isInteger()) {
                val = this.intValue();
            } else if (this.isBoolean()) {
                val = this.booleanValue() ? 1.0 : 0.0;
            } else if (this.isFloat()) {
                val = this.floatValue();
            } else if (this.isDouble()) {
                val = this.doubleValue();
            }
            v = new PrimitiveInfo(val);
        } else {
            v = new PrimitiveInfo(ClassInfo.primitiveInt, this.low32);
        }
        return v;
    }

    public static PrimitiveInfo twoIntsToDouble(int vlow, int vhigh) {
        return new PrimitiveInfo(ClassInfo.primitiveDouble, vlow, vhigh);
    }

    public static PrimitiveInfo twoIntsToLong(int vlow, int vhigh) {
        return new PrimitiveInfo(ClassInfo.primitiveLong, vlow, vhigh);
    }

    public final boolean isInteger() {
        return this.kind == ClassInfo.primitiveInt;
    }

    public final boolean isLong() {
        return this.kind == ClassInfo.primitiveLong;
    }

    public final boolean isDouble() {
        return this.kind == ClassInfo.primitiveDouble;
    }

    public final boolean isFloat() {
        return this.kind == ClassInfo.primitiveFloat;
    }

    public final boolean isBoolean() {
        return this.kind == ClassInfo.primitiveBoolean;
    }

    public final boolean isZero() {
        return this.low32 == 0 && this.high32 == 0;
    }

    public final boolean isSameType(PrimitiveInfo that) {
        return this.kind == that.kind;
    }

    public final String toString() {
        String prefix = "";
        if (this.isInteger()) {
            return prefix + this.intValue();
        }
        if (this.isLong()) {
            return prefix + this.longValue() + "l";
        }
        if (this.isBoolean()) {
            return prefix + this.booleanValue();
        }
        if (this.isFloat()) {
            return prefix + this.floatValue() + "f";
        }
        if (this.isDouble()) {
            return prefix + this.doubleValue();
        }
        Log.err("unsupported ValueInfo kind " + this.kind);
        return "";
    }

    public String castToString() {
        if (this.isInteger()) {
            return "" + this.intValue();
        }
        if (this.isLong()) {
            return "" + this.longValue();
        }
        if (this.isBoolean()) {
            return "" + this.booleanValue();
        }
        if (this.isFloat()) {
            return "" + this.floatValue();
        }
        if (this.isDouble()) {
            return "" + this.doubleValue();
        }
        Log.err("unsupported ValueInfo kind " + this.kind);
        return "";
    }

    public boolean equals(Object o) {
        if (o instanceof PrimitiveInfo) {
            PrimitiveInfo v = (PrimitiveInfo)o;
            return v.kind == this.kind && v.low32 == this.low32 && v.high32 == this.high32;
        }
        Log.warnwarn("ValueInfo compared with a non-ValueInfo");
        return false;
    }

    public int hashCode() {
        return this.kind.hashCode() * 667 + this.low32 * 333 + this.high32;
    }

    static {
        HashMap<ClassInfo, PrimitiveInfo> t = new HashMap<ClassInfo, PrimitiveInfo>();
        t.put(ClassInfo.primitiveVoid, new PrimitiveInfo(0));
        t.put(ClassInfo.primitiveLong, new PrimitiveInfo(0L));
        t.put(ClassInfo.primitiveBoolean, new PrimitiveInfo(false));
        t.put(ClassInfo.primitiveByte, new PrimitiveInfo(0));
        t.put(ClassInfo.primitiveInt, new PrimitiveInfo(0));
        t.put(ClassInfo.primitiveChar, new PrimitiveInfo(0));
        t.put(ClassInfo.primitiveDouble, new PrimitiveInfo(0.0));
        t.put(ClassInfo.primitiveFloat, new PrimitiveInfo(0.0f));
        primitiveZeros = Collections.unmodifiableMap(t);
    }
}

