/*
 * Decompiled with CFR 0.152.
 */
package patdroid.core;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import patdroid.core.ClassDetailLoader;
import patdroid.core.ClassInfo;
import patdroid.core.MethodInfo;

public class ReflectionClassDetailLoader
extends ClassDetailLoader {
    @Override
    public void load(ClassInfo ci) throws ClassNotFoundException, ExceptionInInitializerError, NoClassDefFoundError {
        ClassInfo[] paramTypes;
        ClassInfo returnType;
        String name;
        String fullName = ci.toString();
        Class c = null;
        c = ci.isArray() ? int[].class : Class.forName(fullName);
        ClassInfo superClass = ClassInfo.findOrCreateClass(c.getSuperclass());
        if (superClass == null && c.isInterface()) {
            superClass = ClassInfo.rootObject;
        }
        ArrayList<MethodInfo> methods = new ArrayList<MethodInfo>();
        boolean hasStaticFields = false;
        Field[] raw_fields = c.getDeclaredFields();
        HashMap<String, ClassInfo> fields = new HashMap<String, ClassInfo>();
        HashMap<String, ClassInfo> staticFields = new HashMap<String, ClassInfo>();
        for (Field field : raw_fields) {
            if (Modifier.isStatic(field.getModifiers())) {
                staticFields.put(field.getName(), ClassInfo.findOrCreateClass(field.getType()));
                hasStaticFields = true;
                continue;
            }
            fields.put(field.getName(), ClassInfo.findOrCreateClass(field.getType()));
        }
        if (hasStaticFields) {
            methods.add(new MethodInfo(ci, "<clinit>", ClassInfo.primitiveVoid, new ClassInfo[0], 8));
        }
        if (ci.isInnerClass()) {
            fields.put("this$0", ci.getOuterClass());
        }
        for (AccessibleObject accessibleObject : c.getDeclaredMethods()) {
            name = ((Method)accessibleObject).getName();
            returnType = ClassInfo.findOrCreateClass(((Method)accessibleObject).getReturnType());
            paramTypes = ClassInfo.findOrCreateClass(((Method)accessibleObject).getParameterTypes());
            methods.add(new MethodInfo(ci, name, returnType, paramTypes, ((Method)accessibleObject).getModifiers()));
        }
        for (AccessibleObject accessibleObject : c.getDeclaredConstructors()) {
            name = "<init>";
            returnType = ClassInfo.primitiveVoid;
            paramTypes = ClassInfo.findOrCreateClass(((Constructor)accessibleObject).getParameterTypes());
            methods.add(new MethodInfo(ci, name, returnType, paramTypes, ((Constructor)accessibleObject).getModifiers()));
        }
        Class<?>[] raw_interfaces = c.getInterfaces();
        ClassInfo[] interfaces = new ClassInfo[raw_interfaces.length];
        for (int i = 0; i < raw_interfaces.length; ++i) {
            interfaces[i] = ClassInfo.findOrCreateClass(raw_interfaces[i]);
        }
        ReflectionClassDetailLoader.setDetails(ci, ReflectionClassDetailLoader.createDetail(superClass, interfaces, c.getModifiers(), methods.toArray(new MethodInfo[methods.size()]), fields, staticFields, true));
    }
}

