/*
 * Decompiled with CFR 0.152.
 */
package patdroid.dalvik;

import patdroid.core.ClassInfo;
import patdroid.util.Log;

public class Dalvik {
    public static String toCanonicalName(String dalvikName) {
        dalvikName = dalvikName.replace('/', '.');
        char first = dalvikName.charAt(0);
        switch (first) {
            case 'C': {
                return "char";
            }
            case 'I': {
                return "int";
            }
            case 'B': {
                return "byte";
            }
            case 'Z': {
                return "boolean";
            }
            case 'F': {
                return "float";
            }
            case 'D': {
                return "double";
            }
            case 'S': {
                return "short";
            }
            case 'J': {
                return "long";
            }
            case 'V': {
                return "void";
            }
            case 'L': {
                return dalvikName.substring(1, dalvikName.length() - 1);
            }
            case '[': {
                return dalvikName;
            }
        }
        Log.err("unknown dalvik type:" + dalvikName);
        return "";
    }

    public static String toDalvikName(String canonicalName) {
        boolean isArray;
        boolean bl = isArray = canonicalName.charAt(0) == '[';
        if (isArray) {
            return canonicalName.replace('.', '/');
        }
        if (canonicalName.equals("char")) {
            return "C";
        }
        if (canonicalName.equals("int")) {
            return "I";
        }
        if (canonicalName.equals("byte")) {
            return "B";
        }
        if (canonicalName.equals("boolean")) {
            return "Z";
        }
        if (canonicalName.equals("float")) {
            return "F";
        }
        if (canonicalName.equals("double")) {
            return "D";
        }
        if (canonicalName.equals("short")) {
            return "S";
        }
        if (canonicalName.equals("long")) {
            return "J";
        }
        if (canonicalName.equals("void")) {
            return "V";
        }
        return "L" + canonicalName.replace('.', '/') + ";";
    }

    public static ClassInfo findOrCreateClass(String dalvikClassName) {
        return ClassInfo.findOrCreateClass(Dalvik.toCanonicalName(dalvikClassName));
    }

    public static ClassInfo findClass(String dalvikClassName) {
        return ClassInfo.findClass(Dalvik.toCanonicalName(dalvikClassName));
    }

    public static ClassInfo[] findOrCreateClass(String[] dalvikNames) {
        ClassInfo[] ci = new ClassInfo[dalvikNames.length];
        for (int i = 0; i < dalvikNames.length; ++i) {
            ci[i] = Dalvik.findOrCreateClass(dalvikNames[i]);
        }
        return ci;
    }

    public static ClassInfo[] findClass(String[] dalvikNames) {
        ClassInfo[] ci = new ClassInfo[dalvikNames.length];
        for (int i = 0; i < dalvikNames.length; ++i) {
            ci[i] = Dalvik.findClass(dalvikNames[i]);
        }
        return ci;
    }
}

