/*
 * Decompiled with CFR 0.152.
 */
package patdroid.dalvik;

import java.util.Arrays;
import java.util.Map;
import patdroid.core.ClassInfo;
import patdroid.core.FieldInfo;
import patdroid.util.Pair;

public final class Instruction {
    public static final byte OP_NOP = 0;
    public static final byte OP_MOV = 1;
    public static final byte OP_RETURN = 2;
    public static final byte OP_SPECIAL = 3;
    public static final byte OP_NEW = 4;
    public static final byte OP_EXCEPTION_OP = 5;
    public static final byte OP_GOTO = 6;
    public static final byte OP_CMP = 7;
    public static final byte OP_IF = 8;
    public static final byte OP_INSTANCE_OP = 9;
    public static final byte OP_ARRAY_OP = 10;
    public static final byte OP_STATIC_OP = 11;
    public static final byte OP_INVOKE_OP = 12;
    public static final byte OP_ARITHETIC = 13;
    public static final byte OP_SWITCH = 14;
    public static final byte OP_HALT = 15;
    public static final byte OP_MOV_REG = 1;
    public static final byte OP_MOV_CONST = 2;
    public static final byte OP_RETURN_VOID = 3;
    public static final byte OP_RETURN_SOMETHING = 4;
    public static final byte OP_MONITOR_ENTER = 5;
    public static final byte OP_MONITOR_EXIT = 6;
    public static final byte OP_SP_ARGUMENTS = 7;
    public static final byte OP_NEW_INSTANCE = 8;
    public static final byte OP_NEW_ARRAY = 9;
    public static final byte OP_NEW_FILLED_ARRAY = 10;
    public static final byte OP_INVOKE_DIRECT = 11;
    public static final byte OP_INVOKE_SUPER = 12;
    public static final byte OP_INVOKE_VIRTUAL = 13;
    public static final byte OP_INVOKE_STATIC = 14;
    public static final byte OP_INVOKE_INTERFACE = 15;
    public static final byte OP_A_INSTANCEOF = 16;
    public static final byte OP_A_ARRAY_LENGTH = 17;
    public static final byte OP_A_CHECKCAST = 18;
    public static final byte OP_A_NOT = 19;
    public static final byte OP_A_NEG = 20;
    public static final byte OP_MOV_RESULT = 21;
    public static final byte OP_MOV_EXCEPTION = 22;
    public static final byte OP_A_CAST = 23;
    public static final byte OP_IF_EQ = 24;
    public static final byte OP_IF_NE = 25;
    public static final byte OP_IF_LT = 26;
    public static final byte OP_IF_GE = 27;
    public static final byte OP_IF_GT = 28;
    public static final byte OP_IF_LE = 29;
    public static final byte OP_IF_EQZ = 30;
    public static final byte OP_IF_NEZ = 31;
    public static final byte OP_IF_LTZ = 32;
    public static final byte OP_IF_GEZ = 33;
    public static final byte OP_IF_GTZ = 34;
    public static final byte OP_IF_LEZ = 35;
    public static final byte OP_ARRAY_GET = 36;
    public static final byte OP_ARRAY_PUT = 37;
    public static final byte OP_A_ADD = 38;
    public static final byte OP_A_SUB = 39;
    public static final byte OP_A_MUL = 40;
    public static final byte OP_A_DIV = 41;
    public static final byte OP_A_REM = 42;
    public static final byte OP_A_AND = 43;
    public static final byte OP_A_OR = 44;
    public static final byte OP_A_XOR = 45;
    public static final byte OP_A_SHL = 46;
    public static final byte OP_A_SHR = 47;
    public static final byte OP_A_USHR = 48;
    public static final byte OP_CMP_LONG = 49;
    public static final byte OP_CMP_LESS = 50;
    public static final byte OP_CMP_GREATER = 51;
    public static final byte OP_STATIC_GET_FIELD = 52;
    public static final byte OP_STATIC_PUT_FIELD = 53;
    public static final byte OP_INSTANCE_GET_FIELD = 54;
    public static final byte OP_INSTANCE_PUT_FIELD = 55;
    public static final byte OP_EXCEPTION_TRYCATCH = 56;
    public static final byte OP_EXCEPTION_THROW = 57;
    private static String[] opname = new String[]{"NOP", "MOV", "RETURN", "SPECIAL", "NEW", "EXCEPTION", "GOTO", "CMP", "IF", "INSTANCE", "ARRAY", "STATIC", "INVOKE", "ARITHMETIC", "SWITCH", "HALT"};
    private static String[] opaux_name = new String[]{"NIL", "REG", "CONST", "VOID", "VALUE", "MONITOR_ENTER", "MONITOR_EXIT", "ARGUMENT_SET", "INSTANCE", "ARRAY", "FILLED_ARRAY", "DIRECT", "SUPER", "VIRTUAL", "STATIC", "INTERFACE", "INSTANCE_OF", "ARRAY_LENGTH", "CHECK-AND-CAST", "NOT", "NEG", "RESULT", "EXCETPION", "CAST", "EQ", "NE", "LT", "GE", "GT", "LE", "EQZ", "NEZ", "LTZ", "GEZ", "GTZ", "LEZ", "AGET", "APUT", "ADD", "SUB", "MUL", "DIV", "REM", "AND", "OR", "XOR", "SHL", "SHR", "USHR", "CMPLONG", "CMPL", "CMPG", "SGET", "SPUT", "IGET", "IPUT", "TRYCATCH", "THROW"};
    public byte opcode = 0;
    public byte opcode_aux = 0;
    public short rdst = (short)-1;
    public short r0 = (short)-1;
    public short r1 = (short)-1;
    public ClassInfo type = null;
    public Object extra = null;

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("<");
        s.append(opname[this.opcode]);
        if (this.opcode_aux != 0) {
            s.append(",").append(opaux_name[this.opcode_aux]);
        }
        if (this.rdst != -1) {
            s.append(",dst=r").append(this.rdst);
        }
        if (this.r0 != -1) {
            s.append(",r0=r").append(this.r0);
        }
        if (this.r1 != -1) {
            s.append(",r1=r").append(this.r1);
        }
        if (this.type != null) {
            s.append(",type=").append(this.type.toString());
        }
        if (this.extra != null) {
            s.append(",extra=").append(this.extraToString());
        }
        s.append(">");
        return s.toString();
    }

    private String extraToString() {
        if (this.extra instanceof int[]) {
            return Arrays.toString((int[])this.extra);
        }
        if (this.extra instanceof Integer) {
            return "index:" + this.extra.toString();
        }
        if (this.extra instanceof String) {
            return "\"" + (String)this.extra + "\"";
        }
        if (this.extra instanceof Pair) {
            return this.extra.toString();
        }
        if (this.extra instanceof Map) {
            return this.extra.toString();
        }
        if (this.extra instanceof Object[]) {
            return Arrays.deepToString((Object[])this.extra);
        }
        if (this.extra instanceof FieldInfo) {
            return this.extra.toString();
        }
        return "?" + this.extra.toString();
    }
}

