/*
 * Decompiled with CFR 0.152.
 */
package patdroid.fs;

import java.util.zip.ZipFile;
import patdroid.fs.FileNode;
import patdroid.fs.ZipBackedNode;

public class EmulatedFS {
    public final FileNode root = new FileNode();
    private final FileNode procFS = new FileNode();
    private static final String CPUINFO = "Serial: 0000000000000000";
    private final FileNode sdcardFS = new FileNode();
    public ZipBackedNode apkAssets;

    public EmulatedFS() {
        this.procFS.setContent("/cpuinfo", CPUINFO);
        this.root.mount("/proc", this.procFS);
        this.root.mount("/sdcard", this.sdcardFS);
        this.root.mount("/mnt/sdcard", this.sdcardFS);
    }

    public EmulatedFS(ZipFile apkFile) {
        this();
        this.loadApk("TODO", apkFile);
    }

    public void loadApk(String pkgName, ZipFile apkFile) {
        this.apkAssets = new ZipBackedNode(apkFile, "assets/");
        this.root.mount("/data/" + pkgName, this.apkAssets);
    }
}

