/*
 * Decompiled with CFR 0.152.
 */
package patdroid.fs;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import patdroid.util.Pair;

public class FileNode {
    private final HashMap<String, FileNode> mountList = new HashMap();
    private final HashMap<String, byte[]> fileList = new HashMap();

    private static String[] norm(String path) {
        String[] elements = path.split("[/\\\\]");
        ArrayList<String> stack = new ArrayList<String>();
        for (String e : elements) {
            if (e.isEmpty() || e.equals(".")) continue;
            if (e.equals("..")) {
                if (!stack.isEmpty()) {
                    stack.remove(stack.size() - 1);
                    continue;
                }
                return null;
            }
            stack.add(e);
        }
        return stack.toArray(new String[stack.size()]);
    }

    private Pair<FileNode, String> dispatch(String path) {
        String[] norm = FileNode.norm(path);
        if (norm == null) {
            return null;
        }
        FileNode node = this;
        String newPath = "";
        for (String e : norm) {
            if (!node.mountList.containsKey(newPath = newPath + "/" + e)) continue;
            node = node.mountList.get(newPath);
            newPath = "";
        }
        return new Pair<FileNode, String>(node, newPath);
    }

    public final void mount(String path, FileNode node) {
        Pair<FileNode, String> u = this.dispatch(path);
        ((FileNode)u.first).mountHere((String)u.second, node);
    }

    protected void mountHere(String path, FileNode node) {
        this.mountList.put(path, node);
    }

    public final InputStream openRead(String path) {
        Pair<FileNode, String> u = this.dispatch(path);
        return ((FileNode)u.first).openReadHere((String)u.second);
    }

    protected InputStream openReadHere(String path) {
        byte[] content = this.fileList.get(path);
        if (content == null) {
            return null;
        }
        return new ByteArrayInputStream(content);
    }

    public final void setContent(String path, byte[] content) {
        Pair<FileNode, String> u = this.dispatch(path);
        ((FileNode)u.first).setContentHere((String)u.second, content);
    }

    public final void setContent(String path, String content) {
        this.setContent(path, content.getBytes());
    }

    protected void setContentHere(String path, byte[] content) {
        this.fileList.put(path, content);
    }
}

