/*
 * Decompiled with CFR 0.152.
 */
package patdroid.fs;

import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import patdroid.fs.FileNode;

public final class ZipBackedNode
extends FileNode {
    private final ZipFile zip;
    private final String prefix;

    public ZipBackedNode(ZipFile zip) {
        this(zip, "");
    }

    public ZipBackedNode(ZipFile zip, String prefix) {
        this.zip = zip;
        this.prefix = prefix;
    }

    @Override
    protected InputStream openReadHere(String path) {
        ZipEntry entry = this.zip.getEntry(this.prefix + path.substring(1));
        if (entry == null) {
            return null;
        }
        try {
            return this.zip.getInputStream(entry);
        }
        catch (IOException e) {
            return null;
        }
    }
}

