/*
 * Decompiled with CFR 0.152.
 */
package patdroid.permission;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import patdroid.core.ClassInfo;
import patdroid.core.MethodInfo;
import patdroid.permission.APIMapping;

public class PScoutParser {
    public static APIMapping parse(File f) throws IOException {
        APIMapping r = new APIMapping();
        BufferedReader br = new BufferedReader(new FileReader(f));
        String perm = "";
        String line = br.readLine();
        while (line != null) {
            perm = line.replace("Permission:", "");
            br.readLine();
            while ((line = br.readLine()) != null && line.startsWith("<")) {
                MethodInfo m = PScoutParser.parseMethod(line);
                r.add(m, perm);
            }
        }
        br.close();
        return r;
    }

    private static MethodInfo parseMethod(String line) {
        String s = line.substring(1, line.length() - 1);
        String[] a = s.split(":");
        String className = a[0];
        s = a[1];
        int pos = s.indexOf(40);
        a[0] = s.substring(0, pos);
        a[1] = s.substring(pos + 1, s.length() - 1);
        String returnType = a[0].trim().split(" ")[0];
        String methodName = a[0].trim().split(" ")[1];
        String[] paramTypes = a[1].replace(" ", "").split(",");
        MethodInfo mproto = MethodInfo.makePrototype(methodName, PScoutParser.findOrCreateClass(returnType), PScoutParser.findOrCreateClass(paramTypes), 0);
        ClassInfo ci = ClassInfo.findOrCreateClass(className);
        return ci == null ? null : ci.findMethod(mproto);
    }

    private static ClassInfo findOrCreateClass(String t) {
        if (!t.endsWith("[]")) {
            return ClassInfo.findOrCreateClass(t);
        }
        String baseType = t.substring(0, t.indexOf("[]"));
        int level = (t.length() - t.indexOf("[]")) / 2;
        String s = "";
        for (int i = 0; i < level; ++i) {
            s = s + "[";
        }
        s = baseType.equals("int") ? s + "I" : (baseType.equals("boolean") ? s + "B" : s + "L" + baseType + ";");
        return ClassInfo.findOrCreateClass(s);
    }

    public static ClassInfo[] findOrCreateClass(String[] fullNames) {
        ClassInfo[] a = new ClassInfo[fullNames.length];
        for (int i = 0; i < fullNames.length; ++i) {
            a[i] = PScoutParser.findOrCreateClass(fullNames[i]);
        }
        return a;
    }
}

