/*
 * Decompiled with CFR 0.152.
 */
package patdroid.smali;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jf.dexlib2.Opcode;
import org.jf.dexlib2.iface.ExceptionHandler;
import org.jf.dexlib2.iface.MethodImplementation;
import org.jf.dexlib2.iface.TryBlock;
import org.jf.dexlib2.iface.instruction.FiveRegisterInstruction;
import org.jf.dexlib2.iface.instruction.NarrowLiteralInstruction;
import org.jf.dexlib2.iface.instruction.OffsetInstruction;
import org.jf.dexlib2.iface.instruction.OneRegisterInstruction;
import org.jf.dexlib2.iface.instruction.PayloadInstruction;
import org.jf.dexlib2.iface.instruction.ReferenceInstruction;
import org.jf.dexlib2.iface.instruction.RegisterRangeInstruction;
import org.jf.dexlib2.iface.instruction.SwitchElement;
import org.jf.dexlib2.iface.instruction.SwitchPayload;
import org.jf.dexlib2.iface.instruction.ThreeRegisterInstruction;
import org.jf.dexlib2.iface.instruction.TwoRegisterInstruction;
import org.jf.dexlib2.iface.instruction.WideLiteralInstruction;
import org.jf.dexlib2.iface.instruction.formats.ArrayPayload;
import org.jf.dexlib2.iface.instruction.formats.Instruction10t;
import org.jf.dexlib2.iface.instruction.formats.Instruction10x;
import org.jf.dexlib2.iface.instruction.formats.Instruction11n;
import org.jf.dexlib2.iface.instruction.formats.Instruction11x;
import org.jf.dexlib2.iface.instruction.formats.Instruction12x;
import org.jf.dexlib2.iface.instruction.formats.Instruction20t;
import org.jf.dexlib2.iface.instruction.formats.Instruction21c;
import org.jf.dexlib2.iface.instruction.formats.Instruction21ih;
import org.jf.dexlib2.iface.instruction.formats.Instruction21lh;
import org.jf.dexlib2.iface.instruction.formats.Instruction21s;
import org.jf.dexlib2.iface.instruction.formats.Instruction21t;
import org.jf.dexlib2.iface.instruction.formats.Instruction22b;
import org.jf.dexlib2.iface.instruction.formats.Instruction22c;
import org.jf.dexlib2.iface.instruction.formats.Instruction22s;
import org.jf.dexlib2.iface.instruction.formats.Instruction22t;
import org.jf.dexlib2.iface.instruction.formats.Instruction22x;
import org.jf.dexlib2.iface.instruction.formats.Instruction23x;
import org.jf.dexlib2.iface.instruction.formats.Instruction30t;
import org.jf.dexlib2.iface.instruction.formats.Instruction31c;
import org.jf.dexlib2.iface.instruction.formats.Instruction31i;
import org.jf.dexlib2.iface.instruction.formats.Instruction31t;
import org.jf.dexlib2.iface.instruction.formats.Instruction32x;
import org.jf.dexlib2.iface.instruction.formats.Instruction35c;
import org.jf.dexlib2.iface.instruction.formats.Instruction3rc;
import org.jf.dexlib2.iface.instruction.formats.Instruction51l;
import org.jf.dexlib2.iface.instruction.formats.PackedSwitchPayload;
import org.jf.dexlib2.iface.instruction.formats.SparseSwitchPayload;
import org.jf.dexlib2.iface.reference.FieldReference;
import org.jf.dexlib2.iface.reference.MethodReference;
import org.jf.dexlib2.iface.reference.StringReference;
import org.jf.dexlib2.iface.reference.TypeReference;
import patdroid.core.ClassInfo;
import patdroid.core.FieldInfo;
import patdroid.core.MethodInfo;
import patdroid.core.PrimitiveInfo;
import patdroid.core.TryBlockInfo;
import patdroid.dalvik.Dalvik;
import patdroid.dalvik.Instruction;
import patdroid.dalvik.InvocationResolver;
import patdroid.smali.SmaliClassDetailLoader;
import patdroid.util.Log;
import patdroid.util.Pair;

public final class MethodImplementationTranslator {
    private final InvocationResolver resolver;
    private MethodInfo mi;
    private int currentCodeAddress;
    private int currentCodeIndex;
    private final HashMap<Integer, Integer> addressToIndex = new HashMap();
    private final HashMap<Integer, ArrayList<Instruction>> unresolvedInsns = new HashMap();
    private final HashMap<Integer, ArrayList<Instruction>> payloadDefers = new HashMap();
    private final HashMap<Integer, PayloadInstruction> payloadCache = new HashMap();

    MethodImplementationTranslator(InvocationResolver resolver) {
        this.resolver = resolver;
    }

    private static Instruction translateReturn(Instruction10x i0) {
        Instruction i = new Instruction();
        i.opcode = (byte)2;
        i.opcode_aux = (byte)3;
        return i;
    }

    private static Instruction translateReturn(Instruction11x i1) {
        Instruction i = new Instruction();
        i.opcode = (byte)2;
        i.opcode_aux = (byte)4;
        i.r0 = (short)i1.getRegisterA();
        switch (i1.getOpcode()) {
            case RETURN: {
                i.type = ClassInfo.primitiveVoid;
                break;
            }
            case RETURN_WIDE: {
                i.type = ClassInfo.primitiveWide;
                break;
            }
            case RETURN_OBJECT: {
                i.type = ClassInfo.rootObject;
            }
        }
        return i;
    }

    private static Instruction translateMove(OneRegisterInstruction i1) {
        Instruction i = new Instruction();
        i.opcode = 1;
        i.rdst = (short)i1.getRegisterA();
        switch (i1.getOpcode()) {
            case MOVE_RESULT: {
                i.opcode_aux = (byte)21;
                i.type = ClassInfo.primitiveVoid;
                break;
            }
            case MOVE_RESULT_WIDE: {
                i.opcode_aux = (byte)21;
                i.type = ClassInfo.primitiveWide;
                break;
            }
            case MOVE_RESULT_OBJECT: {
                i.opcode_aux = (byte)21;
                i.type = ClassInfo.rootObject;
                break;
            }
            case MOVE_EXCEPTION: {
                i.opcode_aux = (byte)22;
                i.type = ClassInfo.rootObject;
            }
        }
        return i;
    }

    private static Instruction translateMove(TwoRegisterInstruction i2) {
        Instruction i = new Instruction();
        i.opcode = 1;
        i.opcode_aux = 1;
        i.rdst = (short)i2.getRegisterA();
        i.r0 = (short)i2.getRegisterB();
        switch (i2.getOpcode()) {
            case MOVE: 
            case MOVE_FROM16: 
            case MOVE_16: {
                i.type = ClassInfo.primitiveVoid;
                break;
            }
            case MOVE_WIDE: 
            case MOVE_WIDE_FROM16: 
            case MOVE_WIDE_16: {
                i.type = ClassInfo.primitiveWide;
                break;
            }
            case MOVE_OBJECT: 
            case MOVE_OBJECT_FROM16: 
            case MOVE_OBJECT_16: {
                i.type = ClassInfo.rootObject;
            }
        }
        return i;
    }

    private static Instruction translateConst(OneRegisterInstruction i1) {
        Instruction i = new Instruction();
        i.opcode = 1;
        i.opcode_aux = (byte)2;
        i.rdst = (short)i1.getRegisterA();
        switch (i1.getOpcode()) {
            case CONST_4: 
            case CONST_16: 
            case CONST: 
            case CONST_HIGH16: {
                i.type = ClassInfo.primitiveVoid;
                i.extra = new PrimitiveInfo(((NarrowLiteralInstruction)i1).getNarrowLiteral());
                break;
            }
            case CONST_WIDE_16: 
            case CONST_WIDE_32: 
            case CONST_WIDE: 
            case CONST_WIDE_HIGH16: {
                i.type = ClassInfo.primitiveWide;
                i.extra = new PrimitiveInfo(((WideLiteralInstruction)i1).getWideLiteral());
                break;
            }
            case CONST_STRING: 
            case CONST_STRING_JUMBO: {
                i.type = ClassInfo.findOrCreateClass(String.class);
                i.extra = ((StringReference)((ReferenceInstruction)i1).getReference()).getString();
                break;
            }
            case CONST_CLASS: {
                i.type = ClassInfo.findOrCreateClass(Class.class);
                i.extra = Dalvik.findOrCreateClass(((TypeReference)((ReferenceInstruction)i1).getReference()).getType());
            }
        }
        return i;
    }

    private static Instruction translateSpecial(Instruction11x i1) {
        Instruction i = new Instruction();
        i.opcode = (byte)3;
        i.rdst = (short)i1.getRegisterA();
        switch (i1.getOpcode()) {
            case MONITOR_ENTER: {
                i.opcode_aux = (byte)5;
                break;
            }
            case MONITOR_EXIT: {
                i.opcode_aux = (byte)6;
            }
        }
        return i;
    }

    private static Instruction translateArithmetic(OneRegisterInstruction i1) {
        Instruction i = new Instruction();
        i.opcode = (byte)13;
        i.rdst = (short)i1.getRegisterA();
        switch (i1.getOpcode()) {
            case CHECK_CAST: {
                i.opcode_aux = (byte)18;
                i.type = Dalvik.findOrCreateClass(((TypeReference)((ReferenceInstruction)i1).getReference()).getType());
            }
        }
        return i;
    }

    private static Instruction translateArithmetic(TwoRegisterInstruction i2) {
        Instruction i = new Instruction();
        i.opcode = (byte)13;
        i.rdst = (short)i2.getRegisterA();
        i.r0 = (short)i2.getRegisterB();
        switch (i2.getOpcode()) {
            case INSTANCE_OF: {
                i.opcode_aux = (byte)16;
                i.type = Dalvik.findOrCreateClass(((TypeReference)((ReferenceInstruction)i2).getReference()).getType());
                break;
            }
            case ARRAY_LENGTH: {
                i.opcode_aux = (byte)17;
                i.type = ClassInfo.primitiveInt;
                break;
            }
            case NEG_INT: {
                i.opcode_aux = (byte)20;
                i.type = ClassInfo.primitiveInt;
                break;
            }
            case NOT_INT: {
                i.opcode_aux = (byte)19;
                i.type = ClassInfo.primitiveInt;
                break;
            }
            case NEG_LONG: {
                i.opcode_aux = (byte)20;
                i.type = ClassInfo.primitiveLong;
                break;
            }
            case NOT_LONG: {
                i.opcode_aux = (byte)19;
                i.type = ClassInfo.primitiveLong;
                break;
            }
            case NEG_FLOAT: {
                i.opcode_aux = (byte)20;
                i.type = ClassInfo.primitiveFloat;
                break;
            }
            case NEG_DOUBLE: {
                i.opcode_aux = (byte)20;
                i.type = ClassInfo.primitiveDouble;
                break;
            }
            case INT_TO_LONG: {
                i.opcode_aux = (byte)23;
                i.type = ClassInfo.primitiveLong;
                i.extra = ClassInfo.primitiveInt;
                break;
            }
            case INT_TO_FLOAT: {
                i.opcode_aux = (byte)23;
                i.type = ClassInfo.primitiveFloat;
                i.extra = ClassInfo.primitiveInt;
                break;
            }
            case INT_TO_DOUBLE: {
                i.opcode_aux = (byte)23;
                i.type = ClassInfo.primitiveDouble;
                i.extra = ClassInfo.primitiveInt;
                break;
            }
            case LONG_TO_INT: {
                i.opcode_aux = (byte)23;
                i.type = ClassInfo.primitiveInt;
                i.extra = ClassInfo.primitiveLong;
                break;
            }
            case LONG_TO_FLOAT: {
                i.opcode_aux = (byte)23;
                i.type = ClassInfo.primitiveFloat;
                i.extra = ClassInfo.primitiveLong;
                break;
            }
            case LONG_TO_DOUBLE: {
                i.opcode_aux = (byte)23;
                i.type = ClassInfo.primitiveDouble;
                i.extra = ClassInfo.primitiveLong;
                break;
            }
            case FLOAT_TO_INT: {
                i.opcode_aux = (byte)23;
                i.type = ClassInfo.primitiveInt;
                i.extra = ClassInfo.primitiveFloat;
                break;
            }
            case FLOAT_TO_LONG: {
                i.opcode_aux = (byte)23;
                i.type = ClassInfo.primitiveLong;
                i.extra = ClassInfo.primitiveFloat;
                break;
            }
            case FLOAT_TO_DOUBLE: {
                i.opcode_aux = (byte)23;
                i.type = ClassInfo.primitiveDouble;
                i.extra = ClassInfo.primitiveFloat;
                break;
            }
            case DOUBLE_TO_INT: {
                i.opcode_aux = (byte)23;
                i.type = ClassInfo.primitiveInt;
                i.extra = ClassInfo.primitiveDouble;
                break;
            }
            case DOUBLE_TO_LONG: {
                i.opcode_aux = (byte)23;
                i.type = ClassInfo.primitiveLong;
                i.extra = ClassInfo.primitiveDouble;
                break;
            }
            case DOUBLE_TO_FLOAT: {
                i.opcode_aux = (byte)23;
                i.type = ClassInfo.primitiveFloat;
                i.extra = ClassInfo.primitiveDouble;
                break;
            }
            case INT_TO_BYTE: {
                i.opcode_aux = (byte)23;
                i.type = ClassInfo.primitiveByte;
                i.extra = ClassInfo.primitiveInt;
                break;
            }
            case INT_TO_CHAR: {
                i.opcode_aux = (byte)23;
                i.type = ClassInfo.primitiveChar;
                i.extra = ClassInfo.primitiveInt;
                break;
            }
            case INT_TO_SHORT: {
                i.opcode_aux = (byte)23;
                i.type = ClassInfo.primitiveShort;
                i.extra = ClassInfo.primitiveInt;
            }
        }
        return i;
    }

    private static Instruction translateArithmetic(ThreeRegisterInstruction i3) {
        Instruction i = new Instruction();
        i.opcode = (byte)13;
        i.rdst = (short)i3.getRegisterA();
        i.r0 = (short)i3.getRegisterB();
        i.r1 = (short)i3.getRegisterC();
        switch (i3.getOpcode()) {
            case ADD_INT: {
                i.opcode_aux = (byte)38;
                i.type = ClassInfo.primitiveInt;
                break;
            }
            case SUB_INT: {
                i.opcode_aux = (byte)39;
                i.type = ClassInfo.primitiveInt;
                break;
            }
            case MUL_INT: {
                i.opcode_aux = (byte)40;
                i.type = ClassInfo.primitiveInt;
                break;
            }
            case DIV_INT: {
                i.opcode_aux = (byte)41;
                i.type = ClassInfo.primitiveInt;
                break;
            }
            case REM_INT: {
                i.opcode_aux = (byte)42;
                i.type = ClassInfo.primitiveInt;
                break;
            }
            case AND_INT: {
                i.opcode_aux = (byte)43;
                i.type = ClassInfo.primitiveInt;
                break;
            }
            case OR_INT: {
                i.opcode_aux = (byte)44;
                i.type = ClassInfo.primitiveInt;
                break;
            }
            case XOR_INT: {
                i.opcode_aux = (byte)45;
                i.type = ClassInfo.primitiveInt;
                break;
            }
            case SHL_INT: {
                i.opcode_aux = (byte)46;
                i.type = ClassInfo.primitiveInt;
                break;
            }
            case SHR_INT: {
                i.opcode_aux = (byte)47;
                i.type = ClassInfo.primitiveInt;
                break;
            }
            case USHR_INT: {
                i.opcode_aux = (byte)48;
                i.type = ClassInfo.primitiveInt;
                break;
            }
            case ADD_LONG: {
                i.opcode_aux = (byte)38;
                i.type = ClassInfo.primitiveLong;
                break;
            }
            case SUB_LONG: {
                i.opcode_aux = (byte)39;
                i.type = ClassInfo.primitiveLong;
                break;
            }
            case MUL_LONG: {
                i.opcode_aux = (byte)40;
                i.type = ClassInfo.primitiveLong;
                break;
            }
            case DIV_LONG: {
                i.opcode_aux = (byte)41;
                i.type = ClassInfo.primitiveLong;
                break;
            }
            case REM_LONG: {
                i.opcode_aux = (byte)42;
                i.type = ClassInfo.primitiveLong;
                break;
            }
            case AND_LONG: {
                i.opcode_aux = (byte)43;
                i.type = ClassInfo.primitiveLong;
                break;
            }
            case OR_LONG: {
                i.opcode_aux = (byte)44;
                i.type = ClassInfo.primitiveLong;
                break;
            }
            case XOR_LONG: {
                i.opcode_aux = (byte)45;
                i.type = ClassInfo.primitiveLong;
                break;
            }
            case SHL_LONG: {
                i.opcode_aux = (byte)46;
                i.type = ClassInfo.primitiveLong;
                break;
            }
            case SHR_LONG: {
                i.opcode_aux = (byte)47;
                i.type = ClassInfo.primitiveLong;
                break;
            }
            case USHR_LONG: {
                i.opcode_aux = (byte)48;
                i.type = ClassInfo.primitiveLong;
                break;
            }
            case ADD_FLOAT: {
                i.opcode_aux = (byte)38;
                i.type = ClassInfo.primitiveFloat;
                break;
            }
            case SUB_FLOAT: {
                i.opcode_aux = (byte)39;
                i.type = ClassInfo.primitiveFloat;
                break;
            }
            case MUL_FLOAT: {
                i.opcode_aux = (byte)40;
                i.type = ClassInfo.primitiveFloat;
                break;
            }
            case DIV_FLOAT: {
                i.opcode_aux = (byte)41;
                i.type = ClassInfo.primitiveFloat;
                break;
            }
            case REM_FLOAT: {
                i.opcode_aux = (byte)42;
                i.type = ClassInfo.primitiveFloat;
                break;
            }
            case ADD_DOUBLE: {
                i.opcode_aux = (byte)38;
                i.type = ClassInfo.primitiveDouble;
                break;
            }
            case SUB_DOUBLE: {
                i.opcode_aux = (byte)39;
                i.type = ClassInfo.primitiveDouble;
                break;
            }
            case MUL_DOUBLE: {
                i.opcode_aux = (byte)40;
                i.type = ClassInfo.primitiveDouble;
                break;
            }
            case DIV_DOUBLE: {
                i.opcode_aux = (byte)41;
                i.type = ClassInfo.primitiveDouble;
                break;
            }
            case REM_DOUBLE: {
                i.opcode_aux = (byte)42;
                i.type = ClassInfo.primitiveDouble;
            }
        }
        return i;
    }

    private static Instruction translateArithmeticTwoAddr(TwoRegisterInstruction i2) {
        Instruction i = new Instruction();
        i.opcode = (byte)13;
        i.rdst = i.r0 = (short)i2.getRegisterA();
        i.r1 = (short)i2.getRegisterB();
        switch (i2.getOpcode()) {
            case ADD_INT_2ADDR: {
                i.opcode_aux = (byte)38;
                i.type = ClassInfo.primitiveInt;
                break;
            }
            case SUB_INT_2ADDR: {
                i.opcode_aux = (byte)39;
                i.type = ClassInfo.primitiveInt;
                break;
            }
            case MUL_INT_2ADDR: {
                i.opcode_aux = (byte)40;
                i.type = ClassInfo.primitiveInt;
                break;
            }
            case DIV_INT_2ADDR: {
                i.opcode_aux = (byte)41;
                i.type = ClassInfo.primitiveInt;
                break;
            }
            case REM_INT_2ADDR: {
                i.opcode_aux = (byte)42;
                i.type = ClassInfo.primitiveInt;
                break;
            }
            case AND_INT_2ADDR: {
                i.opcode_aux = (byte)43;
                i.type = ClassInfo.primitiveInt;
                break;
            }
            case OR_INT_2ADDR: {
                i.opcode_aux = (byte)44;
                i.type = ClassInfo.primitiveInt;
                break;
            }
            case XOR_INT_2ADDR: {
                i.opcode_aux = (byte)45;
                i.type = ClassInfo.primitiveInt;
                break;
            }
            case SHL_INT_2ADDR: {
                i.opcode_aux = (byte)46;
                i.type = ClassInfo.primitiveInt;
                break;
            }
            case SHR_INT_2ADDR: {
                i.opcode_aux = (byte)47;
                i.type = ClassInfo.primitiveInt;
                break;
            }
            case USHR_INT_2ADDR: {
                i.opcode_aux = (byte)48;
                i.type = ClassInfo.primitiveInt;
                break;
            }
            case ADD_LONG_2ADDR: {
                i.opcode_aux = (byte)38;
                i.type = ClassInfo.primitiveLong;
                break;
            }
            case SUB_LONG_2ADDR: {
                i.opcode_aux = (byte)39;
                i.type = ClassInfo.primitiveLong;
                break;
            }
            case MUL_LONG_2ADDR: {
                i.opcode_aux = (byte)40;
                i.type = ClassInfo.primitiveLong;
                break;
            }
            case DIV_LONG_2ADDR: {
                i.opcode_aux = (byte)41;
                i.type = ClassInfo.primitiveLong;
                break;
            }
            case REM_LONG_2ADDR: {
                i.opcode_aux = (byte)42;
                i.type = ClassInfo.primitiveLong;
                break;
            }
            case AND_LONG_2ADDR: {
                i.opcode_aux = (byte)43;
                i.type = ClassInfo.primitiveLong;
                break;
            }
            case OR_LONG_2ADDR: {
                i.opcode_aux = (byte)44;
                i.type = ClassInfo.primitiveLong;
                break;
            }
            case XOR_LONG_2ADDR: {
                i.opcode_aux = (byte)45;
                i.type = ClassInfo.primitiveLong;
                break;
            }
            case SHL_LONG_2ADDR: {
                i.opcode_aux = (byte)46;
                i.type = ClassInfo.primitiveLong;
                break;
            }
            case SHR_LONG_2ADDR: {
                i.opcode_aux = (byte)47;
                i.type = ClassInfo.primitiveLong;
                break;
            }
            case USHR_LONG_2ADDR: {
                i.opcode_aux = (byte)48;
                i.type = ClassInfo.primitiveLong;
                break;
            }
            case ADD_FLOAT_2ADDR: {
                i.opcode_aux = (byte)38;
                i.type = ClassInfo.primitiveFloat;
                break;
            }
            case SUB_FLOAT_2ADDR: {
                i.opcode_aux = (byte)39;
                i.type = ClassInfo.primitiveFloat;
                break;
            }
            case MUL_FLOAT_2ADDR: {
                i.opcode_aux = (byte)40;
                i.type = ClassInfo.primitiveFloat;
                break;
            }
            case DIV_FLOAT_2ADDR: {
                i.opcode_aux = (byte)41;
                i.type = ClassInfo.primitiveFloat;
                break;
            }
            case REM_FLOAT_2ADDR: {
                i.opcode_aux = (byte)42;
                i.type = ClassInfo.primitiveFloat;
                break;
            }
            case ADD_DOUBLE_2ADDR: {
                i.opcode_aux = (byte)38;
                i.type = ClassInfo.primitiveDouble;
                break;
            }
            case SUB_DOUBLE_2ADDR: {
                i.opcode_aux = (byte)39;
                i.type = ClassInfo.primitiveDouble;
                break;
            }
            case MUL_DOUBLE_2ADDR: {
                i.opcode_aux = (byte)40;
                i.type = ClassInfo.primitiveDouble;
                break;
            }
            case DIV_DOUBLE_2ADDR: {
                i.opcode_aux = (byte)41;
                i.type = ClassInfo.primitiveDouble;
                break;
            }
            case REM_DOUBLE_2ADDR: {
                i.opcode_aux = (byte)42;
                i.type = ClassInfo.primitiveDouble;
            }
        }
        return i;
    }

    private static Instruction translateArithmeticLit(TwoRegisterInstruction i2) {
        Instruction i = new Instruction();
        i.opcode = (byte)13;
        i.rdst = (short)i2.getRegisterA();
        i.r0 = (short)i2.getRegisterB();
        i.extra = new PrimitiveInfo(((NarrowLiteralInstruction)i2).getNarrowLiteral());
        switch (i2.getOpcode()) {
            case ADD_INT_LIT16: 
            case ADD_INT_LIT8: {
                i.opcode_aux = (byte)38;
                break;
            }
            case RSUB_INT: 
            case RSUB_INT_LIT8: {
                i.opcode_aux = (byte)39;
                break;
            }
            case MUL_INT_LIT16: 
            case MUL_INT_LIT8: {
                i.opcode_aux = (byte)40;
                break;
            }
            case DIV_INT_LIT16: 
            case DIV_INT_LIT8: {
                i.opcode_aux = (byte)41;
                break;
            }
            case REM_INT_LIT16: 
            case REM_INT_LIT8: {
                i.opcode_aux = (byte)42;
                break;
            }
            case AND_INT_LIT16: 
            case AND_INT_LIT8: {
                i.opcode_aux = (byte)43;
                break;
            }
            case OR_INT_LIT16: 
            case OR_INT_LIT8: {
                i.opcode_aux = (byte)44;
                break;
            }
            case XOR_INT_LIT16: 
            case XOR_INT_LIT8: {
                i.opcode_aux = (byte)45;
                break;
            }
            case SHL_INT_LIT8: {
                i.opcode_aux = (byte)46;
                break;
            }
            case SHR_INT_LIT8: {
                i.opcode_aux = (byte)47;
                break;
            }
            case USHR_INT_LIT8: {
                i.opcode_aux = (byte)48;
            }
        }
        return i;
    }

    private static Instruction translateNew(Instruction21c i1) {
        Instruction i = new Instruction();
        i.opcode = (byte)4;
        i.opcode_aux = (byte)8;
        i.rdst = (short)i1.getRegisterA();
        i.type = Dalvik.findOrCreateClass(((TypeReference)i1.getReference()).getType());
        return i;
    }

    private static Instruction translateNew(Instruction22c i2) {
        Instruction i = new Instruction();
        i.opcode = (byte)4;
        i.opcode_aux = (byte)9;
        i.rdst = (short)i2.getRegisterA();
        i.r0 = (short)i2.getRegisterB();
        i.type = Dalvik.findOrCreateClass(((TypeReference)i2.getReference()).getType());
        return i;
    }

    private static int[] getArguments(FiveRegisterInstruction i5) {
        int[] args = new int[i5.getRegisterCount()];
        if (args.length > 0) {
            args[0] = i5.getRegisterC();
        }
        if (args.length > 1) {
            args[1] = i5.getRegisterD();
        }
        if (args.length > 2) {
            args[2] = i5.getRegisterE();
        }
        if (args.length > 3) {
            args[3] = i5.getRegisterF();
        }
        if (args.length > 4) {
            args[4] = i5.getRegisterG();
        }
        return args;
    }

    private static Instruction translateNew(Instruction35c i5) {
        Instruction i = new Instruction();
        i.opcode = (byte)4;
        i.opcode_aux = (byte)10;
        i.rdst = (short)-1;
        i.type = Dalvik.findOrCreateClass(((TypeReference)i5.getReference()).getType());
        i.extra = MethodImplementationTranslator.getArguments((FiveRegisterInstruction)i5);
        return i;
    }

    private static int[] getArguments(RegisterRangeInstruction ir) {
        int[] args = new int[ir.getRegisterCount()];
        int start = ir.getStartRegister();
        for (int i = 0; i < args.length; ++i) {
            args[i] = start + i;
        }
        return args;
    }

    private static Instruction translateNew(Instruction3rc ir) {
        Instruction i = new Instruction();
        i.opcode = (byte)4;
        i.opcode_aux = (byte)10;
        i.rdst = (short)-1;
        i.type = Dalvik.findOrCreateClass(((TypeReference)ir.getReference()).getType());
        i.extra = MethodImplementationTranslator.getArguments((RegisterRangeInstruction)ir);
        return i;
    }

    private Instruction translateNew(Instruction31t i1) {
        Instruction i = new Instruction();
        i.opcode = (byte)4;
        i.opcode_aux = (byte)10;
        i.rdst = (short)i1.getRegisterA();
        int payloadAddress = this.currentCodeAddress + i1.getCodeOffset();
        PayloadInstruction p = this.payloadCache.get(payloadAddress);
        if (p != null) {
            Log.doAssert(p.getOpcode() == Opcode.ARRAY_PAYLOAD, "payload type mismatch");
            this.applyPayload(i, (PayloadInstruction)((ArrayPayload)p));
        } else {
            ArrayList<Instruction> defers = this.payloadDefers.get(payloadAddress);
            if (defers == null) {
                defers = new ArrayList();
                this.payloadDefers.put(payloadAddress, defers);
            }
            defers.add(i);
        }
        return i;
    }

    private Instruction translateExceptionOp(Instruction11x i1) {
        Instruction i = new Instruction();
        i.opcode = (byte)5;
        i.opcode_aux = (byte)57;
        i.r0 = (short)i1.getRegisterA();
        i.type = ClassInfo.rootObject;
        return i;
    }

    private Instruction translateGoto(OffsetInstruction io) {
        Instruction i = new Instruction();
        i.opcode = (byte)6;
        int destAddress = this.currentCodeAddress + io.getCodeOffset();
        i.extra = this.addressToIndex.get(destAddress);
        if (i.extra == null) {
            ArrayList<Instruction> insns = this.unresolvedInsns.get(destAddress);
            if (insns == null) {
                insns = new ArrayList();
                this.unresolvedInsns.put(destAddress, insns);
            }
            insns.add(i);
        }
        return i;
    }

    private Instruction translateSwitch(Instruction31t i1) {
        Instruction i = new Instruction();
        i.opcode = (byte)14;
        i.r0 = (short)i1.getRegisterA();
        i.extra = this.currentCodeAddress;
        int payloadAddress = this.currentCodeAddress + i1.getCodeOffset();
        PayloadInstruction p = this.payloadCache.get(payloadAddress);
        if (p != null) {
            Opcode opcode = p.getOpcode();
            Log.doAssert(opcode == Opcode.PACKED_SWITCH_PAYLOAD || opcode == Opcode.SPARSE_SWITCH_PAYLOAD, "payload type mismatch");
            this.applyPayload(i, (PayloadInstruction)((SwitchPayload)p));
        } else {
            ArrayList<Instruction> defers = this.payloadDefers.get(payloadAddress);
            if (defers == null) {
                defers = new ArrayList();
                this.payloadDefers.put(payloadAddress, defers);
            }
            defers.add(i);
        }
        return i;
    }

    private Instruction translateCmp(Instruction23x i3) {
        Instruction i = new Instruction();
        i.opcode = (byte)7;
        i.rdst = (short)i3.getRegisterA();
        i.r0 = (short)i3.getRegisterB();
        i.r1 = (short)i3.getRegisterC();
        switch (i3.getOpcode()) {
            case CMPL_FLOAT: {
                i.opcode_aux = (byte)50;
                i.type = ClassInfo.primitiveFloat;
                break;
            }
            case CMPG_FLOAT: {
                i.opcode_aux = (byte)51;
                i.type = ClassInfo.primitiveFloat;
                break;
            }
            case CMPL_DOUBLE: {
                i.opcode_aux = (byte)50;
                i.type = ClassInfo.primitiveDouble;
                break;
            }
            case CMPG_DOUBLE: {
                i.opcode_aux = (byte)51;
                i.type = ClassInfo.primitiveDouble;
                break;
            }
            case CMP_LONG: {
                i.opcode_aux = (byte)49;
                i.type = ClassInfo.primitiveLong;
            }
        }
        return i;
    }

    private Instruction translateIf(Instruction22t i2) {
        Instruction i = new Instruction();
        i.opcode = (byte)8;
        switch (i2.getOpcode()) {
            case IF_EQ: {
                i.opcode_aux = (byte)24;
                break;
            }
            case IF_NE: {
                i.opcode_aux = (byte)25;
                break;
            }
            case IF_LT: {
                i.opcode_aux = (byte)26;
                break;
            }
            case IF_GE: {
                i.opcode_aux = (byte)27;
                break;
            }
            case IF_GT: {
                i.opcode_aux = (byte)28;
                break;
            }
            case IF_LE: {
                i.opcode_aux = (byte)29;
            }
        }
        i.r0 = (short)i2.getRegisterA();
        i.r1 = (short)i2.getRegisterB();
        int destAddress = this.currentCodeAddress + i2.getCodeOffset();
        i.extra = this.addressToIndex.get(destAddress);
        if (i.extra == null) {
            ArrayList<Instruction> insns = this.unresolvedInsns.get(destAddress);
            if (insns == null) {
                insns = new ArrayList();
                this.unresolvedInsns.put(destAddress, insns);
            }
            insns.add(i);
        }
        return i;
    }

    private Instruction translateIf(Instruction21t i1) {
        Instruction i = new Instruction();
        i.opcode = (byte)8;
        switch (i1.getOpcode()) {
            case IF_EQZ: {
                i.opcode_aux = (byte)30;
                break;
            }
            case IF_NEZ: {
                i.opcode_aux = (byte)31;
                break;
            }
            case IF_LTZ: {
                i.opcode_aux = (byte)32;
                break;
            }
            case IF_GEZ: {
                i.opcode_aux = (byte)33;
                break;
            }
            case IF_GTZ: {
                i.opcode_aux = (byte)34;
                break;
            }
            case IF_LEZ: {
                i.opcode_aux = (byte)35;
            }
        }
        i.r0 = (short)i1.getRegisterA();
        int destAddress = this.currentCodeAddress + i1.getCodeOffset();
        i.extra = this.addressToIndex.get(destAddress);
        if (i.extra == null) {
            ArrayList<Instruction> insns = this.unresolvedInsns.get(destAddress);
            if (insns == null) {
                insns = new ArrayList();
                this.unresolvedInsns.put(destAddress, insns);
            }
            insns.add(i);
        }
        return i;
    }

    private Instruction translateArrayOp(Instruction23x i3) {
        Instruction i = new Instruction();
        i.opcode = (byte)10;
        i.rdst = (short)i3.getRegisterA();
        i.r0 = (short)i3.getRegisterB();
        i.r1 = (short)i3.getRegisterC();
        switch (i3.getOpcode()) {
            case AGET: {
                i.opcode_aux = (byte)36;
                i.type = ClassInfo.primitiveVoid;
                break;
            }
            case AGET_WIDE: {
                i.opcode_aux = (byte)36;
                i.type = ClassInfo.primitiveWide;
                break;
            }
            case AGET_OBJECT: {
                i.opcode_aux = (byte)36;
                i.type = ClassInfo.rootObject;
                break;
            }
            case AGET_BOOLEAN: {
                i.opcode_aux = (byte)36;
                i.type = ClassInfo.primitiveBoolean;
                break;
            }
            case AGET_BYTE: {
                i.opcode_aux = (byte)36;
                i.type = ClassInfo.primitiveByte;
                break;
            }
            case AGET_CHAR: {
                i.opcode_aux = (byte)36;
                i.type = ClassInfo.primitiveChar;
                break;
            }
            case AGET_SHORT: {
                i.opcode_aux = (byte)36;
                i.type = ClassInfo.primitiveShort;
                break;
            }
            case APUT: {
                i.opcode_aux = (byte)37;
                i.type = ClassInfo.primitiveVoid;
                break;
            }
            case APUT_WIDE: {
                i.opcode_aux = (byte)37;
                i.type = ClassInfo.primitiveWide;
                break;
            }
            case APUT_OBJECT: {
                i.opcode_aux = (byte)37;
                i.type = ClassInfo.rootObject;
                break;
            }
            case APUT_BOOLEAN: {
                i.opcode_aux = (byte)37;
                i.type = ClassInfo.primitiveBoolean;
                break;
            }
            case APUT_BYTE: {
                i.opcode_aux = (byte)37;
                i.type = ClassInfo.primitiveByte;
                break;
            }
            case APUT_CHAR: {
                i.opcode_aux = (byte)37;
                i.type = ClassInfo.primitiveChar;
                break;
            }
            case APUT_SHORT: {
                i.opcode_aux = (byte)37;
                i.type = ClassInfo.primitiveShort;
            }
        }
        return i;
    }

    private Instruction translateInstanceOp(Instruction22c i2) {
        Instruction i = new Instruction();
        i.opcode = (byte)9;
        i.r0 = (short)i2.getRegisterB();
        i.r1 = (short)i2.getRegisterA();
        FieldReference field = (FieldReference)i2.getReference();
        ClassInfo owner = Dalvik.findOrCreateClass(field.getDefiningClass());
        i.extra = new FieldInfo(owner, field.getName());
        switch (i2.getOpcode()) {
            case IGET: {
                i.opcode_aux = (byte)54;
                i.type = ClassInfo.primitiveVoid;
                break;
            }
            case IGET_WIDE: {
                i.opcode_aux = (byte)54;
                i.type = ClassInfo.primitiveWide;
                break;
            }
            case IGET_OBJECT: {
                i.opcode_aux = (byte)54;
                i.type = ClassInfo.rootObject;
                break;
            }
            case IGET_BOOLEAN: {
                i.opcode_aux = (byte)54;
                i.type = ClassInfo.primitiveBoolean;
                break;
            }
            case IGET_BYTE: {
                i.opcode_aux = (byte)54;
                i.type = ClassInfo.primitiveByte;
                break;
            }
            case IGET_CHAR: {
                i.opcode_aux = (byte)54;
                i.type = ClassInfo.primitiveChar;
                break;
            }
            case IGET_SHORT: {
                i.opcode_aux = (byte)54;
                i.type = ClassInfo.primitiveShort;
                break;
            }
            case IPUT: {
                i.opcode_aux = (byte)55;
                i.type = ClassInfo.primitiveVoid;
                break;
            }
            case IPUT_WIDE: {
                i.opcode_aux = (byte)55;
                i.type = ClassInfo.primitiveWide;
                break;
            }
            case IPUT_OBJECT: {
                i.opcode_aux = (byte)55;
                i.type = ClassInfo.rootObject;
                break;
            }
            case IPUT_BOOLEAN: {
                i.opcode_aux = (byte)55;
                i.type = ClassInfo.primitiveBoolean;
                break;
            }
            case IPUT_BYTE: {
                i.opcode_aux = (byte)55;
                i.type = ClassInfo.primitiveByte;
                break;
            }
            case IPUT_CHAR: {
                i.opcode_aux = (byte)55;
                i.type = ClassInfo.primitiveChar;
                break;
            }
            case IPUT_SHORT: {
                i.opcode_aux = (byte)55;
                i.type = ClassInfo.primitiveShort;
            }
        }
        return i;
    }

    private Instruction translateStaticOp(Instruction21c i1) {
        Instruction i = new Instruction();
        i.opcode = (byte)11;
        i.r0 = (short)i1.getRegisterA();
        FieldReference field = (FieldReference)i1.getReference();
        ClassInfo owner = Dalvik.findOrCreateClass(field.getDefiningClass());
        i.extra = new Pair<ClassInfo, String>(owner, field.getName());
        switch (i1.getOpcode()) {
            case SGET: {
                i.opcode_aux = (byte)52;
                i.type = ClassInfo.primitiveVoid;
                break;
            }
            case SGET_WIDE: {
                i.opcode_aux = (byte)52;
                i.type = ClassInfo.primitiveWide;
                break;
            }
            case SGET_OBJECT: {
                i.opcode_aux = (byte)52;
                i.type = ClassInfo.rootObject;
                break;
            }
            case SGET_BOOLEAN: {
                i.opcode_aux = (byte)52;
                i.type = ClassInfo.primitiveBoolean;
                break;
            }
            case SGET_BYTE: {
                i.opcode_aux = (byte)52;
                i.type = ClassInfo.primitiveByte;
                break;
            }
            case SGET_CHAR: {
                i.opcode_aux = (byte)52;
                i.type = ClassInfo.primitiveChar;
                break;
            }
            case SGET_SHORT: {
                i.opcode_aux = (byte)52;
                i.type = ClassInfo.primitiveShort;
                break;
            }
            case SPUT: {
                i.opcode_aux = (byte)53;
                i.type = ClassInfo.primitiveVoid;
                break;
            }
            case SPUT_WIDE: {
                i.opcode_aux = (byte)53;
                i.type = ClassInfo.primitiveWide;
                break;
            }
            case SPUT_OBJECT: {
                i.opcode_aux = (byte)53;
                i.type = ClassInfo.rootObject;
                break;
            }
            case SPUT_BOOLEAN: {
                i.opcode_aux = (byte)53;
                i.type = ClassInfo.primitiveBoolean;
                break;
            }
            case SPUT_BYTE: {
                i.opcode_aux = (byte)53;
                i.type = ClassInfo.primitiveByte;
                break;
            }
            case SPUT_CHAR: {
                i.opcode_aux = (byte)53;
                i.type = ClassInfo.primitiveChar;
                break;
            }
            case SPUT_SHORT: {
                i.opcode_aux = (byte)53;
                i.type = ClassInfo.primitiveShort;
            }
        }
        return i;
    }

    private int[] rebuildArgs(MethodInfo mi, int[] args) {
        int realSize = mi.paramTypes.length + (mi.isStatic() ? 0 : 1);
        if (realSize == args.length) {
            return args;
        }
        int[] realArgs = new int[realSize];
        int i = 0;
        int j = 0;
        if (!mi.isStatic()) {
            realArgs[i++] = args[j++];
        }
        for (ClassInfo ci : mi.paramTypes) {
            realArgs[i++] = args[j++];
            if (ci != ClassInfo.primitiveLong && ci != ClassInfo.primitiveDouble) continue;
            ++j;
        }
        Log.doAssert(j == args.length, "argument size mismatch");
        return realArgs;
    }

    private Instruction translateInvoke(Instruction35c i5) {
        Instruction i = new Instruction();
        i.opcode = (byte)12;
        int accessFlags = 0;
        switch (i5.getOpcode()) {
            case INVOKE_VIRTUAL: {
                i.opcode_aux = (byte)13;
                break;
            }
            case INVOKE_SUPER: {
                i.opcode_aux = (byte)12;
                break;
            }
            case INVOKE_DIRECT: {
                i.opcode_aux = (byte)11;
                break;
            }
            case INVOKE_STATIC: {
                i.opcode_aux = (byte)14;
                accessFlags = 8;
                break;
            }
            case INVOKE_INTERFACE: {
                i.opcode_aux = (byte)15;
            }
        }
        MethodReference method = (MethodReference)i5.getReference();
        MethodInfo mi = SmaliClassDetailLoader.translateMethodReference(method, accessFlags);
        int[] args = this.rebuildArgs(mi, MethodImplementationTranslator.getArguments((FiveRegisterInstruction)i5));
        i.extra = new Object[]{mi, args};
        this.resolver.registerForResolve(this.mi, this.currentCodeIndex);
        return i;
    }

    private Instruction translateInvoke(Instruction3rc ir) {
        Instruction i = new Instruction();
        i.opcode = (byte)12;
        int accessFlags = 0;
        switch (ir.getOpcode()) {
            case INVOKE_VIRTUAL_RANGE: {
                i.opcode_aux = (byte)13;
                break;
            }
            case INVOKE_SUPER_RANGE: {
                i.opcode_aux = (byte)12;
                break;
            }
            case INVOKE_DIRECT_RANGE: {
                i.opcode_aux = (byte)11;
                break;
            }
            case INVOKE_STATIC_RANGE: {
                i.opcode_aux = (byte)14;
                accessFlags = 8;
                break;
            }
            case INVOKE_INTERFACE_RANGE: {
                i.opcode_aux = (byte)15;
            }
        }
        MethodReference method = (MethodReference)ir.getReference();
        MethodInfo mi = SmaliClassDetailLoader.translateMethodReference(method, accessFlags);
        int[] args = this.rebuildArgs(mi, MethodImplementationTranslator.getArguments((RegisterRangeInstruction)ir));
        i.extra = new Object[]{mi, args};
        this.resolver.registerForResolve(this.mi, this.currentCodeIndex);
        return i;
    }

    private void applyPayload(Instruction i, PayloadInstruction p) {
        Opcode opcode = p.getOpcode();
        if (opcode == Opcode.ARRAY_PAYLOAD) {
            Log.doAssert(i.opcode == 4 && i.opcode_aux == 10, "payload type mismatch");
            List elements = ((ArrayPayload)p).getArrayElements();
            PrimitiveInfo[] array = new PrimitiveInfo[elements.size()];
            for (int j = 0; j < array.length; ++j) {
                array[j] = PrimitiveInfo.fromObject(elements.get(j));
            }
            i.extra = array;
        } else if (opcode == Opcode.PACKED_SWITCH_PAYLOAD || opcode == Opcode.SPARSE_SWITCH_PAYLOAD) {
            Log.doAssert(i.opcode == 14, "payload type mismatch");
            int switchAddress = (Integer)i.extra;
            List table = ((SwitchPayload)p).getSwitchElements();
            boolean resolvable = true;
            int maxAddress = -1;
            for (SwitchElement e : table) {
                int destAddress = switchAddress + e.getOffset();
                if (this.addressToIndex.containsKey(destAddress)) continue;
                if (resolvable) {
                    resolvable = false;
                }
                if (destAddress <= maxAddress) continue;
                maxAddress = destAddress;
            }
            if (resolvable) {
                i.extra = this.resolveSwitchTable(switchAddress, table);
            } else {
                i.extra = new Pair<Integer, List>(switchAddress, table);
                ArrayList<Instruction> insns = this.unresolvedInsns.get(maxAddress);
                if (insns == null) {
                    insns = new ArrayList();
                    this.unresolvedInsns.put(maxAddress, insns);
                }
                insns.add(i);
            }
        }
    }

    private Map<Integer, Integer> resolveSwitchTable(int switchAddress, List<? extends SwitchElement> table) {
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        for (SwitchElement switchElement : table) {
            int key = switchElement.getKey();
            int destAddress = switchAddress + switchElement.getOffset();
            int destIndex = this.addressToIndex.get(destAddress);
            map.put(key, destIndex);
        }
        return Collections.unmodifiableMap(map);
    }

    private void translatePayload(PayloadInstruction p) {
        ArrayList<Instruction> defers = this.payloadDefers.remove(this.currentCodeAddress);
        if (defers != null) {
            for (Instruction i : defers) {
                this.applyPayload(i, p);
            }
        }
        this.payloadCache.put(this.currentCodeAddress, p);
    }

    public void translate(MethodInfo mi, MethodImplementation impl) {
        int i;
        int[] args;
        this.mi = mi;
        this.currentCodeAddress = 0;
        ArrayList<Instruction> insns = new ArrayList<Instruction>();
        int reg = impl.getRegisterCount();
        if (!mi.isStatic()) {
            args = new int[mi.paramTypes.length + 1];
            for (i = mi.paramTypes.length - 1; i >= 0; --i) {
                if (mi.paramTypes[i] == ClassInfo.primitiveLong || mi.paramTypes[i] == ClassInfo.primitiveDouble) {
                    --reg;
                }
                args[i + 1] = --reg;
            }
            args[0] = --reg;
        } else {
            args = new int[mi.paramTypes.length];
            for (i = mi.paramTypes.length - 1; i >= 0; --i) {
                if (mi.paramTypes[i] == ClassInfo.primitiveLong || mi.paramTypes[i] == ClassInfo.primitiveDouble) {
                    --reg;
                }
                args[i] = --reg;
            }
        }
        Instruction i2 = new Instruction();
        i2.opcode = (byte)3;
        i2.opcode_aux = (byte)7;
        i2.extra = args;
        insns.add(i2);
        for (org.jf.dexlib2.iface.instruction.Instruction i3 : impl.getInstructions()) {
            this.currentCodeIndex = insns.size();
            this.addressToIndex.put(this.currentCodeAddress, this.currentCodeIndex);
            ArrayList<Instruction> uis = this.unresolvedInsns.remove(this.currentCodeAddress);
            if (uis != null) {
                for (Instruction ui : uis) {
                    switch (ui.opcode) {
                        case 6: 
                        case 8: {
                            ui.extra = this.currentCodeIndex;
                            break;
                        }
                        case 14: {
                            Pair extra = (Pair)ui.extra;
                            ui.extra = this.resolveSwitchTable((Integer)extra.first, (List)extra.second);
                        }
                    }
                }
            }
            switch (i3.getOpcode()) {
                case NOP: {
                    break;
                }
                case MOVE: 
                case MOVE_WIDE: 
                case MOVE_OBJECT: {
                    insns.add(MethodImplementationTranslator.translateMove((TwoRegisterInstruction)((Instruction12x)i3)));
                    break;
                }
                case MOVE_FROM16: 
                case MOVE_WIDE_FROM16: 
                case MOVE_OBJECT_FROM16: {
                    insns.add(MethodImplementationTranslator.translateMove((TwoRegisterInstruction)((Instruction22x)i3)));
                    break;
                }
                case MOVE_16: 
                case MOVE_WIDE_16: 
                case MOVE_OBJECT_16: {
                    insns.add(MethodImplementationTranslator.translateMove((TwoRegisterInstruction)((Instruction32x)i3)));
                    break;
                }
                case MOVE_RESULT: 
                case MOVE_RESULT_WIDE: 
                case MOVE_RESULT_OBJECT: 
                case MOVE_EXCEPTION: {
                    insns.add(MethodImplementationTranslator.translateMove((OneRegisterInstruction)((Instruction11x)i3)));
                    break;
                }
                case RETURN_VOID: {
                    insns.add(MethodImplementationTranslator.translateReturn((Instruction10x)i3));
                    break;
                }
                case RETURN: 
                case RETURN_WIDE: 
                case RETURN_OBJECT: {
                    insns.add(MethodImplementationTranslator.translateReturn((Instruction11x)i3));
                    break;
                }
                case CONST_4: {
                    insns.add(MethodImplementationTranslator.translateConst((OneRegisterInstruction)((Instruction11n)i3)));
                    break;
                }
                case CONST_16: {
                    insns.add(MethodImplementationTranslator.translateConst((OneRegisterInstruction)((Instruction21s)i3)));
                    break;
                }
                case CONST: {
                    insns.add(MethodImplementationTranslator.translateConst((OneRegisterInstruction)((Instruction31i)i3)));
                    break;
                }
                case CONST_HIGH16: {
                    insns.add(MethodImplementationTranslator.translateConst((OneRegisterInstruction)((Instruction21ih)i3)));
                    break;
                }
                case CONST_WIDE_16: {
                    insns.add(MethodImplementationTranslator.translateConst((OneRegisterInstruction)((Instruction21s)i3)));
                    break;
                }
                case CONST_WIDE_32: {
                    insns.add(MethodImplementationTranslator.translateConst((OneRegisterInstruction)((Instruction31i)i3)));
                    break;
                }
                case CONST_WIDE: {
                    insns.add(MethodImplementationTranslator.translateConst((OneRegisterInstruction)((Instruction51l)i3)));
                    break;
                }
                case CONST_WIDE_HIGH16: {
                    insns.add(MethodImplementationTranslator.translateConst((OneRegisterInstruction)((Instruction21lh)i3)));
                    break;
                }
                case CONST_STRING: {
                    insns.add(MethodImplementationTranslator.translateConst((OneRegisterInstruction)((Instruction21c)i3)));
                    break;
                }
                case CONST_STRING_JUMBO: {
                    insns.add(MethodImplementationTranslator.translateConst((OneRegisterInstruction)((Instruction31c)i3)));
                    break;
                }
                case CONST_CLASS: {
                    insns.add(MethodImplementationTranslator.translateConst((OneRegisterInstruction)((Instruction21c)i3)));
                    break;
                }
                case MONITOR_ENTER: 
                case MONITOR_EXIT: {
                    insns.add(MethodImplementationTranslator.translateSpecial((Instruction11x)i3));
                    break;
                }
                case CHECK_CAST: {
                    insns.add(MethodImplementationTranslator.translateArithmetic((OneRegisterInstruction)((Instruction21c)i3)));
                    break;
                }
                case INSTANCE_OF: {
                    insns.add(MethodImplementationTranslator.translateArithmetic((TwoRegisterInstruction)((Instruction22c)i3)));
                    break;
                }
                case ARRAY_LENGTH: {
                    insns.add(MethodImplementationTranslator.translateArithmetic((TwoRegisterInstruction)((Instruction12x)i3)));
                    break;
                }
                case NEW_INSTANCE: {
                    insns.add(MethodImplementationTranslator.translateNew((Instruction21c)i3));
                    break;
                }
                case NEW_ARRAY: {
                    insns.add(MethodImplementationTranslator.translateNew((Instruction22c)i3));
                    break;
                }
                case FILLED_NEW_ARRAY: {
                    insns.add(MethodImplementationTranslator.translateNew((Instruction35c)i3));
                    break;
                }
                case FILLED_NEW_ARRAY_RANGE: {
                    insns.add(MethodImplementationTranslator.translateNew((Instruction3rc)i3));
                    break;
                }
                case FILL_ARRAY_DATA: {
                    insns.add(this.translateNew((Instruction31t)i3));
                    break;
                }
                case THROW: {
                    insns.add(this.translateExceptionOp((Instruction11x)i3));
                    break;
                }
                case GOTO: {
                    insns.add(this.translateGoto((OffsetInstruction)((Instruction10t)i3)));
                    break;
                }
                case GOTO_16: {
                    insns.add(this.translateGoto((OffsetInstruction)((Instruction20t)i3)));
                    break;
                }
                case GOTO_32: {
                    insns.add(this.translateGoto((OffsetInstruction)((Instruction30t)i3)));
                    break;
                }
                case PACKED_SWITCH: 
                case SPARSE_SWITCH: {
                    insns.add(this.translateSwitch((Instruction31t)i3));
                    break;
                }
                case CMPL_FLOAT: 
                case CMPG_FLOAT: 
                case CMPL_DOUBLE: 
                case CMPG_DOUBLE: 
                case CMP_LONG: {
                    insns.add(this.translateCmp((Instruction23x)i3));
                    break;
                }
                case IF_EQ: 
                case IF_NE: 
                case IF_LT: 
                case IF_GE: 
                case IF_GT: 
                case IF_LE: {
                    insns.add(this.translateIf((Instruction22t)i3));
                    break;
                }
                case IF_EQZ: 
                case IF_NEZ: 
                case IF_LTZ: 
                case IF_GEZ: 
                case IF_GTZ: 
                case IF_LEZ: {
                    insns.add(this.translateIf((Instruction21t)i3));
                    break;
                }
                case AGET: 
                case AGET_WIDE: 
                case AGET_OBJECT: 
                case AGET_BOOLEAN: 
                case AGET_BYTE: 
                case AGET_CHAR: 
                case AGET_SHORT: 
                case APUT: 
                case APUT_WIDE: 
                case APUT_OBJECT: 
                case APUT_BOOLEAN: 
                case APUT_BYTE: 
                case APUT_CHAR: 
                case APUT_SHORT: {
                    insns.add(this.translateArrayOp((Instruction23x)i3));
                    break;
                }
                case IGET: 
                case IGET_WIDE: 
                case IGET_OBJECT: 
                case IGET_BOOLEAN: 
                case IGET_BYTE: 
                case IGET_CHAR: 
                case IGET_SHORT: 
                case IPUT: 
                case IPUT_WIDE: 
                case IPUT_OBJECT: 
                case IPUT_BOOLEAN: 
                case IPUT_BYTE: 
                case IPUT_CHAR: 
                case IPUT_SHORT: {
                    insns.add(this.translateInstanceOp((Instruction22c)i3));
                    break;
                }
                case SGET: 
                case SGET_WIDE: 
                case SGET_OBJECT: 
                case SGET_BOOLEAN: 
                case SGET_BYTE: 
                case SGET_CHAR: 
                case SGET_SHORT: 
                case SPUT: 
                case SPUT_WIDE: 
                case SPUT_OBJECT: 
                case SPUT_BOOLEAN: 
                case SPUT_BYTE: 
                case SPUT_CHAR: 
                case SPUT_SHORT: {
                    insns.add(this.translateStaticOp((Instruction21c)i3));
                    break;
                }
                case INVOKE_VIRTUAL: 
                case INVOKE_SUPER: 
                case INVOKE_DIRECT: 
                case INVOKE_STATIC: 
                case INVOKE_INTERFACE: {
                    insns.add(this.translateInvoke((Instruction35c)i3));
                    break;
                }
                case INVOKE_VIRTUAL_RANGE: 
                case INVOKE_SUPER_RANGE: 
                case INVOKE_DIRECT_RANGE: 
                case INVOKE_STATIC_RANGE: 
                case INVOKE_INTERFACE_RANGE: {
                    insns.add(this.translateInvoke((Instruction3rc)i3));
                    break;
                }
                case NEG_INT: 
                case NOT_INT: 
                case NEG_LONG: 
                case NOT_LONG: 
                case NEG_FLOAT: 
                case NEG_DOUBLE: 
                case INT_TO_LONG: 
                case INT_TO_FLOAT: 
                case INT_TO_DOUBLE: 
                case LONG_TO_INT: 
                case LONG_TO_FLOAT: 
                case LONG_TO_DOUBLE: 
                case FLOAT_TO_INT: 
                case FLOAT_TO_LONG: 
                case FLOAT_TO_DOUBLE: 
                case DOUBLE_TO_INT: 
                case DOUBLE_TO_LONG: 
                case DOUBLE_TO_FLOAT: 
                case INT_TO_BYTE: 
                case INT_TO_CHAR: 
                case INT_TO_SHORT: {
                    insns.add(MethodImplementationTranslator.translateArithmetic((TwoRegisterInstruction)((Instruction12x)i3)));
                    break;
                }
                case ADD_INT: 
                case SUB_INT: 
                case MUL_INT: 
                case DIV_INT: 
                case REM_INT: 
                case AND_INT: 
                case OR_INT: 
                case XOR_INT: 
                case SHL_INT: 
                case SHR_INT: 
                case USHR_INT: 
                case ADD_LONG: 
                case SUB_LONG: 
                case MUL_LONG: 
                case DIV_LONG: 
                case REM_LONG: 
                case AND_LONG: 
                case OR_LONG: 
                case XOR_LONG: 
                case SHL_LONG: 
                case SHR_LONG: 
                case USHR_LONG: 
                case ADD_FLOAT: 
                case SUB_FLOAT: 
                case MUL_FLOAT: 
                case DIV_FLOAT: 
                case REM_FLOAT: 
                case ADD_DOUBLE: 
                case SUB_DOUBLE: 
                case MUL_DOUBLE: 
                case DIV_DOUBLE: 
                case REM_DOUBLE: {
                    insns.add(MethodImplementationTranslator.translateArithmetic((ThreeRegisterInstruction)((Instruction23x)i3)));
                    break;
                }
                case ADD_INT_2ADDR: 
                case SUB_INT_2ADDR: 
                case MUL_INT_2ADDR: 
                case DIV_INT_2ADDR: 
                case REM_INT_2ADDR: 
                case AND_INT_2ADDR: 
                case OR_INT_2ADDR: 
                case XOR_INT_2ADDR: 
                case SHL_INT_2ADDR: 
                case SHR_INT_2ADDR: 
                case USHR_INT_2ADDR: 
                case ADD_LONG_2ADDR: 
                case SUB_LONG_2ADDR: 
                case MUL_LONG_2ADDR: 
                case DIV_LONG_2ADDR: 
                case REM_LONG_2ADDR: 
                case AND_LONG_2ADDR: 
                case OR_LONG_2ADDR: 
                case XOR_LONG_2ADDR: 
                case SHL_LONG_2ADDR: 
                case SHR_LONG_2ADDR: 
                case USHR_LONG_2ADDR: 
                case ADD_FLOAT_2ADDR: 
                case SUB_FLOAT_2ADDR: 
                case MUL_FLOAT_2ADDR: 
                case DIV_FLOAT_2ADDR: 
                case REM_FLOAT_2ADDR: 
                case ADD_DOUBLE_2ADDR: 
                case SUB_DOUBLE_2ADDR: 
                case MUL_DOUBLE_2ADDR: 
                case DIV_DOUBLE_2ADDR: 
                case REM_DOUBLE_2ADDR: {
                    insns.add(MethodImplementationTranslator.translateArithmeticTwoAddr((TwoRegisterInstruction)((Instruction12x)i3)));
                    break;
                }
                case ADD_INT_LIT16: 
                case RSUB_INT: 
                case MUL_INT_LIT16: 
                case DIV_INT_LIT16: 
                case REM_INT_LIT16: 
                case AND_INT_LIT16: 
                case OR_INT_LIT16: 
                case XOR_INT_LIT16: {
                    insns.add(MethodImplementationTranslator.translateArithmeticLit((TwoRegisterInstruction)((Instruction22s)i3)));
                    break;
                }
                case ADD_INT_LIT8: 
                case RSUB_INT_LIT8: 
                case MUL_INT_LIT8: 
                case DIV_INT_LIT8: 
                case REM_INT_LIT8: 
                case AND_INT_LIT8: 
                case OR_INT_LIT8: 
                case XOR_INT_LIT8: 
                case SHL_INT_LIT8: 
                case SHR_INT_LIT8: 
                case USHR_INT_LIT8: {
                    insns.add(MethodImplementationTranslator.translateArithmeticLit((TwoRegisterInstruction)((Instruction22b)i3)));
                    break;
                }
                case IGET_VOLATILE: 
                case IPUT_VOLATILE: 
                case SGET_VOLATILE: 
                case SPUT_VOLATILE: 
                case IGET_OBJECT_VOLATILE: 
                case IGET_WIDE_VOLATILE: 
                case IPUT_WIDE_VOLATILE: 
                case SGET_WIDE_VOLATILE: 
                case SPUT_WIDE_VOLATILE: 
                case THROW_VERIFICATION_ERROR: 
                case EXECUTE_INLINE: 
                case EXECUTE_INLINE_RANGE: 
                case INVOKE_DIRECT_EMPTY: 
                case INVOKE_OBJECT_INIT_RANGE: 
                case RETURN_VOID_BARRIER: 
                case IGET_QUICK: 
                case IGET_WIDE_QUICK: 
                case IGET_OBJECT_QUICK: 
                case IPUT_QUICK: 
                case IPUT_WIDE_QUICK: 
                case IPUT_OBJECT_QUICK: 
                case INVOKE_VIRTUAL_QUICK: 
                case INVOKE_VIRTUAL_QUICK_RANGE: 
                case INVOKE_SUPER_QUICK: 
                case INVOKE_SUPER_QUICK_RANGE: 
                case IPUT_OBJECT_VOLATILE: 
                case SGET_OBJECT_VOLATILE: 
                case SPUT_OBJECT_VOLATILE: {
                    Log.err("meet unused op");
                    break;
                }
                case PACKED_SWITCH_PAYLOAD: {
                    this.translatePayload((PayloadInstruction)((PackedSwitchPayload)i3));
                    break;
                }
                case SPARSE_SWITCH_PAYLOAD: {
                    this.translatePayload((PayloadInstruction)((SparseSwitchPayload)i3));
                    break;
                }
                case ARRAY_PAYLOAD: {
                    this.translatePayload((PayloadInstruction)((ArrayPayload)i3));
                    break;
                }
                default: {
                    Log.err("meet unknown op");
                }
            }
            this.currentCodeAddress += i3.getCodeUnits();
        }
        Log.doAssert(this.unresolvedInsns.isEmpty(), "unresolved instruction");
        Log.doAssert(this.payloadDefers.isEmpty(), "unresolved payload");
        mi.insns = insns.toArray(new Instruction[insns.size()]);
        ArrayList<TryBlockInfo> tbis = new ArrayList<TryBlockInfo>();
        for (TryBlock tb : impl.getTryBlocks()) {
            TryBlockInfo tbi = new TryBlockInfo();
            int start_addr = tb.getStartCodeAddress();
            int end_addr = start_addr + tb.getCodeUnitCount();
            tbi.startInsnIndex = this.addressToIndex.get(start_addr);
            if (this.addressToIndex.containsKey(end_addr)) {
                tbi.endInsnIndex = this.addressToIndex.get(end_addr);
            } else {
                int next_insn_addr = Integer.MAX_VALUE;
                for (int addr : this.addressToIndex.keySet()) {
                    if (addr <= end_addr) continue;
                    next_insn_addr = Math.min(next_insn_addr, addr);
                }
                tbi.endInsnIndex = next_insn_addr;
            }
            List ehs = tb.getExceptionHandlers();
            ArrayList<TryBlockInfo.ExceptionHandler> l = new ArrayList<TryBlockInfo.ExceptionHandler>();
            for (Object i4 : ehs) {
                ExceptionHandler eh = (ExceptionHandler)i4;
                int handler_start_addr = eh.getHandlerCodeAddress();
                ClassInfo exception_type = eh.getExceptionType() == null ? null : Dalvik.findOrCreateClass(eh.getExceptionType());
                TryBlockInfo.ExceptionHandler translated = new TryBlockInfo.ExceptionHandler();
                translated.exceptionType = exception_type;
                translated.handlerInsnIndex = this.addressToIndex.get(handler_start_addr);
                l.add(translated);
            }
            tbi.handlers = l.toArray(new TryBlockInfo.ExceptionHandler[l.size()]);
            tbis.add(tbi);
        }
        mi.tbs = tbis.toArray(new TryBlockInfo[tbis.size()]);
    }
}

