/*
 * Decompiled with CFR 0.152.
 */
package patdroid.smali;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jf.dexlib2.AccessFlags;
import org.jf.dexlib2.DexFileFactory;
import org.jf.dexlib2.Opcodes;
import org.jf.dexlib2.dexbacked.DexBackedDexFile;
import org.jf.dexlib2.iface.ClassDef;
import org.jf.dexlib2.iface.DexFile;
import org.jf.dexlib2.iface.Field;
import org.jf.dexlib2.iface.Method;
import org.jf.dexlib2.iface.MethodImplementation;
import org.jf.dexlib2.iface.reference.MethodReference;
import patdroid.Settings;
import patdroid.core.ClassDetail;
import patdroid.core.ClassDetailLoader;
import patdroid.core.ClassInfo;
import patdroid.core.MethodInfo;
import patdroid.dalvik.Dalvik;
import patdroid.dalvik.InvocationResolver;
import patdroid.smali.MethodImplementationTranslator;
import patdroid.util.Log;

public class SmaliClassDetailLoader
extends ClassDetailLoader {
    public final InvocationResolver resolver;
    private DexFile[] dexFiles;
    private final boolean translateInstructions;
    private boolean isFramework = false;

    @Override
    public void load(ClassInfo ci) throws ClassNotFoundException, ExceptionInInitializerError, NoClassDefFoundError {
        for (DexFile dexFile : this.dexFiles) {
            for (ClassDef classDef : dexFile.getClasses()) {
                if (!Dalvik.toCanonicalName(classDef.getType()).equals(ci.fullName)) continue;
                ClassDetail detail = this.translateClassDef(ci, classDef);
                SmaliClassDetailLoader.setDetails(ci, detail);
                if (!this.translateInstructions) continue;
                this.resolver.resolveAll();
            }
        }
        throw new ClassNotFoundException("" + ci.fullName + " not found in the dex file");
    }

    public static SmaliClassDetailLoader getFrameworkClassLoader(int apiLevel) {
        File f = new File(Settings.frameworkClassesFolder, "android-" + apiLevel + ".dex");
        if (!f.exists()) {
            return null;
        }
        DexBackedDexFile dex = null;
        try {
            dex = DexFileFactory.loadDexFile((File)f, (int)Settings.apiLevel);
        }
        catch (IOException e) {
            Log.err("failed to load framework classes");
            Log.err(e);
            return null;
        }
        SmaliClassDetailLoader ldr = new SmaliClassDetailLoader((DexFile)dex, false);
        ldr.isFramework = true;
        return ldr;
    }

    public void loadAll() {
        for (DexFile dexFile : this.dexFiles) {
            for (ClassDef classDef : dexFile.getClasses()) {
                ClassInfo ci = Dalvik.findOrCreateClass(classDef.getType());
                ClassDetail detail = this.translateClassDef(ci, classDef);
                SmaliClassDetailLoader.setDetails(ci, detail);
            }
        }
        if (this.translateInstructions) {
            this.resolver.resolveAll();
        }
    }

    public SmaliClassDetailLoader(ZipFile apkFile) {
        this(apkFile, true);
    }

    public SmaliClassDetailLoader(ZipFile apkFile, boolean translateInstructions) {
        ZipEntry e;
        ArrayList<ZipEntry> dexEntries = new ArrayList<ZipEntry>();
        dexEntries.add(apkFile.getEntry("classes.dex"));
        for (int i = 2; i < 99 && (e = apkFile.getEntry("classes" + i + ".dex")) != null; ++i) {
            dexEntries.add(e);
        }
        int n = dexEntries.size();
        if (n == 0) {
            Log.err("Source apk does not have any dex files");
        }
        this.translateInstructions = translateInstructions;
        this.resolver = translateInstructions ? new InvocationResolver() : null;
        Opcodes opcodes = Opcodes.forApi((int)Settings.apiLevel);
        try {
            this.dexFiles = new DexFile[n];
            for (int i = 0; i < n; ++i) {
                this.dexFiles[i] = DexBackedDexFile.fromInputStream((Opcodes)opcodes, (InputStream)new BufferedInputStream(apkFile.getInputStream((ZipEntry)dexEntries.get(i))));
            }
        }
        catch (IOException e2) {
            Log.err("failed to process the source apk file");
            Log.err(e2);
        }
    }

    public SmaliClassDetailLoader(DexFile dexFile, boolean translateInstructions) {
        this.dexFiles = new DexFile[]{dexFile};
        this.translateInstructions = translateInstructions;
        this.resolver = translateInstructions ? new InvocationResolver() : null;
    }

    private ClassDetail translateClassDef(ClassInfo ci, ClassDef classDef) {
        ClassInfo superClass = classDef.getSuperclass() == null ? null : Dalvik.findOrCreateClass(classDef.getSuperclass());
        ClassInfo[] interfaces = SmaliClassDetailLoader.findOrCreateClass(classDef.getInterfaces());
        int accessFlags = SmaliClassDetailLoader.translateAccessFlags(classDef.getAccessFlags());
        MethodInfo[] methods = this.translateMethods(ci, classDef.getMethods());
        HashMap<String, ClassInfo> fields = SmaliClassDetailLoader.translateFields(classDef.getInstanceFields());
        if (ci.isInnerClass()) {
            fields.put("this$0", ci.getOuterClass());
        }
        HashMap<String, ClassInfo> staticFields = SmaliClassDetailLoader.translateFields(classDef.getStaticFields());
        return SmaliClassDetailLoader.createDetail(superClass, interfaces, accessFlags, methods, fields, staticFields, this.isFramework);
    }

    private MethodInfo translateMethod(ClassInfo ci, Method method) {
        MethodImplementation impl;
        ClassInfo retType = Dalvik.findOrCreateClass(method.getReturnType());
        ClassInfo[] paramTypes = SmaliClassDetailLoader.findOrCreateClass(method.getParameterTypes());
        int accessFlags = SmaliClassDetailLoader.translateAccessFlags(method.getAccessFlags());
        MethodInfo mi = new MethodInfo(ci, method.getName(), retType, paramTypes, accessFlags);
        Log.msg("Translating method: %s", mi.toString());
        if (this.translateInstructions && (impl = method.getImplementation()) != null) {
            MethodImplementationTranslator mit = new MethodImplementationTranslator(this.resolver);
            mit.translate(mi, impl);
        }
        return mi;
    }

    private MethodInfo[] translateMethods(ClassInfo ci, Iterable<? extends Method> methods) {
        ArrayList<MethodInfo> result = new ArrayList<MethodInfo>();
        for (Method method : methods) {
            result.add(this.translateMethod(ci, method));
        }
        return result.toArray(new MethodInfo[result.size()]);
    }

    private static HashMap<String, ClassInfo> translateFields(Iterable<? extends Field> fields) {
        HashMap<String, ClassInfo> result = new HashMap<String, ClassInfo>();
        for (Field field : fields) {
            result.put(field.getName(), Dalvik.findOrCreateClass(field.getType()));
        }
        return result;
    }

    public static int translateAccessFlags(int accessFlags) {
        int f = 0;
        f |= AccessFlags.ABSTRACT.isSet(accessFlags) ? 1024 : 0;
        f |= AccessFlags.FINAL.isSet(accessFlags) ? 16 : 0;
        f |= AccessFlags.INTERFACE.isSet(accessFlags) ? 512 : 0;
        f |= AccessFlags.NATIVE.isSet(accessFlags) ? 256 : 0;
        f |= AccessFlags.PRIVATE.isSet(accessFlags) ? 2 : 0;
        f |= AccessFlags.PROTECTED.isSet(accessFlags) ? 4 : 0;
        f |= AccessFlags.PUBLIC.isSet(accessFlags) ? 1 : 0;
        f |= AccessFlags.STATIC.isSet(accessFlags) ? 8 : 0;
        f |= AccessFlags.STRICTFP.isSet(accessFlags) ? 2048 : 0;
        f |= AccessFlags.SYNCHRONIZED.isSet(accessFlags) ? 32 : 0;
        f |= AccessFlags.TRANSIENT.isSet(accessFlags) ? 128 : 0;
        return f |= AccessFlags.VOLATILE.isSet(accessFlags) ? 64 : 0;
    }

    static MethodInfo translateMethodReference(MethodReference method, int accessFlags) {
        ClassInfo ci = Dalvik.findOrCreateClass(method.getDefiningClass());
        ClassInfo retType = Dalvik.findOrCreateClass(method.getReturnType());
        ClassInfo[] paramTypes = SmaliClassDetailLoader.findOrCreateClass(method.getParameterTypes());
        return new MethodInfo(ci, method.getName(), retType, paramTypes, accessFlags);
    }

    public static ClassInfo[] findOrCreateClass(Collection<? extends CharSequence> l) {
        ClassInfo[] ret = new ClassInfo[l.size()];
        int i = 0;
        for (CharSequence charSequence : l) {
            ret[i] = Dalvik.findOrCreateClass(charSequence.toString());
            ++i;
        }
        return ret;
    }
}

