/*
 * Decompiled with CFR 0.152.
 */
package patdroid.util;

import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Stack;

public final class JSONWriter
implements Closeable,
Flushable {
    private final Writer writer;
    private final Stack<String> enders = new Stack();
    private int indent = 0;
    private boolean needComma = false;

    public JSONWriter(Writer writer) {
        this.writer = writer;
    }

    private final String getIndent() {
        return new String(new char[this.indent]).replace("\u0000", "\t");
    }

    private final JSONWriter writeItem(String k, String content) throws IOException {
        if (this.needComma) {
            this.writer.write(",\n");
        } else {
            this.writer.write("\n");
        }
        this.writer.write(this.getIndent() + "\"" + k + "\": " + content);
        this.needComma = true;
        return this;
    }

    private final JSONWriter writeStarter(String starter, String ender, String k) throws IOException {
        if (this.needComma) {
            this.writer.write(",\n");
        } else {
            this.writer.write("\n");
        }
        this.writer.write(this.getIndent());
        this.writer.write(k != null ? "\"" + k + "\": " : "");
        this.writer.write(starter);
        this.enders.push(ender);
        ++this.indent;
        this.needComma = false;
        return this;
    }

    public final JSONWriter writeStartObject(String k) throws IOException {
        return this.writeStarter("{", "}", k);
    }

    public final JSONWriter writeStartObject() throws IOException {
        return this.writeStarter("{", "}", null);
    }

    public final JSONWriter writeStartArray(String k) throws IOException {
        return this.writeStarter("[", "]", k);
    }

    public final JSONWriter writeEnd() throws IOException {
        this.writer.write("\n");
        --this.indent;
        this.writer.write(this.getIndent() + this.enders.pop());
        this.needComma = true;
        return this;
    }

    public final JSONWriter write(String k, String str) throws IOException {
        return this.writeItem(k, "\"" + str + "\"");
    }

    public final JSONWriter write(String k, int v) throws IOException {
        return this.writeItem(k, Integer.toString(v));
    }

    public final JSONWriter write(String k, boolean b) throws IOException {
        return this.writeItem(k, Boolean.toString(b));
    }

    public final JSONWriter writeNull(String k) throws IOException {
        return this.writeItem(k, "null");
    }

    public final JSONWriter writeObjectAsString(String k, Object o) throws IOException {
        return o == null ? this.writeNull(k) : this.write(k, o.toString());
    }

    public JSONWriter writeArray(String k, ArrayList<?> list) throws IOException {
        String s = "";
        int counter = 0;
        s = s + "[";
        for (Object o : list) {
            s = s + "\"" + o.toString() + "\"";
            if (++counter == list.size()) continue;
            s = s + ", ";
        }
        s = s + "]";
        return this.writeItem(k, s);
    }

    @Override
    public void flush() throws IOException {
        this.writer.flush();
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.writer.close();
    }
}

