/*
 * Decompiled with CFR 0.152.
 */
package patdroid.util;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import patdroid.Settings;
import patdroid.util.Report;

public class Log {
    public static final int MODE_VERBOSE = 0;
    public static final int MODE_MSG = 1;
    public static final int MODE_DEBUG = 2;
    public static final int MODE_WARNING = 3;
    public static final int MODE_SEVERE_WARNING = 4;
    public static final int MODE_ERROR = 5;
    public static final int MODE_REPORT = 6;
    public static final int MODE_CONCISE_REPORT = 7;
    public static final Writer stdout = new BufferedWriter(new OutputStreamWriter(System.out));
    public static final Writer stderr = new BufferedWriter(new OutputStreamWriter(System.err));
    public static Writer out = stdout;
    public static Writer err = stderr;
    private static ThreadLocal<String> indent = new ThreadLocal<String>(){

        @Override
        protected String initialValue() {
            return "";
        }
    };

    private static void writeLog(int theLevel, String title, String msg, Writer w) {
        if (theLevel >= Settings.logLevel) {
            try {
                w.write(indent.get() + "[" + title + "]: " + msg + "\n");
            }
            catch (IOException e) {
                Log.exit(1);
            }
        }
    }

    public static void exit(int r) {
        try {
            out.close();
            err.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.exit(r);
    }

    protected static void log(int theLevel, String title, String msg) {
        Log.writeLog(theLevel, title, msg, out);
    }

    protected static void badlog(int theLevel, String title, String msg) {
        switch (theLevel) {
            case 3: {
                ++Report.nWarnings;
                break;
            }
            case 4: {
                ++Report.nSevereWarnings;
                break;
            }
            case 5: {
                ++Report.nErrors;
                break;
            }
        }
        Log.writeLog(theLevel, title, msg, err);
    }

    public static void increaseIndent() {
        indent.set(indent.get() + "  ");
    }

    public static void decreaseIndent() {
        indent.set(indent.get().substring(2));
    }

    public static void resetIndent() {
        indent.remove();
    }

    public static void doAssert(boolean b, String msg) {
        if (!b) {
            Log.err(msg);
        }
    }

    public static void msg(String format, Object ... args) {
        Log.msg(String.format(format, args));
    }

    public static void msg(String s) {
        Log.log(1, "MSG", s);
    }

    public static void debug(String format, Object ... args) {
        Log.debug(String.format(format, args));
    }

    public static void debug(String s) {
        Log.log(2, "DEBUG", s);
    }

    private static String exceptionToString(Exception e) {
        StackTraceElement[] st;
        String s = e.toString() + "\n";
        for (StackTraceElement i : st = e.getStackTrace()) {
            s = s + i.toString() + "\n";
        }
        return s;
    }

    public static void warn(String format, Object ... args) {
        Log.warn(String.format(format, args));
    }

    public static void warn(Exception e) {
        Log.warn(Log.exceptionToString(e));
    }

    public static void warn(String s) {
        Log.badlog(3, "WARN", s);
    }

    public static void warnwarn(String format, Object ... args) {
        Log.warnwarn(String.format(format, args));
    }

    public static void warnwarn(String s) {
        Log.badlog(4, "WARN*", s);
    }

    public static void warnwarn(boolean b, String s) {
        if (!b) {
            Log.warnwarn(s);
        }
    }

    public static void err(Exception e) {
        Log.err(Log.exceptionToString(e));
    }

    public static void err(String format, Object ... args) {
        Log.err(String.format(format, args));
    }

    public static void err(String msg) {
        Log.badlog(5, "ERROR", msg);
    }
}

