/*
 * Decompiled with CFR 0.152.
 */
package io.vov.vitamio;

import android.util.Log;
import android.view.Surface;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.egl.EGLDisplay;
import javax.microedition.khronos.egl.EGLSurface;
import javax.microedition.khronos.opengles.GL;

public class EGL {
    private EGL10 mEgl;
    private EGLDisplay mEglDisplay;
    private EGLSurface mEglSurface;
    private EGLConfig mEglConfig;
    private EGLContext mEglContext;
    private EGLConfigChooser mEGLConfigChooser = new SimpleEGLConfigChooser();
    private EGLContextFactory mEGLContextFactory = new EGLContextFactory();
    private EGLWindowSurfaceFactory mEGLWindowSurfaceFactory = new EGLWindowSurfaceFactory();

    public boolean initialize(Surface surface) {
        this.start();
        return this.createSurface(surface) != null;
    }

    public void release() {
        this.destroySurface();
        this.finish();
    }

    public void start() {
        this.mEgl = (EGL10)EGLContext.getEGL();
        this.mEglDisplay = this.mEgl.eglGetDisplay(EGL10.EGL_DEFAULT_DISPLAY);
        if (this.mEglDisplay == EGL10.EGL_NO_DISPLAY) {
            throw new RuntimeException("eglGetDisplay failed");
        }
        int[] version = new int[2];
        if (!this.mEgl.eglInitialize(this.mEglDisplay, version)) {
            throw new RuntimeException("eglInitialize failed");
        }
        this.mEglConfig = this.mEGLConfigChooser.chooseConfig(this.mEgl, this.mEglDisplay);
        this.mEglContext = this.mEGLContextFactory.createContext(this.mEgl, this.mEglDisplay, this.mEglConfig);
        if (this.mEglContext == null || this.mEglContext == EGL10.EGL_NO_CONTEXT) {
            this.mEglContext = null;
            this.throwEglException("createContext");
        }
        this.mEglSurface = null;
    }

    public GL createSurface(Surface surface) {
        if (this.mEgl == null) {
            throw new RuntimeException("egl not initialized");
        }
        if (this.mEglDisplay == null) {
            throw new RuntimeException("eglDisplay not initialized");
        }
        if (this.mEglConfig == null) {
            throw new RuntimeException("mEglConfig not initialized");
        }
        if (this.mEglSurface != null && this.mEglSurface != EGL10.EGL_NO_SURFACE) {
            this.mEgl.eglMakeCurrent(this.mEglDisplay, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_CONTEXT);
            this.mEGLWindowSurfaceFactory.destroySurface(this.mEgl, this.mEglDisplay, this.mEglSurface);
        }
        this.mEglSurface = this.mEGLWindowSurfaceFactory.createWindowSurface(this.mEgl, this.mEglDisplay, this.mEglConfig, surface);
        if (this.mEglSurface == null || this.mEglSurface == EGL10.EGL_NO_SURFACE) {
            int error = this.mEgl.eglGetError();
            if (error == 12299) {
                Log.e((String)"EglHelper", (String)"createWindowSurface returned EGL_BAD_NATIVE_WINDOW.");
                return null;
            }
            this.throwEglException("createWindowSurface", error);
        }
        if (!this.mEgl.eglMakeCurrent(this.mEglDisplay, this.mEglSurface, this.mEglSurface, this.mEglContext)) {
            this.throwEglException("eglMakeCurrent");
        }
        GL gl = this.mEglContext.getGL();
        return gl;
    }

    public boolean swap() {
        if (!this.mEgl.eglSwapBuffers(this.mEglDisplay, this.mEglSurface)) {
            int error = this.mEgl.eglGetError();
            switch (error) {
                case 12302: {
                    return false;
                }
                case 12299: {
                    Log.e((String)"EglHelper", (String)("eglSwapBuffers returned EGL_BAD_NATIVE_WINDOW. tid=" + Thread.currentThread().getId()));
                    break;
                }
                case 12301: {
                    Log.e((String)"EglHelper", (String)("eglSwapBuffers returned EGL_BAD_SURFACE. tid=" + Thread.currentThread().getId()));
                    return false;
                }
                default: {
                    this.throwEglException("eglSwapBuffers", error);
                }
            }
        }
        return true;
    }

    public void destroySurface() {
        if (this.mEglSurface != null && this.mEglSurface != EGL10.EGL_NO_SURFACE) {
            this.mEgl.eglMakeCurrent(this.mEglDisplay, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_CONTEXT);
            this.mEGLWindowSurfaceFactory.destroySurface(this.mEgl, this.mEglDisplay, this.mEglSurface);
            this.mEglSurface = null;
        }
    }

    public void finish() {
        if (this.mEglContext != null) {
            this.mEGLContextFactory.destroyContext(this.mEgl, this.mEglDisplay, this.mEglContext);
            this.mEglContext = null;
        }
        if (this.mEglDisplay != null) {
            this.mEgl.eglTerminate(this.mEglDisplay);
            this.mEglDisplay = null;
        }
    }

    private void throwEglException(String function) {
        this.throwEglException(function, this.mEgl.eglGetError());
    }

    private void throwEglException(String function, int error) {
        String message = String.format("%s failed: %x", function, error);
        Log.e((String)"EglHelper", (String)("throwEglException tid=" + Thread.currentThread().getId() + " " + message));
        throw new RuntimeException(message);
    }

    private class SimpleEGLConfigChooser
    extends ComponentSizeChooser {
        public SimpleEGLConfigChooser() {
            super(5, 6, 5, 0, 0, 0);
        }
    }

    private class ComponentSizeChooser
    extends EGLConfigChooser {
        protected int mRedSize;
        protected int mGreenSize;
        protected int mBlueSize;
        protected int mAlphaSize;
        protected int mDepthSize;
        protected int mStencilSize;
        private int[] mValue;

        public ComponentSizeChooser(int redSize, int greenSize, int blueSize, int alphaSize, int depthSize, int stencilSize) {
            super(new int[]{12324, redSize, 12323, greenSize, 12322, blueSize, 12321, alphaSize, 12325, depthSize, 12326, stencilSize, 12344});
            this.mValue = new int[1];
            this.mRedSize = redSize;
            this.mGreenSize = greenSize;
            this.mBlueSize = blueSize;
            this.mAlphaSize = alphaSize;
            this.mDepthSize = depthSize;
            this.mStencilSize = stencilSize;
        }

        @Override
        public EGLConfig chooseConfig(EGL10 egl, EGLDisplay display, EGLConfig[] configs) {
            for (EGLConfig config : configs) {
                int d = this.findConfigAttrib(egl, display, config, 12325, 0);
                int s = this.findConfigAttrib(egl, display, config, 12326, 0);
                if (d < this.mDepthSize || s < this.mStencilSize) continue;
                int r = this.findConfigAttrib(egl, display, config, 12324, 0);
                int g = this.findConfigAttrib(egl, display, config, 12323, 0);
                int b = this.findConfigAttrib(egl, display, config, 12322, 0);
                int a = this.findConfigAttrib(egl, display, config, 12321, 0);
                if (r != this.mRedSize || g != this.mGreenSize || b != this.mBlueSize || a != this.mAlphaSize) continue;
                return config;
            }
            return null;
        }

        private int findConfigAttrib(EGL10 egl, EGLDisplay display, EGLConfig config, int attribute, int defaultValue) {
            if (egl.eglGetConfigAttrib(display, config, attribute, this.mValue)) {
                return this.mValue[0];
            }
            return defaultValue;
        }
    }

    private abstract class EGLConfigChooser {
        protected int[] mConfigSpec;

        public EGLConfigChooser(int[] configSpec) {
            this.mConfigSpec = this.filterConfigSpec(configSpec);
        }

        public EGLConfig chooseConfig(EGL10 egl, EGLDisplay display) {
            int[] num_config = new int[1];
            if (!egl.eglChooseConfig(display, this.mConfigSpec, null, 0, num_config)) {
                throw new IllegalArgumentException("eglChooseConfig failed");
            }
            int numConfigs = num_config[0];
            if (numConfigs <= 0) {
                throw new IllegalArgumentException("No configs match configSpec");
            }
            EGLConfig[] configs = new EGLConfig[numConfigs];
            if (!egl.eglChooseConfig(display, this.mConfigSpec, configs, numConfigs, num_config)) {
                throw new IllegalArgumentException("eglChooseConfig#2 failed");
            }
            EGLConfig config = this.chooseConfig(egl, display, configs);
            if (config == null) {
                throw new IllegalArgumentException("No config chosen");
            }
            return config;
        }

        abstract EGLConfig chooseConfig(EGL10 var1, EGLDisplay var2, EGLConfig[] var3);

        private int[] filterConfigSpec(int[] configSpec) {
            int len = configSpec.length;
            int[] newConfigSpec = new int[len + 2];
            System.arraycopy(configSpec, 0, newConfigSpec, 0, len - 1);
            newConfigSpec[len - 1] = 12352;
            newConfigSpec[len] = 4;
            newConfigSpec[len + 1] = 12344;
            return newConfigSpec;
        }
    }

    private class EGLContextFactory {
        private int EGL_CONTEXT_CLIENT_VERSION = 12440;

        private EGLContextFactory() {
        }

        public EGLContext createContext(EGL10 egl, EGLDisplay display, EGLConfig config) {
            int[] attrib_list = new int[]{this.EGL_CONTEXT_CLIENT_VERSION, 2, 12344};
            return egl.eglCreateContext(display, config, EGL10.EGL_NO_CONTEXT, attrib_list);
        }

        public void destroyContext(EGL10 egl, EGLDisplay display, EGLContext context) {
            if (!egl.eglDestroyContext(display, context)) {
                Log.e((String)"DefaultContextFactory", (String)("display:" + display + " context: " + context));
                throw new RuntimeException("eglDestroyContext failed: ");
            }
        }
    }

    private static class EGLWindowSurfaceFactory {
        private EGLWindowSurfaceFactory() {
        }

        public EGLSurface createWindowSurface(EGL10 egl, EGLDisplay display, EGLConfig config, Object nativeWindow) {
            return egl.eglCreateWindowSurface(display, config, nativeWindow, null);
        }

        public void destroySurface(EGL10 egl, EGLDisplay display, EGLSurface surface) {
            egl.eglDestroySurface(display, surface);
        }
    }
}

