/*
 * Decompiled with CFR 0.152.
 */
package io.vov.vitamio;

import java.util.HashMap;
import java.util.Iterator;

public class MediaFile {
    protected static final String sFileExtensions;
    public static final int FILE_TYPE_MP3 = 1;
    public static final int FILE_TYPE_M4A = 2;
    public static final int FILE_TYPE_WAV = 3;
    public static final int FILE_TYPE_AMR = 4;
    public static final int FILE_TYPE_AWB = 5;
    public static final int FILE_TYPE_WMA = 6;
    public static final int FILE_TYPE_OGG = 7;
    public static final int FILE_TYPE_AAC = 8;
    public static final int FILE_TYPE_MKA = 9;
    public static final int FILE_TYPE_MID = 10;
    public static final int FILE_TYPE_SMF = 11;
    public static final int FILE_TYPE_IMY = 12;
    public static final int FILE_TYPE_APE = 13;
    public static final int FILE_TYPE_FLAC = 14;
    private static final int FIRST_AUDIO_FILE_TYPE = 1;
    private static final int LAST_AUDIO_FILE_TYPE = 14;
    public static final int FILE_TYPE_MP4 = 701;
    public static final int FILE_TYPE_M4V = 702;
    public static final int FILE_TYPE_3GPP = 703;
    public static final int FILE_TYPE_3GPP2 = 704;
    public static final int FILE_TYPE_WMV = 705;
    public static final int FILE_TYPE_ASF = 706;
    public static final int FILE_TYPE_MKV = 707;
    public static final int FILE_TYPE_MP2TS = 708;
    public static final int FILE_TYPE_FLV = 709;
    public static final int FILE_TYPE_MOV = 710;
    public static final int FILE_TYPE_RM = 711;
    public static final int FILE_TYPE_DVD = 712;
    public static final int FILE_TYPE_DIVX = 713;
    public static final int FILE_TYPE_OGV = 714;
    public static final int FILE_TYPE_VIVO = 715;
    public static final int FILE_TYPE_WTV = 716;
    public static final int FILE_TYPE_AVS = 717;
    public static final int FILE_TYPE_SWF = 718;
    public static final int FILE_TYPE_RAW = 719;
    private static final int FIRST_VIDEO_FILE_TYPE = 701;
    private static final int LAST_VIDEO_FILE_TYPE = 719;
    private static HashMap<String, MediaFileType> sFileTypeMap;
    private static HashMap<String, Integer> sMimeTypeMap;

    static void addFileType(String extension, int fileType, String mimeType) {
        sFileTypeMap.put(extension, new MediaFileType(fileType, mimeType));
        sMimeTypeMap.put(mimeType, fileType);
    }

    public static boolean isAudioFileType(int fileType) {
        return fileType >= 1 && fileType <= 14;
    }

    public static boolean isVideoFileType(int fileType) {
        return fileType >= 701 && fileType <= 719;
    }

    public static MediaFileType getFileType(String path) {
        int lastDot = path.lastIndexOf(".");
        if (lastDot < 0) {
            return null;
        }
        return sFileTypeMap.get(path.substring(lastDot + 1).toUpperCase());
    }

    public static int getFileTypeForMimeType(String mimeType) {
        Integer value = sMimeTypeMap.get(mimeType);
        return value == null ? 0 : value;
    }

    static {
        sFileTypeMap = new HashMap();
        sMimeTypeMap = new HashMap();
        MediaFile.addFileType("M1V", 701, "video/mpeg");
        MediaFile.addFileType("MP2", 701, "video/mpeg");
        MediaFile.addFileType("MPE", 701, "video/mpeg");
        MediaFile.addFileType("MPG", 701, "video/mpeg");
        MediaFile.addFileType("MPEG", 701, "video/mpeg");
        MediaFile.addFileType("MP4", 701, "video/mp4");
        MediaFile.addFileType("M4V", 702, "video/mp4");
        MediaFile.addFileType("3GP", 703, "video/3gpp");
        MediaFile.addFileType("3GPP", 703, "video/3gpp");
        MediaFile.addFileType("3G2", 704, "video/3gpp2");
        MediaFile.addFileType("3GPP2", 704, "video/3gpp2");
        MediaFile.addFileType("MKV", 707, "video/x-matroska");
        MediaFile.addFileType("WEBM", 707, "video/x-matroska");
        MediaFile.addFileType("MTS", 708, "video/mp2ts");
        MediaFile.addFileType("TS", 708, "video/mp2ts");
        MediaFile.addFileType("TP", 708, "video/mp2ts");
        MediaFile.addFileType("WMV", 705, "video/x-ms-wmv");
        MediaFile.addFileType("ASF", 706, "video/x-ms-asf");
        MediaFile.addFileType("ASX", 706, "video/x-ms-asf");
        MediaFile.addFileType("FLV", 709, "video/x-flv");
        MediaFile.addFileType("F4V", 709, "video/x-flv");
        MediaFile.addFileType("HLV", 709, "video/x-flv");
        MediaFile.addFileType("MOV", 710, "video/quicktime");
        MediaFile.addFileType("QT", 710, "video/quicktime");
        MediaFile.addFileType("RM", 711, "video/x-pn-realvideo");
        MediaFile.addFileType("RMVB", 711, "video/x-pn-realvideo");
        MediaFile.addFileType("VOB", 712, "video/dvd");
        MediaFile.addFileType("DAT", 712, "video/dvd");
        MediaFile.addFileType("AVI", 713, "video/x-divx");
        MediaFile.addFileType("OGV", 714, "video/ogg");
        MediaFile.addFileType("OGG", 714, "video/ogg");
        MediaFile.addFileType("VIV", 715, "video/vnd.vivo");
        MediaFile.addFileType("VIVO", 715, "video/vnd.vivo");
        MediaFile.addFileType("WTV", 716, "video/wtv");
        MediaFile.addFileType("AVS", 717, "video/avs-video");
        MediaFile.addFileType("SWF", 718, "video/x-shockwave-flash");
        MediaFile.addFileType("YUV", 719, "video/x-raw-yuv");
        StringBuilder builder = new StringBuilder();
        Iterator<String> iterator = sFileTypeMap.keySet().iterator();
        while (iterator.hasNext()) {
            if (builder.length() > 0) {
                builder.append(',');
            }
            builder.append(iterator.next());
        }
        sFileExtensions = builder.toString();
    }

    protected static class MediaFileType {
        int fileType;
        String mimeType;

        MediaFileType(int fileType, String mimeType) {
            this.fileType = fileType;
            this.mimeType = mimeType;
        }
    }
}

