/*
 * Decompiled with CFR 0.152.
 */
package io.vov.vitamio;

import android.content.ContentResolver;
import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.graphics.Bitmap;
import android.net.Uri;
import android.util.Log;
import io.vov.vitamio.Vitamio;
import io.vov.vitamio.utils.FileUtils;
import java.io.FileDescriptor;
import java.io.IOException;

public class MediaMetadataRetriever {
    private AssetFileDescriptor mFD = null;
    private int mNativeContext;
    public static final String METADATA_KEY_ALBUM = "album";
    public static final String METADATA_KEY_ALBUM_ARTIST = "album_artist";
    public static final String METADATA_KEY_ARTIST = "artist";
    public static final String METADATA_KEY_COMMENT = "comment";
    public static final String METADATA_KEY_AUTHOR = "author";
    public static final String METADATA_KEY_COMPOSER = "composer";
    public static final String METADATA_KEY_COPYRIGHT = "copyright";
    public static final String METADATA_KEY_CREATION_TIME = "creation_time";
    public static final String METADATA_KEY_DATE = "date";
    public static final String METADATA_KEY_DISC = "disc";
    public static final String METADATA_KEY_ENCODER = "encoder";
    public static final String METADATA_KEY_ENCODED_BY = "encoded_by";
    public static final String METADATA_KEY_FILENAME = "filename";
    public static final String METADATA_KEY_GENRE = "genre";
    public static final String METADATA_KEY_LANGUAGE = "language";
    public static final String METADATA_KEY_PERFORMER = "performer";
    public static final String METADATA_KEY_PUBLISHER = "publisher";
    public static final String METADATA_KEY_SERVICE_NAME = "service_name";
    public static final String METADATA_KEY_SERVICE_PROVIDER = "service_provider";
    public static final String METADATA_KEY_TITLE = "title";
    public static final String METADATA_KEY_TRACK = "track";
    public static final String METADATA_KEY_VARIANT_BITRATE = "bitrate";
    public static final String METADATA_KEY_DURATION = "duration";
    public static final String METADATA_KEY_AUDIO_CODEC = "audio_codec";
    public static final String METADATA_KEY_VIDEO_CODEC = "video_codec";
    public static final String METADATA_KEY_VIDEO_ROTATION = "rotate";
    public static final String METADATA_KEY_VIDEO_WIDTH = "width";
    public static final String METADATA_KEY_VIDEO_HEIGHT = "height";
    public static final String METADATA_KEY_NUM_TRACKS = "num_tracks";
    public static final String METADATA_KEY_HAS_AUDIO = "has_audio";
    public static final String METADATA_KEY_HAS_VIDEO = "has_video";

    public MediaMetadataRetriever(Context ctx) {
        this.native_setup();
    }

    private static native boolean loadFFmpeg_native(String var0);

    public void setDataSource(Context context, Uri uri) throws IOException, IllegalArgumentException, SecurityException, IllegalStateException {
        if (context == null || uri == null) {
            throw new IllegalArgumentException();
        }
        String scheme = uri.getScheme();
        if (scheme == null || scheme.equals("file")) {
            this.setDataSource(FileUtils.getPath(uri.toString()));
            return;
        }
        try {
            ContentResolver resolver = context.getContentResolver();
            this.mFD = resolver.openAssetFileDescriptor(uri, "r");
            if (this.mFD == null) {
                return;
            }
            this.setDataSource(this.mFD.getParcelFileDescriptor().getFileDescriptor());
            return;
        }
        catch (Exception e) {
            this.closeFD();
            Log.e((String)"Couldn't open file on client side, trying server side %s", (String)uri.toString());
            this.setDataSource(uri.toString());
            return;
        }
    }

    public native void setDataSource(String var1) throws IOException, IllegalArgumentException, IllegalStateException;

    public native void setDataSource(FileDescriptor var1) throws IOException, IllegalArgumentException, IllegalStateException;

    public native String extractMetadata(String var1) throws IllegalStateException;

    public native Bitmap getFrameAtTime(long var1) throws IllegalStateException;

    public native byte[] getEmbeddedPicture() throws IllegalStateException;

    private native void _release();

    private native void native_setup();

    private static final native void native_init();

    private final native void native_finalize();

    public void release() {
        this._release();
        this.closeFD();
    }

    protected void finalize() throws Throwable {
        try {
            this.native_finalize();
        }
        finally {
            super.finalize();
        }
    }

    private void closeFD() {
        if (this.mFD != null) {
            try {
                this.mFD.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.mFD = null;
        }
    }

    static {
        String LIB_ROOT = Vitamio.getLibraryPath();
        Log.i((String)"LIB ROOT: %s", (String)LIB_ROOT);
        System.load(LIB_ROOT + "libstlport_shared.so");
        System.load(LIB_ROOT + "libvscanner.so");
        MediaMetadataRetriever.loadFFmpeg_native(LIB_ROOT + "libffmpeg.so");
        MediaMetadataRetriever.native_init();
    }
}

