/*
 * Decompiled with CFR 0.152.
 */
package io.vov.vitamio;

import android.annotation.SuppressLint;
import android.content.ContentResolver;
import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.media.AudioTrack;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.PowerManager;
import android.text.TextUtils;
import android.util.SparseArray;
import android.view.Surface;
import android.view.SurfaceHolder;
import io.vov.vitamio.MediaFormat;
import io.vov.vitamio.Metadata;
import io.vov.vitamio.Vitamio;
import io.vov.vitamio.utils.FileUtils;
import io.vov.vitamio.utils.Log;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

public class MediaPlayer {
    public static final int CACHE_TYPE_NOT_AVAILABLE = 1;
    public static final int CACHE_TYPE_START = 2;
    public static final int CACHE_TYPE_UPDATE = 3;
    public static final int CACHE_TYPE_SPEED = 4;
    public static final int CACHE_TYPE_COMPLETE = 5;
    public static final int CACHE_INFO_NO_SPACE = 1;
    public static final int CACHE_INFO_STREAM_NOT_SUPPORT = 2;
    public static final int MEDIA_ERROR_UNKNOWN = 1;
    public static final int MEDIA_ERROR_NOT_VALID_FOR_PROGRESSIVE_PLAYBACK = 200;
    public static final int MEDIA_ERROR_IO = -5;
    public static final int MEDIA_ERROR_MALFORMED = -1007;
    public static final int MEDIA_ERROR_UNSUPPORTED = -1010;
    public static final int MEDIA_ERROR_TIMED_OUT = -110;
    public static final int MEDIA_INFO_VIDEO_TRACK_LAGGING = 700;
    public static final int MEDIA_INFO_BUFFERING_START = 701;
    public static final int MEDIA_INFO_BUFFERING_END = 702;
    public static final int MEDIA_INFO_NOT_SEEKABLE = 801;
    public static final int MEDIA_INFO_DOWNLOAD_RATE_CHANGED = 901;
    public static final int VIDEOQUALITY_LOW = -16;
    public static final int VIDEOQUALITY_MEDIUM = 0;
    public static final int VIDEOQUALITY_HIGH = 16;
    public static final int VIDEOCHROMA_RGB565 = 0;
    public static final int VIDEOCHROMA_RGBA = 1;
    public static final int SUBTITLE_INTERNAL = 0;
    public static final int SUBTITLE_EXTERNAL = 1;
    public static final String[] SUB_TYPES = new String[]{".srt", ".ssa", ".smi", ".txt", ".sub", ".ass", ".webvtt"};
    private static final int MEDIA_NOP = 0;
    private static final int MEDIA_PREPARED = 1;
    private static final int MEDIA_PLAYBACK_COMPLETE = 2;
    private static final int MEDIA_BUFFERING_UPDATE = 3;
    private static final int MEDIA_SEEK_COMPLETE = 4;
    private static final int MEDIA_SET_VIDEO_SIZE = 5;
    private static final int MEDIA_ERROR = 100;
    private static final int MEDIA_INFO = 200;
    private static final int MEDIA_CACHE = 300;
    private static final int MEDIA_HW_ERROR = 400;
    private static final int MEDIA_TIMED_TEXT = 1000;
    private static final int MEDIA_CACHING_UPDATE = 2000;
    private static final String MEDIA_CACHING_SEGMENTS = "caching_segment";
    private static final String MEDIA_CACHING_TYPE = "caching_type";
    private static final String MEDIA_CACHING_INFO = "caching_info";
    private static final String MEDIA_SUBTITLE_STRING = "sub_string";
    private static final String MEDIA_SUBTITLE_BYTES = "sub_bytes";
    private static final String MEDIA_SUBTITLE_TYPE = "sub_type";
    private static final int SUBTITLE_TEXT = 0;
    private static final int SUBTITLE_BITMAP = 1;
    private static AtomicBoolean NATIVE_OMX_LOADED = new AtomicBoolean(false);
    private Context mContext;
    private Surface mSurface;
    private SurfaceHolder mSurfaceHolder;
    private EventHandler mEventHandler;
    private PowerManager.WakeLock mWakeLock = null;
    private boolean mScreenOnWhilePlaying;
    private boolean mStayAwake;
    private Metadata mMeta;
    private TrackInfo[] mInbandTracks;
    private TrackInfo mOutOfBandTracks;
    private AssetFileDescriptor mFD = null;
    private OnHWRenderFailedListener mOnHWRenderFailedListener;
    private OnPreparedListener mOnPreparedListener;
    private OnCompletionListener mOnCompletionListener;
    private OnBufferingUpdateListener mOnBufferingUpdateListener;
    private OnCachingUpdateListener mOnCachingUpdateListener;
    private OnSeekCompleteListener mOnSeekCompleteListener;
    private OnVideoSizeChangedListener mOnVideoSizeChangedListener;
    private OnErrorListener mOnErrorListener;
    private OnInfoListener mOnInfoListener;
    private OnTimedTextListener mOnTimedTextListener;
    private AudioTrack mAudioTrack;
    private int mAudioTrackBufferSize;
    private Surface mLocalSurface;
    private Bitmap mBitmap;
    private ByteBuffer mByteBuffer;

    public MediaPlayer(Context ctx) {
        this(ctx, false);
    }

    public MediaPlayer(Context ctx, boolean preferHWDecoder) {
        Looper looper;
        this.mContext = ctx;
        String LIB_ROOT = Vitamio.getLibraryPath();
        if (preferHWDecoder) {
            if (!NATIVE_OMX_LOADED.get()) {
                if (Build.VERSION.SDK_INT > 17) {
                    MediaPlayer.loadOMX_native(LIB_ROOT + "libOMX.18.so");
                } else if (Build.VERSION.SDK_INT > 13) {
                    MediaPlayer.loadOMX_native(LIB_ROOT + "libOMX.14.so");
                } else if (Build.VERSION.SDK_INT > 10) {
                    MediaPlayer.loadOMX_native(LIB_ROOT + "libOMX.11.so");
                } else {
                    MediaPlayer.loadOMX_native(LIB_ROOT + "libOMX.9.so");
                }
                NATIVE_OMX_LOADED.set(true);
            }
        } else {
            try {
                MediaPlayer.unloadOMX_native();
            }
            catch (UnsatisfiedLinkError e) {
                Log.e("unloadOMX failed %s", e.toString());
            }
            NATIVE_OMX_LOADED.set(false);
        }
        this.mEventHandler = (looper = Looper.myLooper()) != null ? new EventHandler(this, looper) : ((looper = Looper.getMainLooper()) != null ? new EventHandler(this, looper) : null);
        this.native_init();
    }

    private static void postEventFromNative(Object mediaplayer_ref, int what, int arg1, int arg2, Object obj) {
        MediaPlayer mp = (MediaPlayer)mediaplayer_ref;
        if (mp == null) {
            return;
        }
        if (mp.mEventHandler != null) {
            Message m = mp.mEventHandler.obtainMessage(what, arg1, arg2, obj);
            mp.mEventHandler.sendMessage(m);
        }
    }

    private static native boolean loadVAO_native(String var0);

    private static native boolean loadVVO_native(String var0);

    private static native boolean loadOMX_native(String var0);

    private static native void unloadOMX_native();

    private static native boolean loadFFmpeg_native(String var0);

    private native void _setVideoSurface(Surface var1);

    public void setDisplay(SurfaceHolder sh) {
        if (sh == null) {
            this.releaseDisplay();
        } else {
            this.mSurfaceHolder = sh;
            this.mSurface = sh.getSurface();
            this._setVideoSurface(this.mSurface);
            this.updateSurfaceScreenOn();
        }
    }

    public void setSurface(Surface surface) {
        if (surface == null) {
            this.releaseDisplay();
        } else {
            this.mSurfaceHolder = null;
            this.mSurface = surface;
            this._setVideoSurface(this.mSurface);
            this.updateSurfaceScreenOn();
        }
    }

    public void setDataSource(String path) throws IOException, IllegalArgumentException, SecurityException, IllegalStateException {
        this._setDataSource(path, null, null);
    }

    public void setDataSource(Context context, Uri uri) throws IOException, IllegalArgumentException, SecurityException, IllegalStateException {
        this.setDataSource(context, uri, null);
    }

    public void setDataSource(Context context, Uri uri, Map<String, String> headers) throws IOException, IllegalArgumentException, SecurityException, IllegalStateException {
        if (context == null || uri == null) {
            throw new IllegalArgumentException();
        }
        String scheme = uri.getScheme();
        if (scheme == null || scheme.equals("file")) {
            this.setDataSource(FileUtils.getPath(uri.toString()));
            return;
        }
        try {
            ContentResolver resolver = context.getContentResolver();
            this.mFD = resolver.openAssetFileDescriptor(uri, "r");
            if (this.mFD == null) {
                return;
            }
            this.setDataSource(this.mFD.getParcelFileDescriptor().getFileDescriptor());
            return;
        }
        catch (Exception e) {
            this.closeFD();
            this.setDataSource(uri.toString(), headers);
            return;
        }
    }

    public void setDataSource(String path, Map<String, String> headers) throws IOException, IllegalArgumentException, SecurityException, IllegalStateException {
        String[] keys = null;
        String[] values = null;
        if (headers != null) {
            keys = new String[headers.size()];
            values = new String[headers.size()];
            int i = 0;
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                keys[i] = entry.getKey();
                values[i] = entry.getValue();
                ++i;
            }
        }
        this.setDataSource(path, keys, values);
    }

    public void setDataSource(String path, String[] keys, String[] values) throws IOException, IllegalArgumentException, SecurityException, IllegalStateException {
        File file;
        Uri uri = Uri.parse((String)path);
        if ("file".equals(uri.getScheme())) {
            path = uri.getPath();
        }
        if ((file = new File(path)).exists()) {
            FileInputStream is = new FileInputStream(file);
            FileDescriptor fd = is.getFD();
            this.setDataSource(fd);
            is.close();
        } else {
            this._setDataSource(path, keys, values);
        }
    }

    public void setDataSegments(String[] uris, String cacheDir) {
        this._setDataSegmentsSource(uris, cacheDir);
    }

    public void setOnHWRenderFailedListener(OnHWRenderFailedListener l) {
        this.mOnHWRenderFailedListener = l;
    }

    private native void _setDataSource(String var1, String[] var2, String[] var3) throws IOException, IllegalArgumentException, IllegalStateException;

    public native void setDataSource(FileDescriptor var1) throws IOException, IllegalArgumentException, IllegalStateException;

    private native void _setDataSegmentsSource(String[] var1, String var2);

    public native void prepare() throws IOException, IllegalStateException;

    public native void prepareAsync() throws IllegalStateException;

    public void start() throws IllegalStateException {
        this.stayAwake(true);
        this._start();
    }

    private native void _start() throws IllegalStateException;

    public void stop() throws IllegalStateException {
        this.stayAwake(false);
        this._stop();
    }

    private native void _stop() throws IllegalStateException;

    public void pause() throws IllegalStateException {
        this.stayAwake(false);
        this._pause();
    }

    private native void _pause() throws IllegalStateException;

    @SuppressLint(value={"Wakelock"})
    public void setWakeMode(Context context, int mode) {
        boolean washeld = false;
        if (this.mWakeLock != null) {
            if (this.mWakeLock.isHeld()) {
                washeld = true;
                this.mWakeLock.release();
            }
            this.mWakeLock = null;
        }
        PowerManager pm = (PowerManager)context.getSystemService("power");
        this.mWakeLock = pm.newWakeLock(mode | 0x20000000, MediaPlayer.class.getName());
        this.mWakeLock.setReferenceCounted(false);
        if (washeld) {
            this.mWakeLock.acquire();
        }
    }

    public void setScreenOnWhilePlaying(boolean screenOn) {
        if (this.mScreenOnWhilePlaying != screenOn) {
            this.mScreenOnWhilePlaying = screenOn;
            this.updateSurfaceScreenOn();
        }
    }

    @SuppressLint(value={"Wakelock"})
    private void stayAwake(boolean awake) {
        if (this.mWakeLock != null) {
            if (awake && !this.mWakeLock.isHeld()) {
                this.mWakeLock.acquire();
            } else if (!awake && this.mWakeLock.isHeld()) {
                this.mWakeLock.release();
            }
        }
        this.mStayAwake = awake;
        this.updateSurfaceScreenOn();
    }

    private void updateSurfaceScreenOn() {
        if (this.mSurfaceHolder != null) {
            this.mSurfaceHolder.setKeepScreenOn(this.mScreenOnWhilePlaying && this.mStayAwake);
        }
    }

    public native int getVideoWidth();

    private native int getVideoWidth_a();

    public native int getVideoHeight();

    private native int getVideoHeight_a();

    public native boolean isPlaying();

    public native void setUseCache(boolean var1);

    public native void setCacheDirectory(String var1);

    public native void setAdaptiveStream(boolean var1);

    public native void seekTo(long var1) throws IllegalStateException;

    public native long getCurrentPosition();

    public native Bitmap getCurrentFrame();

    public native long getDuration();

    public Metadata getMetadata() {
        if (this.mMeta == null) {
            this.mMeta = new Metadata();
            HashMap<byte[], byte[]> meta = new HashMap<byte[], byte[]>();
            if (!this.native_getMetadata(meta)) {
                return null;
            }
            if (!this.mMeta.parse(meta, this.getMetaEncoding())) {
                return null;
            }
        }
        return this.mMeta;
    }

    public void release() {
        this.stayAwake(false);
        this.updateSurfaceScreenOn();
        this.mOnPreparedListener = null;
        this.mOnBufferingUpdateListener = null;
        this.mOnCompletionListener = null;
        this.mOnSeekCompleteListener = null;
        this.mOnErrorListener = null;
        this.mOnInfoListener = null;
        this.mOnVideoSizeChangedListener = null;
        this.mOnCachingUpdateListener = null;
        this.mOnHWRenderFailedListener = null;
        this._release();
        this.closeFD();
    }

    private native void _release();

    public void reset() {
        this.stayAwake(false);
        this._reset();
        this.mEventHandler.removeCallbacksAndMessages(null);
        this.closeFD();
    }

    private native void _reset();

    private void closeFD() {
        if (this.mFD != null) {
            try {
                this.mFD.close();
            }
            catch (IOException e) {
                Log.e("closeFD", e);
            }
            this.mFD = null;
        }
    }

    public native void setLooping(boolean var1);

    public native boolean isLooping();

    public native void setAudioAmplify(float var1);

    public native void setVolume(float var1, float var2);

    private final native boolean native_getTrackInfo(SparseArray<byte[]> var1);

    private final native boolean native_getMetadata(Map<byte[], byte[]> var1);

    private final native void native_init();

    private final native void native_finalize();

    public TrackInfo[] getTrackInfo(String encoding) {
        TrackInfo[] trackInfo = this.getInbandTrackInfo(encoding);
        String timedTextPath = this.getTimedTextPath();
        if (TextUtils.isEmpty((CharSequence)timedTextPath)) {
            return trackInfo;
        }
        TrackInfo[] allTrackInfo = new TrackInfo[trackInfo.length + 1];
        System.arraycopy(trackInfo, 0, allTrackInfo, 0, trackInfo.length);
        int i = trackInfo.length;
        SparseArray trackInfoArray = new SparseArray();
        MediaFormat mediaFormat = new MediaFormat();
        mediaFormat.setString("title", timedTextPath.substring(timedTextPath.lastIndexOf("/")));
        mediaFormat.setString("path", timedTextPath);
        SparseArray<MediaFormat> timedTextSparse = this.findTrackFromTrackInfo(3, trackInfo);
        if (timedTextSparse == null || timedTextSparse.size() == 0) {
            trackInfoArray.put(timedTextSparse.keyAt(0), (Object)mediaFormat);
        } else {
            trackInfoArray.put(timedTextSparse.keyAt(timedTextSparse.size() - 1), (Object)mediaFormat);
        }
        allTrackInfo[i] = this.mOutOfBandTracks = new TrackInfo(4, (SparseArray<MediaFormat>)trackInfoArray);
        return allTrackInfo;
    }

    private TrackInfo[] getInbandTrackInfo(String encoding) {
        if (this.mInbandTracks == null) {
            SparseArray trackSparse = new SparseArray();
            if (!this.native_getTrackInfo((SparseArray<byte[]>)trackSparse)) {
                return null;
            }
            int size = trackSparse.size();
            this.mInbandTracks = new TrackInfo[size];
            for (int i = 0; i < size; ++i) {
                TrackInfo trackInfo;
                SparseArray<MediaFormat> sparseArray = this.parseTrackInfo((byte[])trackSparse.valueAt(i), encoding);
                this.mInbandTracks[i] = trackInfo = new TrackInfo(trackSparse.keyAt(i), sparseArray);
            }
        }
        return this.mInbandTracks;
    }

    public TrackInfo[] getTrackInfo() {
        return this.getTrackInfo(Charset.defaultCharset().name());
    }

    private SparseArray<MediaFormat> parseTrackInfo(byte[] tracks, String encoding) {
        String trackString;
        SparseArray trackSparse = new SparseArray();
        try {
            trackString = new String(tracks, encoding);
        }
        catch (Exception e) {
            Log.e("getTrackMap exception", new Object[0]);
            trackString = new String(tracks);
        }
        for (String s : trackString.split("!#!")) {
            try {
                MediaFormat mediaFormat = null;
                String[] formats = s.split("\\.");
                if (formats == null) continue;
                int trackNum = Integer.parseInt(formats[0]);
                if (formats.length == 3) {
                    mediaFormat = MediaFormat.createSubtitleFormat(formats[2], formats[1]);
                } else if (formats.length == 2) {
                    mediaFormat = MediaFormat.createSubtitleFormat("", formats[1]);
                }
                trackSparse.put(trackNum, (Object)mediaFormat);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return trackSparse;
    }

    public SparseArray<MediaFormat> findTrackFromTrackInfo(int mediaTrackType, TrackInfo[] trackInfo) {
        for (int i = 0; i < trackInfo.length; ++i) {
            if (trackInfo[i].getTrackType() != mediaTrackType) continue;
            return trackInfo[i].getTrackInfoArray();
        }
        return null;
    }

    public native void addTimedTextSource(String var1);

    public void selectTrack(int index) {
        this.selectOrDeselectBandTrack(index, true);
    }

    public void deselectTrack(int index) {
        this.selectOrDeselectBandTrack(index, false);
    }

    private void selectOrDeselectBandTrack(int index, boolean select) {
        if (this.mOutOfBandTracks != null) {
            SparseArray<MediaFormat> mediaSparse = this.mOutOfBandTracks.getTrackInfoArray();
            int trackIndex = mediaSparse.keyAt(0);
            MediaFormat mediaFormat = (MediaFormat)mediaSparse.valueAt(0);
            if (index == trackIndex && select) {
                this.addTimedTextSource(mediaFormat.getString("path"));
                return;
            }
        }
        this.selectOrDeselectTrack(index, select);
    }

    private native void selectOrDeselectTrack(int var1, boolean var2);

    protected void finalize() {
        this.native_finalize();
    }

    public void setOnPreparedListener(OnPreparedListener listener) {
        this.mOnPreparedListener = listener;
    }

    public void setOnCompletionListener(OnCompletionListener listener) {
        this.mOnCompletionListener = listener;
    }

    public void setOnBufferingUpdateListener(OnBufferingUpdateListener listener) {
        this.mOnBufferingUpdateListener = listener;
    }

    public void setOnCachingUpdateListener(OnCachingUpdateListener listener) {
        this.mOnCachingUpdateListener = listener;
    }

    private void updateCacheStatus(int type, int info, long[] segments) {
        if (this.mEventHandler != null) {
            Message m = this.mEventHandler.obtainMessage(2000);
            Bundle b = m.getData();
            b.putInt(MEDIA_CACHING_TYPE, type);
            b.putInt(MEDIA_CACHING_INFO, info);
            b.putLongArray(MEDIA_CACHING_SEGMENTS, segments);
            this.mEventHandler.sendMessage(m);
        }
    }

    public void setOnSeekCompleteListener(OnSeekCompleteListener listener) {
        this.mOnSeekCompleteListener = listener;
    }

    public void setOnVideoSizeChangedListener(OnVideoSizeChangedListener listener) {
        this.mOnVideoSizeChangedListener = listener;
    }

    public void setOnErrorListener(OnErrorListener listener) {
        this.mOnErrorListener = listener;
    }

    public void setOnInfoListener(OnInfoListener listener) {
        this.mOnInfoListener = listener;
    }

    public void setOnTimedTextListener(OnTimedTextListener listener) {
        this.mOnTimedTextListener = listener;
    }

    private void updateSub(int subType, byte[] bytes, String encoding, int width, int height) {
        if (this.mEventHandler != null) {
            Message m = this.mEventHandler.obtainMessage(1000, width, height);
            Bundle b = m.getData();
            if (subType == 0) {
                b.putInt(MEDIA_SUBTITLE_TYPE, 0);
                if (encoding == null) {
                    b.putString(MEDIA_SUBTITLE_STRING, new String(bytes));
                } else {
                    try {
                        b.putString(MEDIA_SUBTITLE_STRING, new String(bytes, encoding.trim()));
                    }
                    catch (UnsupportedEncodingException e) {
                        Log.e("updateSub", e);
                        b.putString(MEDIA_SUBTITLE_STRING, new String(bytes));
                    }
                }
            } else if (subType == 1) {
                b.putInt(MEDIA_SUBTITLE_TYPE, 1);
                b.putByteArray(MEDIA_SUBTITLE_BYTES, bytes);
            }
            this.mEventHandler.sendMessage(m);
        }
    }

    protected native void _releaseVideoSurface();

    public void releaseDisplay() {
        this._releaseVideoSurface();
        this.mSurfaceHolder = null;
        this.mSurface = null;
    }

    public native float getVideoAspectRatio();

    public native void setVideoQuality(int var1);

    public native void setVideoChroma(int var1);

    public native void setDeinterlace(boolean var1);

    public native void setBufferSize(long var1);

    public native void setPlaybackSpeed(float var1);

    public native boolean isBuffering();

    public native int getBufferProgress();

    public native String getMetaEncoding();

    public native void setMetaEncoding(String var1);

    public native int getAudioTrack();

    public native int getVideoTrack();

    public native void setTimedTextShown(boolean var1);

    public native void setTimedTextEncoding(String var1);

    public native int getTimedTextLocation();

    public native String getTimedTextPath();

    public native int getTimedTextTrack();

    private int audioTrackInit(int sampleRateInHz, int channels) {
        this.audioTrackRelease();
        int channelConfig = channels >= 2 ? 12 : 4;
        try {
            this.mAudioTrackBufferSize = AudioTrack.getMinBufferSize((int)sampleRateInHz, (int)channelConfig, (int)2);
            this.mAudioTrack = new AudioTrack(3, sampleRateInHz, channelConfig, 2, this.mAudioTrackBufferSize, 1);
        }
        catch (Exception e) {
            this.mAudioTrackBufferSize = 0;
            Log.e("audioTrackInit", e);
        }
        return this.mAudioTrackBufferSize;
    }

    private void audioTrackSetVolume(float leftVolume, float rightVolume) {
        if (this.mAudioTrack != null) {
            this.mAudioTrack.setStereoVolume(leftVolume, rightVolume);
        }
    }

    private void audioTrackWrite(byte[] audioData, int offsetInBytes, int sizeInBytes) {
        if (this.mAudioTrack != null && this.mAudioTrack.getPlayState() == 3) {
            while (sizeInBytes > 0) {
                int written = sizeInBytes > this.mAudioTrackBufferSize ? this.mAudioTrackBufferSize : sizeInBytes;
                this.mAudioTrack.write(audioData, offsetInBytes, written);
                sizeInBytes -= written;
                offsetInBytes += written;
            }
        }
    }

    private void audioTrackStart() {
        if (this.mAudioTrack != null && this.mAudioTrack.getState() == 1 && this.mAudioTrack.getPlayState() != 3) {
            this.mAudioTrack.play();
        }
    }

    private void audioTrackPause() {
        if (this.mAudioTrack != null && this.mAudioTrack.getState() == 1) {
            this.mAudioTrack.pause();
        }
    }

    private void audioTrackRelease() {
        if (this.mAudioTrack != null) {
            if (this.mAudioTrack.getState() == 1) {
                this.mAudioTrack.stop();
            }
            this.mAudioTrack.release();
        }
        this.mAudioTrack = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ByteBuffer surfaceInit() {
        MediaPlayer mediaPlayer = this;
        synchronized (mediaPlayer) {
            this.mLocalSurface = this.mSurface;
            int w = this.getVideoWidth_a();
            int h = this.getVideoHeight_a();
            if (this.mLocalSurface != null && w != 0 && h != 0) {
                this.mBitmap = Bitmap.createBitmap((int)w, (int)h, (Bitmap.Config)Bitmap.Config.RGB_565);
                this.mByteBuffer = ByteBuffer.allocateDirect(w * h * 2);
            } else {
                this.mBitmap = null;
                this.mByteBuffer = null;
            }
            return this.mByteBuffer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void surfaceRender() {
        MediaPlayer mediaPlayer = this;
        synchronized (mediaPlayer) {
            if (this.mLocalSurface == null || !this.mLocalSurface.isValid() || this.mBitmap == null || this.mByteBuffer == null) {
                return;
            }
            try {
                Canvas c = this.mLocalSurface.lockCanvas(null);
                this.mBitmap.copyPixelsFromBuffer((Buffer)this.mByteBuffer);
                c.drawBitmap(this.mBitmap, 0.0f, 0.0f, null);
                this.mLocalSurface.unlockCanvasAndPost(c);
            }
            catch (Exception e) {
                Log.e("surfaceRender", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void surfaceRelease() {
        MediaPlayer mediaPlayer = this;
        synchronized (mediaPlayer) {
            this.mLocalSurface = null;
            this.mBitmap = null;
            this.mByteBuffer = null;
        }
    }

    static {
        String LIB_ROOT = Vitamio.getLibraryPath();
        try {
            Log.i("LIB ROOT: %s", LIB_ROOT);
            System.load(LIB_ROOT + "libstlport_shared.so");
            System.load(LIB_ROOT + "libvplayer.so");
            MediaPlayer.loadFFmpeg_native(LIB_ROOT + "libffmpeg.so");
            boolean vvo_loaded = false;
            vvo_loaded = Build.VERSION.SDK_INT > 8 ? MediaPlayer.loadVVO_native(LIB_ROOT + "libvvo.9.so") : (Build.VERSION.SDK_INT > 7 ? MediaPlayer.loadVVO_native(LIB_ROOT + "libvvo.8.so") : MediaPlayer.loadVVO_native(LIB_ROOT + "libvvo.7.so"));
            if (!vvo_loaded) {
                vvo_loaded = MediaPlayer.loadVVO_native(LIB_ROOT + "libvvo.j.so");
                Log.d("FALLBACK TO VVO JNI " + vvo_loaded, new Object[0]);
            }
            MediaPlayer.loadVAO_native(LIB_ROOT + "libvao.0.so");
        }
        catch (UnsatisfiedLinkError e) {
            Log.e("Error loading libs", e);
        }
    }

    @SuppressLint(value={"HandlerLeak"})
    private class EventHandler
    extends Handler {
        private MediaPlayer mMediaPlayer;
        private Bundle mData;

        public EventHandler(MediaPlayer mp, Looper looper) {
            super(looper);
            this.mMediaPlayer = mp;
        }

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    if (MediaPlayer.this.mOnPreparedListener != null) {
                        MediaPlayer.this.mOnPreparedListener.onPrepared(this.mMediaPlayer);
                    }
                    return;
                }
                case 2: {
                    if (MediaPlayer.this.mOnCompletionListener != null) {
                        MediaPlayer.this.mOnCompletionListener.onCompletion(this.mMediaPlayer);
                    }
                    MediaPlayer.this.stayAwake(false);
                    return;
                }
                case 3: {
                    if (MediaPlayer.this.mOnBufferingUpdateListener != null) {
                        MediaPlayer.this.mOnBufferingUpdateListener.onBufferingUpdate(this.mMediaPlayer, msg.arg1);
                    }
                    return;
                }
                case 4: {
                    if (MediaPlayer.this.isPlaying()) {
                        MediaPlayer.this.stayAwake(true);
                    }
                    if (MediaPlayer.this.mOnSeekCompleteListener != null) {
                        MediaPlayer.this.mOnSeekCompleteListener.onSeekComplete(this.mMediaPlayer);
                    }
                    return;
                }
                case 5: {
                    if (MediaPlayer.this.mOnVideoSizeChangedListener != null) {
                        MediaPlayer.this.mOnVideoSizeChangedListener.onVideoSizeChanged(this.mMediaPlayer, msg.arg1, msg.arg2);
                    }
                    return;
                }
                case 100: {
                    Log.e("Error (%d, %d)", msg.arg1, msg.arg2);
                    boolean error_was_handled = false;
                    if (MediaPlayer.this.mOnErrorListener != null) {
                        error_was_handled = MediaPlayer.this.mOnErrorListener.onError(this.mMediaPlayer, msg.arg1, msg.arg2);
                    }
                    if (MediaPlayer.this.mOnCompletionListener != null && !error_was_handled) {
                        MediaPlayer.this.mOnCompletionListener.onCompletion(this.mMediaPlayer);
                    }
                    MediaPlayer.this.stayAwake(false);
                    return;
                }
                case 200: {
                    Log.i("Info (%d, %d)", msg.arg1, msg.arg2);
                    if (MediaPlayer.this.mOnInfoListener != null) {
                        MediaPlayer.this.mOnInfoListener.onInfo(this.mMediaPlayer, msg.arg1, msg.arg2);
                    }
                    return;
                }
                case 300: {
                    return;
                }
                case 1000: {
                    this.mData = msg.getData();
                    if (this.mData.getInt(MediaPlayer.MEDIA_SUBTITLE_TYPE) == 0) {
                        Log.i("Subtitle : %s", this.mData.getString(MediaPlayer.MEDIA_SUBTITLE_STRING));
                        if (MediaPlayer.this.mOnTimedTextListener != null) {
                            MediaPlayer.this.mOnTimedTextListener.onTimedText(this.mData.getString(MediaPlayer.MEDIA_SUBTITLE_STRING));
                        }
                    } else if (this.mData.getInt(MediaPlayer.MEDIA_SUBTITLE_TYPE) == 1) {
                        Log.i("Subtitle : bitmap", new Object[0]);
                        if (MediaPlayer.this.mOnTimedTextListener != null) {
                            MediaPlayer.this.mOnTimedTextListener.onTimedTextUpdate(this.mData.getByteArray(MediaPlayer.MEDIA_SUBTITLE_BYTES), msg.arg1, msg.arg2);
                        }
                    }
                    return;
                }
                case 2000: {
                    if (MediaPlayer.this.mOnCachingUpdateListener != null) {
                        int cacheType = msg.getData().getInt(MediaPlayer.MEDIA_CACHING_TYPE);
                        if (cacheType == 1) {
                            MediaPlayer.this.mOnCachingUpdateListener.onCachingNotAvailable(this.mMediaPlayer, msg.getData().getInt(MediaPlayer.MEDIA_CACHING_INFO));
                        } else if (cacheType == 3) {
                            MediaPlayer.this.mOnCachingUpdateListener.onCachingUpdate(this.mMediaPlayer, msg.getData().getLongArray(MediaPlayer.MEDIA_CACHING_SEGMENTS));
                        } else if (cacheType == 4) {
                            MediaPlayer.this.mOnCachingUpdateListener.onCachingSpeed(this.mMediaPlayer, msg.getData().getInt(MediaPlayer.MEDIA_CACHING_INFO));
                        } else if (cacheType == 2) {
                            MediaPlayer.this.mOnCachingUpdateListener.onCachingStart(this.mMediaPlayer);
                        } else if (cacheType == 5) {
                            MediaPlayer.this.mOnCachingUpdateListener.onCachingComplete(this.mMediaPlayer);
                        }
                    }
                    return;
                }
                case 0: {
                    return;
                }
                case 400: {
                    if (MediaPlayer.this.mOnHWRenderFailedListener != null) {
                        MediaPlayer.this.mOnHWRenderFailedListener.onFailed();
                    }
                    return;
                }
            }
            Log.e("Unknown message type " + msg.what, new Object[0]);
        }
    }

    public static class TrackInfo {
        public static final int MEDIA_TRACK_TYPE_UNKNOWN = 0;
        public static final int MEDIA_TRACK_TYPE_VIDEO = 1;
        public static final int MEDIA_TRACK_TYPE_AUDIO = 2;
        public static final int MEDIA_TRACK_TYPE_TIMEDTEXT = 3;
        public static final int MEDIA_TRACK_TYPE_SUBTITLE = 4;
        final int mTrackType;
        final SparseArray<MediaFormat> mTrackInfoArray;

        TrackInfo(int trackType, SparseArray<MediaFormat> trackInfoArray) {
            this.mTrackType = trackType;
            this.mTrackInfoArray = trackInfoArray;
        }

        public int getTrackType() {
            return this.mTrackType;
        }

        public SparseArray<MediaFormat> getTrackInfoArray() {
            return this.mTrackInfoArray;
        }
    }

    public static interface OnTimedTextListener {
        public void onTimedText(String var1);

        public void onTimedTextUpdate(byte[] var1, int var2, int var3);
    }

    public static interface OnInfoListener {
        public boolean onInfo(MediaPlayer var1, int var2, int var3);
    }

    public static interface OnErrorListener {
        public boolean onError(MediaPlayer var1, int var2, int var3);
    }

    public static interface OnVideoSizeChangedListener {
        public void onVideoSizeChanged(MediaPlayer var1, int var2, int var3);
    }

    public static interface OnSeekCompleteListener {
        public void onSeekComplete(MediaPlayer var1);
    }

    public static interface OnCachingUpdateListener {
        public void onCachingUpdate(MediaPlayer var1, long[] var2);

        public void onCachingSpeed(MediaPlayer var1, int var2);

        public void onCachingStart(MediaPlayer var1);

        public void onCachingComplete(MediaPlayer var1);

        public void onCachingNotAvailable(MediaPlayer var1, int var2);
    }

    public static interface OnBufferingUpdateListener {
        public void onBufferingUpdate(MediaPlayer var1, int var2);
    }

    public static interface OnCompletionListener {
        public void onCompletion(MediaPlayer var1);
    }

    public static interface OnPreparedListener {
        public void onPrepared(MediaPlayer var1);
    }

    public static interface OnHWRenderFailedListener {
        public void onFailed();
    }
}

