/*
 * Decompiled with CFR 0.152.
 */
package io.vov.vitamio;

import android.content.ContentProviderClient;
import android.content.ContentUris;
import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.SQLException;
import android.net.Uri;
import android.os.RemoteException;
import android.text.TextUtils;
import io.vov.vitamio.MediaFile;
import io.vov.vitamio.MediaScannerClient;
import io.vov.vitamio.Vitamio;
import io.vov.vitamio.provider.MediaStore;
import io.vov.vitamio.utils.ContextUtils;
import io.vov.vitamio.utils.FileUtils;
import io.vov.vitamio.utils.Log;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;

public class MediaScanner {
    private static final String[] VIDEO_PROJECTION = new String[]{"_id", "_data", "date_modified"};
    private static final int ID_VIDEO_COLUMN_INDEX = 0;
    private static final int PATH_VIDEO_COLUMN_INDEX = 1;
    private static final int DATE_MODIFIED_VIDEO_COLUMN_INDEX = 2;
    private Context mContext;
    private ContentProviderClient mProvider;
    private boolean mCaseInsensitivePaths;
    private HashMap<String, FileCacheEntry> mFileCache;
    private MyMediaScannerClient mClient = new MyMediaScannerClient();

    public MediaScanner(Context ctx) {
        this.mContext = ctx;
        this.native_init(this.mClient);
    }

    private static native boolean loadFFmpeg_native(String var0);

    private void initialize() {
        this.mCaseInsensitivePaths = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prescan(String filePath) throws RemoteException {
        block16: {
            this.mProvider = this.mContext.getContentResolver().acquireContentProviderClient("me.abitno.vplayer.mediaprovider");
            Cursor c = null;
            String where = null;
            String[] selectionArgs = null;
            if (this.mFileCache == null) {
                this.mFileCache = new HashMap();
            } else {
                this.mFileCache.clear();
            }
            try {
                if (filePath != null) {
                    where = "_data=?";
                    selectionArgs = new String[]{filePath};
                }
                if ((c = this.mProvider.query(MediaStore.Video.Media.CONTENT_URI, VIDEO_PROJECTION, where, selectionArgs, null)) == null) break block16;
                block8: while (true) {
                    while (true) {
                        if (c.moveToNext()) {
                            long rowId = c.getLong(0);
                            String path = c.getString(1);
                            long lastModified = c.getLong(2);
                            if (!path.startsWith("/")) continue block8;
                            File tempFile = new File(path);
                            if (!TextUtils.isEmpty((CharSequence)filePath) && !tempFile.exists()) {
                                this.mProvider.delete(MediaStore.Video.Media.CONTENT_URI, where, selectionArgs);
                                return;
                            }
                            path = FileUtils.getCanonical(tempFile);
                            String key = this.mCaseInsensitivePaths ? path.toLowerCase() : path;
                            this.mFileCache.put(key, new FileCacheEntry(MediaStore.Video.Media.CONTENT_URI, rowId, path, lastModified));
                            continue;
                        }
                        break block16;
                        break;
                    }
                    break;
                }
                finally {
                    c.close();
                    c = null;
                }
            }
            finally {
                if (c != null) {
                    c.close();
                }
            }
        }
    }

    private void postscan(String[] directories) throws RemoteException {
        Iterator<FileCacheEntry> iterator = this.mFileCache.values().iterator();
        while (iterator.hasNext()) {
            FileCacheEntry entry = iterator.next();
            String path = entry.mPath;
            if (entry.mSeenInFileSystem || !this.inScanDirectory(path, directories) || new File(path).exists()) continue;
            this.mProvider.delete(ContentUris.withAppendedId((Uri)entry.mTableUri, (long)entry.mRowId), null, null);
            iterator.remove();
        }
        this.mFileCache.clear();
        this.mFileCache = null;
        this.mProvider.release();
        this.mProvider = null;
    }

    private boolean inScanDirectory(String path, String[] directories) {
        for (int i = 0; i < directories.length; ++i) {
            if (!path.startsWith(directories[i])) continue;
            return true;
        }
        return false;
    }

    public void scanDirectories(String[] directories) {
        try {
            long start = System.currentTimeMillis();
            this.prescan(null);
            long prescan = System.currentTimeMillis();
            for (int i = 0; i < directories.length; ++i) {
                if (TextUtils.isEmpty((CharSequence)directories[i])) continue;
                directories[i] = ContextUtils.fixLastSlash(directories[i]);
                this.processDirectory(directories[i], MediaFile.sFileExtensions);
            }
            long scan = System.currentTimeMillis();
            this.postscan(directories);
            long end = System.currentTimeMillis();
            Log.d(" prescan time: %dms", prescan - start);
            Log.d("    scan time: %dms", scan - prescan);
            Log.d("postscan time: %dms", end - scan);
            Log.d("   total time: %dms", end - start);
        }
        catch (SQLException e) {
            Log.e("SQLException in MediaScanner.scan()", e);
        }
        catch (UnsupportedOperationException e) {
            Log.e("UnsupportedOperationException in MediaScanner.scan()", e);
        }
        catch (RemoteException e) {
            Log.e("RemoteException in MediaScanner.scan()", e);
        }
    }

    public Uri scanSingleFile(String path, String mimeType) {
        try {
            this.prescan(path);
            File file = new File(path);
            long lastModifiedSeconds = file.lastModified() / 1000L;
            return this.mClient.doScanFile(path, lastModifiedSeconds, file.length(), true);
        }
        catch (RemoteException e) {
            Log.e("RemoteException in MediaScanner.scanFile()", e);
            return null;
        }
    }

    private native void processDirectory(String var1, String var2);

    private native boolean processFile(String var1, String var2);

    private final native void native_init(MediaScannerClient var1);

    public native void release();

    private final native void native_finalize();

    protected void finalize() throws Throwable {
        try {
            this.native_finalize();
        }
        finally {
            super.finalize();
        }
    }

    static {
        String LIB_ROOT = Vitamio.getLibraryPath();
        Log.i("LIB ROOT: %s", LIB_ROOT);
        System.load(LIB_ROOT + "libstlport_shared.so");
        System.load(LIB_ROOT + "libvscanner.so");
        MediaScanner.loadFFmpeg_native(LIB_ROOT + "libffmpeg.so");
    }

    private class MyMediaScannerClient
    implements MediaScannerClient {
        private String mMimeType;
        private int mFileType;
        private String mPath;
        private long mLastModified;
        private long mFileSize;
        private String mTitle;
        private String mArtist;
        private String mAlbum;
        private String mLanguage;
        private long mDuration;
        private int mWidth;
        private int mHeight;

        private MyMediaScannerClient() {
        }

        public FileCacheEntry beginFile(String path, long lastModified, long fileSize) {
            FileCacheEntry entry;
            MediaFile.MediaFileType mediaFileType;
            int lastSlash = path.lastIndexOf(47);
            if (lastSlash >= 0 && lastSlash + 2 < path.length()) {
                if (path.regionMatches(lastSlash + 1, "._", 0, 2)) {
                    return null;
                }
                if (path.regionMatches(true, path.length() - 4, ".jpg", 0, 4)) {
                    if (path.regionMatches(true, lastSlash + 1, "AlbumArt_{", 0, 10) || path.regionMatches(true, lastSlash + 1, "AlbumArt.", 0, 9)) {
                        return null;
                    }
                    int length = path.length() - lastSlash - 1;
                    if (length == 17 && path.regionMatches(true, lastSlash + 1, "AlbumArtSmall", 0, 13) || length == 10 && path.regionMatches(true, lastSlash + 1, "Folder", 0, 6)) {
                        return null;
                    }
                }
            }
            if ((mediaFileType = MediaFile.getFileType(path)) != null) {
                this.mFileType = mediaFileType.fileType;
                this.mMimeType = mediaFileType.mimeType;
            }
            String key = FileUtils.getCanonical(new File(path));
            if (MediaScanner.this.mCaseInsensitivePaths) {
                key = path.toLowerCase();
            }
            if ((entry = (FileCacheEntry)MediaScanner.this.mFileCache.get(key)) == null) {
                entry = new FileCacheEntry(null, 0L, path, 0L);
                MediaScanner.this.mFileCache.put(key, entry);
            }
            entry.mSeenInFileSystem = true;
            long delta = lastModified - entry.mLastModified;
            if (delta > 1L || delta < -1L) {
                entry.mLastModified = lastModified;
                entry.mLastModifiedChanged = true;
            }
            this.mPath = path;
            this.mLastModified = lastModified;
            this.mFileSize = fileSize;
            this.mTitle = null;
            this.mDuration = 0L;
            return entry;
        }

        @Override
        public void scanFile(String path, long lastModified, long fileSize) {
            Log.i("scanFile: %s", path);
            this.doScanFile(path, lastModified, fileSize, false);
        }

        public Uri doScanFile(String path, long lastModified, long fileSize, boolean scanAlways) {
            Uri result = null;
            try {
                FileCacheEntry entry = this.beginFile(path, lastModified, fileSize);
                if (entry != null && (entry.mLastModifiedChanged || scanAlways)) {
                    if (MediaScanner.this.processFile(path, null)) {
                        result = this.endFile(entry);
                    } else if (MediaScanner.this.mCaseInsensitivePaths) {
                        MediaScanner.this.mFileCache.remove(path.toLowerCase());
                    } else {
                        MediaScanner.this.mFileCache.remove(path);
                    }
                }
            }
            catch (RemoteException e) {
                Log.e("RemoteException in MediaScanner.scanFile()", e);
            }
            return result;
        }

        private int parseSubstring(String s, int start, int defaultValue) {
            char ch;
            int length = s.length();
            if (start == length) {
                return defaultValue;
            }
            if ((ch = s.charAt(start++)) < '0' || ch > '9') {
                return defaultValue;
            }
            int result = ch - 48;
            while (start < length) {
                if ((ch = s.charAt(start++)) < '0' || ch > '9') {
                    return result;
                }
                result = result * 10 + (ch - 48);
            }
            return result;
        }

        @Override
        public void handleStringTag(String name, byte[] valueBytes, String valueEncoding) {
            String value;
            try {
                value = new String(valueBytes, valueEncoding);
            }
            catch (Exception e) {
                Log.e("handleStringTag", e);
                value = new String(valueBytes);
            }
            Log.i("%s : %s", name, value);
            if (name.equalsIgnoreCase("title")) {
                this.mTitle = value;
            } else if (name.equalsIgnoreCase("artist")) {
                this.mArtist = value.trim();
            } else if (name.equalsIgnoreCase("albumartist")) {
                if (TextUtils.isEmpty((CharSequence)this.mArtist)) {
                    this.mArtist = value.trim();
                }
            } else if (name.equalsIgnoreCase("album")) {
                this.mAlbum = value.trim();
            } else if (name.equalsIgnoreCase("language")) {
                this.mLanguage = value.trim();
            } else if (name.equalsIgnoreCase("duration")) {
                this.mDuration = this.parseSubstring(value, 0, 0);
            } else if (name.equalsIgnoreCase("width")) {
                this.mWidth = this.parseSubstring(value, 0, 0);
            } else if (name.equalsIgnoreCase("height")) {
                this.mHeight = this.parseSubstring(value, 0, 0);
            }
        }

        @Override
        public void setMimeType(String mimeType) {
            Log.i("setMimeType: %s", mimeType);
            this.mMimeType = mimeType;
            this.mFileType = MediaFile.getFileTypeForMimeType(mimeType);
        }

        private ContentValues toValues() {
            ContentValues map = new ContentValues();
            map.put("_data", this.mPath);
            map.put("date_modified", Long.valueOf(this.mLastModified));
            map.put("_size", Long.valueOf(this.mFileSize));
            map.put("mime_type", this.mMimeType);
            map.put("title", this.mTitle);
            if (MediaFile.isVideoFileType(this.mFileType)) {
                map.put("duration", Long.valueOf(this.mDuration));
                map.put("language", this.mLanguage);
                map.put("album", this.mAlbum);
                map.put("artist", this.mArtist);
                map.put("width", Integer.valueOf(this.mWidth));
                map.put("height", Integer.valueOf(this.mHeight));
            }
            return map;
        }

        private Uri endFile(FileCacheEntry entry) throws RemoteException {
            boolean isVideo;
            boolean bl = isVideo = MediaFile.isVideoFileType(this.mFileType) && this.mWidth > 0 && this.mHeight > 0;
            if (!isVideo) {
                return null;
            }
            Uri tableUri = MediaStore.Video.Media.CONTENT_URI;
            entry.mTableUri = tableUri;
            ContentValues values = this.toValues();
            String title = values.getAsString("title");
            if (TextUtils.isEmpty((CharSequence)title)) {
                int lastDot;
                title = values.getAsString("_data");
                int lastSlash = title.lastIndexOf(47);
                if (lastSlash >= 0 && ++lastSlash < title.length()) {
                    title = title.substring(lastSlash);
                }
                if ((lastDot = title.lastIndexOf(46)) > 0) {
                    title = title.substring(0, lastDot);
                }
                values.put("title", title);
            }
            long rowId = entry.mRowId;
            Uri result = null;
            if (rowId == 0L) {
                result = MediaScanner.this.mProvider.insert(tableUri, values);
                if (result != null) {
                    entry.mRowId = rowId = ContentUris.parseId((Uri)result);
                }
            } else {
                result = ContentUris.withAppendedId((Uri)tableUri, (long)rowId);
                MediaScanner.this.mProvider.update(result, values, null, null);
            }
            return result;
        }

        @Override
        public void addNoMediaFolder(String path) {
            ContentValues values = new ContentValues();
            values.put("_data", "");
            String[] pathSpec = new String[]{path + '%'};
            try {
                MediaScanner.this.mProvider.update(MediaStore.Video.Media.CONTENT_URI, values, "_data LIKE ?", pathSpec);
            }
            catch (RemoteException e) {
                throw new RuntimeException();
            }
        }
    }

    private static class FileCacheEntry {
        Uri mTableUri;
        long mRowId;
        String mPath;
        long mLastModified;
        boolean mLastModifiedChanged;
        boolean mSeenInFileSystem;

        FileCacheEntry(Uri tableUri, long rowId, String path, long lastModified) {
            this.mTableUri = tableUri;
            this.mRowId = rowId;
            this.mPath = path;
            this.mLastModified = lastModified;
            this.mSeenInFileSystem = false;
            this.mLastModifiedChanged = false;
        }

        public String toString() {
            return this.mPath;
        }
    }
}

