/*
 * Decompiled with CFR 0.152.
 */
package io.vov.vitamio;

import android.util.SparseArray;
import java.io.UnsupportedEncodingException;
import java.util.Locale;
import java.util.Map;

public class Metadata {
    public static final int ANY = 0;
    public static final int TITLE = 1;
    public static final int COMMENT = 2;
    public static final int COPYRIGHT = 3;
    public static final int ALBUM = 4;
    public static final int ARTIST = 5;
    public static final int AUTHOR = 6;
    public static final int COMPOSER = 7;
    public static final int GENRE = 8;
    public static final int DATE = 9;
    public static final int DURATION = 10;
    public static final int CD_TRACK_NUM = 11;
    public static final int CD_TRACK_MAX = 12;
    public static final int RATING = 13;
    public static final int ALBUM_ART = 14;
    public static final int VIDEO_FRAME = 15;
    public static final int LENGTH = 16;
    public static final int BIT_RATE = 17;
    public static final int AUDIO_BIT_RATE = 18;
    public static final int VIDEO_BIT_RATE = 19;
    public static final int AUDIO_SAMPLE_RATE = 20;
    public static final int VIDEO_FRAME_RATE = 21;
    public static final int MIME_TYPE = 22;
    public static final int AUDIO_CODEC = 23;
    public static final int VIDEO_CODEC = 24;
    public static final int VIDEO_HEIGHT = 25;
    public static final int VIDEO_WIDTH = 26;
    public static final int NUM_TRACKS = 27;
    public static final int DRM_CRIPPLED = 28;
    public static final int PAUSE_AVAILABLE = 29;
    public static final int SEEK_BACKWARD_AVAILABLE = 30;
    public static final int SEEK_FORWARD_AVAILABLE = 31;
    public static final int SEEK_AVAILABLE = 32;
    private static final int LAST_SYSTEM = 32;
    private static final int FIRST_CUSTOM = 8192;
    private SparseArray<byte[]> mMeta = new SparseArray();
    private String mEncoding = "UTF-8";

    public boolean parse(Map<byte[], byte[]> meta, String encoding) {
        String key = null;
        byte[] value = null;
        this.mEncoding = encoding;
        for (byte[] keyBytes : meta.keySet()) {
            try {
                key = new String(keyBytes, this.mEncoding).trim().toLowerCase(Locale.US);
            }
            catch (UnsupportedEncodingException e) {
                key = new String(keyBytes).trim().toLowerCase(Locale.US);
            }
            value = meta.get(keyBytes);
            if (key.equals("title")) {
                this.mMeta.put(1, (Object)value);
                continue;
            }
            if (key.equals("comment")) {
                this.mMeta.put(2, (Object)value);
                continue;
            }
            if (key.equals("copyright")) {
                this.mMeta.put(3, (Object)value);
                continue;
            }
            if (key.equals("album")) {
                this.mMeta.put(4, (Object)value);
                continue;
            }
            if (key.equals("artist")) {
                this.mMeta.put(5, (Object)value);
                continue;
            }
            if (key.equals("author")) {
                this.mMeta.put(6, (Object)value);
                continue;
            }
            if (key.equals("composer")) {
                this.mMeta.put(7, (Object)value);
                continue;
            }
            if (key.equals("genre")) {
                this.mMeta.put(8, (Object)value);
                continue;
            }
            if (key.equals("creation_time") || key.equals("date")) {
                this.mMeta.put(9, (Object)value);
                continue;
            }
            if (key.equals("duration")) {
                this.mMeta.put(10, (Object)value);
                continue;
            }
            if (key.equals("length")) {
                this.mMeta.put(16, (Object)value);
                continue;
            }
            if (key.equals("bit_rate")) {
                this.mMeta.put(17, (Object)value);
                continue;
            }
            if (key.equals("audio_bit_rate")) {
                this.mMeta.put(18, (Object)value);
                continue;
            }
            if (key.equals("video_bit_rate")) {
                this.mMeta.put(19, (Object)value);
                continue;
            }
            if (key.equals("audio_sample_rate")) {
                this.mMeta.put(20, (Object)value);
                continue;
            }
            if (key.equals("video_frame_rate")) {
                this.mMeta.put(21, (Object)value);
                continue;
            }
            if (key.equals("format")) {
                this.mMeta.put(22, (Object)value);
                continue;
            }
            if (key.equals("audio_codec")) {
                this.mMeta.put(23, (Object)value);
                continue;
            }
            if (key.equals("video_codec")) {
                this.mMeta.put(24, (Object)value);
                continue;
            }
            if (key.equals("video_height")) {
                this.mMeta.put(25, (Object)value);
                continue;
            }
            if (key.equals("video_width")) {
                this.mMeta.put(26, (Object)value);
                continue;
            }
            if (key.equals("num_tracks")) {
                this.mMeta.put(27, (Object)value);
                continue;
            }
            if (key.equals("cap_pause")) {
                this.mMeta.put(29, (Object)value);
                continue;
            }
            if (!key.equals("cap_seek")) continue;
            this.mMeta.put(32, (Object)value);
        }
        return true;
    }

    public boolean has(int metadataId) {
        if (!this.checkMetadataId(metadataId)) {
            throw new IllegalArgumentException("Invalid key: " + metadataId);
        }
        return this.mMeta.indexOfKey(metadataId) >= 0;
    }

    public String getString(int key) {
        byte[] value = (byte[])this.mMeta.get(key);
        if (value == null) {
            return null;
        }
        try {
            return new String(value, this.mEncoding);
        }
        catch (UnsupportedEncodingException e) {
            return new String(value);
        }
    }

    public int getInt(int key) {
        try {
            return Integer.parseInt(this.getString(key));
        }
        catch (Exception e) {
            return -1;
        }
    }

    public boolean getBoolean(int key) {
        try {
            return Boolean.parseBoolean(this.getString(key));
        }
        catch (Exception e) {
            return false;
        }
    }

    public long getLong(int key) {
        try {
            return Long.parseLong(this.getString(key));
        }
        catch (Exception e) {
            return -1L;
        }
    }

    public double getDouble(int key) {
        try {
            return Double.parseDouble(this.getString(key));
        }
        catch (Exception e) {
            return -1.0;
        }
    }

    public byte[] getByteArray(int key) {
        return (byte[])this.mMeta.get(key);
    }

    private boolean checkMetadataId(int val) {
        return val > 0 && (32 >= val || val >= 8192);
    }
}

