/*
 * Decompiled with CFR 0.152.
 */
package io.vov.vitamio;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Rect;
import io.vov.vitamio.MediaMetadataRetriever;
import io.vov.vitamio.Vitamio;

public class ThumbnailUtils {
    private static final int OPTIONS_NONE = 0;
    private static final int OPTIONS_SCALE_UP = 1;
    public static final int OPTIONS_RECYCLE_INPUT = 2;
    public static final int TARGET_SIZE_MINI_THUMBNAIL_WIDTH = 426;
    public static final int TARGET_SIZE_MINI_THUMBNAIL_HEIGHT = 320;
    public static final int TARGET_SIZE_MICRO_THUMBNAIL_WIDTH = 212;
    public static final int TARGET_SIZE_MICRO_THUMBNAIL_HEIGHT = 160;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Bitmap createVideoThumbnail(Context ctx, String filePath, int kind) {
        if (!Vitamio.isInitialized(ctx)) {
            return null;
        }
        Bitmap bitmap = null;
        MediaMetadataRetriever retriever = null;
        try {
            retriever = new MediaMetadataRetriever(ctx);
            retriever.setDataSource(filePath);
            bitmap = retriever.getFrameAtTime(-1L);
        }
        catch (Exception ex) {
        }
        finally {
            try {
                retriever.release();
            }
            catch (RuntimeException ex) {}
        }
        if (bitmap != null) {
            if (kind == 3) {
                bitmap = ThumbnailUtils.extractThumbnail(bitmap, 212, 160, 2);
            } else if (kind == 1) {
                bitmap = ThumbnailUtils.extractThumbnail(bitmap, 426, 320, 2);
            }
        }
        return bitmap;
    }

    public static Bitmap extractThumbnail(Bitmap source, int width, int height) {
        return ThumbnailUtils.extractThumbnail(source, width, height, 0);
    }

    public static Bitmap extractThumbnail(Bitmap source, int width, int height, int options) {
        if (source == null) {
            return null;
        }
        float scale = source.getWidth() < source.getHeight() ? (float)width / (float)source.getWidth() : (float)height / (float)source.getHeight();
        Matrix matrix = new Matrix();
        matrix.setScale(scale, scale);
        Bitmap thumbnail = ThumbnailUtils.transform(matrix, source, width, height, 1 | options);
        return thumbnail;
    }

    private static Bitmap transform(Matrix scaler, Bitmap source, int targetWidth, int targetHeight, int options) {
        int dy1;
        int dx1;
        Bitmap b2;
        float viewAspect;
        float scale;
        float bitmapHeightF;
        boolean scaleUp = (options & 1) != 0;
        boolean recycle = (options & 2) != 0;
        int deltaX = source.getWidth() - targetWidth;
        int deltaY = source.getHeight() - targetHeight;
        if (!(scaleUp || deltaX >= 0 && deltaY >= 0)) {
            Bitmap b22 = Bitmap.createBitmap((int)targetWidth, (int)targetHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas c = new Canvas(b22);
            int deltaXHalf = Math.max(0, deltaX / 2);
            int deltaYHalf = Math.max(0, deltaY / 2);
            Rect src = new Rect(deltaXHalf, deltaYHalf, deltaXHalf + Math.min(targetWidth, source.getWidth()), deltaYHalf + Math.min(targetHeight, source.getHeight()));
            int dstX = (targetWidth - src.width()) / 2;
            int dstY = (targetHeight - src.height()) / 2;
            Rect dst = new Rect(dstX, dstY, targetWidth - dstX, targetHeight - dstY);
            c.drawBitmap(source, src, dst, null);
            if (recycle) {
                source.recycle();
            }
            return b22;
        }
        float bitmapWidthF = source.getWidth();
        float bitmapAspect = bitmapWidthF / (bitmapHeightF = (float)source.getHeight());
        float f = scale = bitmapAspect > (viewAspect = (float)targetWidth / (float)targetHeight) ? (float)targetHeight / bitmapHeightF : (float)targetWidth / bitmapWidthF;
        if (scale < 0.9f || scale > 1.0f) {
            scaler.setScale(scale, scale);
        } else {
            scaler = null;
        }
        Bitmap b1 = scaler != null ? Bitmap.createBitmap((Bitmap)source, (int)0, (int)0, (int)source.getWidth(), (int)source.getHeight(), (Matrix)scaler, (boolean)true) : source;
        if (recycle && b1 != source) {
            source.recycle();
        }
        if ((b2 = Bitmap.createBitmap((Bitmap)b1, (int)((dx1 = Math.max(0, b1.getWidth() - targetWidth)) / 2), (int)((dy1 = Math.max(0, b1.getHeight() - targetHeight)) / 2), (int)targetWidth, (int)targetHeight)) != b1 && (recycle || b1 != source)) {
            b1.recycle();
        }
        return b2;
    }
}

