/*
 * Decompiled with CFR 0.152.
 */
package io.vov.vitamio;

import android.content.Context;
import io.vov.vitamio.R;
import io.vov.vitamio.utils.CPU;
import io.vov.vitamio.utils.ContextUtils;
import io.vov.vitamio.utils.IOUtils;
import io.vov.vitamio.utils.Log;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Vitamio {
    private static final String[] LIBS_ARM_CODECS = new String[]{"libvvo.7.so", "libvvo.8.so", "libffmpeg.so", "libOMX.9.so", "libOMX.11.so", "libOMX.14.so", "libOMX.18.so"};
    private static final String[] LIBS_X86_CODECS = new String[]{"libffmpeg.so", "libOMX.9.so", "libOMX.14.so", "libOMX.18.so"};
    private static final String[] LIBS_MIPS_CODECS = new String[]{"libffmpeg.so", "libOMX.14.so"};
    private static final String[] LIBS_PLAYER = new String[]{"libvplayer.so"};
    private static final String[] LIBS_SCANNER = new String[]{"libvscanner.so"};
    private static final String[] LIBS_AV = new String[]{"libvao.0.so", "libvvo.0.so", "libvvo.9.so", "libvvo.j.so"};
    private static final String LIBS_LOCK = ".lock";
    private static final int VITAMIO_NOT_SUPPORTED = -1;
    private static final int VITAMIO_MIPS = 40;
    private static final int VITAMIO_X86 = 50;
    private static final int VITAMIO_ARMV6 = 60;
    private static final int VITAMIO_ARMV6_VFP = 61;
    private static final int VITAMIO_ARMV7_VFPV3 = 70;
    private static final int VITAMIO_ARMV7_NEON = 71;
    private static final int vitamioType;
    private static String vitamioPackage;
    private static String vitamioLibraryPath;

    public static boolean initialize(Context ctx) {
        return Vitamio.isInitialized(ctx) || Vitamio.extractLibs(ctx, R.raw.libarm);
    }

    public static boolean initialize(Context ctx, int rawId) {
        return Vitamio.isInitialized(ctx) || Vitamio.extractLibs(ctx, rawId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static boolean isInitialized(Context ctx) {
        Object[] libs;
        vitamioPackage = ctx.getPackageName();
        vitamioLibraryPath = ContextUtils.getDataDir(ctx) + "libs/";
        File dir = new File(Vitamio.getLibraryPath());
        if (dir.exists() && dir.isDirectory() && (libs = dir.list()) != null) {
            BufferedReader buffer;
            block8: {
                boolean bl;
                Arrays.sort(libs);
                for (String L : Vitamio.getRequiredLibs()) {
                    if (Arrays.binarySearch(libs, L) >= 0) continue;
                    Log.e("Native libs %s not exists!", L);
                    return false;
                }
                File lock = new File(Vitamio.getLibraryPath() + LIBS_LOCK);
                buffer = null;
                try {
                    buffer = new BufferedReader(new FileReader(lock));
                    int appVersion = ContextUtils.getVersionCode(ctx);
                    int libVersion = Integer.valueOf(buffer.readLine());
                    Log.i("isNativeLibsInited, APP VERSION: %d, Vitamio Library version: %d", appVersion, libVersion);
                    if (libVersion != appVersion) break block8;
                    bl = true;
                }
                catch (IOException e) {
                    Log.e("isNativeLibsInited", e);
                    IOUtils.closeSilently(buffer);
                }
                catch (NumberFormatException e2) {
                    Log.e("isNativeLibsInited", e2);
                    {
                        catch (Throwable throwable) {
                            IOUtils.closeSilently(buffer);
                            throw throwable;
                        }
                    }
                    IOUtils.closeSilently(buffer);
                }
                IOUtils.closeSilently(buffer);
                return bl;
            }
            IOUtils.closeSilently(buffer);
        }
        return false;
    }

    public static String getVitamioPackage() {
        return vitamioPackage;
    }

    public static int getVitamioType() {
        return vitamioType;
    }

    public static final String getLibraryPath() {
        return vitamioLibraryPath;
    }

    private static final List<String> getRequiredLibs() {
        ArrayList<String> libs = new ArrayList<String>();
        String[][] vitamioLibs = null;
        switch (vitamioType) {
            case 60: 
            case 61: 
            case 70: 
            case 71: {
                vitamioLibs = new String[][]{LIBS_ARM_CODECS, LIBS_PLAYER, LIBS_SCANNER, LIBS_AV};
                break;
            }
            case 50: {
                vitamioLibs = new String[][]{LIBS_X86_CODECS, LIBS_PLAYER, LIBS_SCANNER, LIBS_AV};
                break;
            }
            case 40: {
                vitamioLibs = new String[][]{LIBS_MIPS_CODECS, LIBS_PLAYER, LIBS_SCANNER, LIBS_AV};
                break;
            }
        }
        if (vitamioLibs == null) {
            return libs;
        }
        String[][] stringArray = vitamioLibs;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String[] libArray;
            for (String lib : libArray = stringArray[i]) {
                libs.add(lib);
            }
        }
        libs.add(LIBS_LOCK);
        return libs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean extractLibs(Context ctx, int rawID) {
        long begin = System.currentTimeMillis();
        int version = ContextUtils.getVersionCode(ctx);
        Log.d("loadLibs start " + version, new Object[0]);
        File lock = new File(Vitamio.getLibraryPath() + LIBS_LOCK);
        if (lock.exists()) {
            lock.delete();
        }
        String libPath = Vitamio.copyCompressedLib(ctx, rawID, "libarm.so");
        Log.d("copyCompressedLib time: " + (double)(System.currentTimeMillis() - begin) / 1000.0, new Object[0]);
        boolean inited = Vitamio.native_initializeLibs(libPath, Vitamio.getLibraryPath(), String.valueOf(Vitamio.getVitamioType()));
        new File(libPath).delete();
        FileWriter fw = null;
        try {
            lock.createNewFile();
            fw = new FileWriter(lock);
            fw.write(String.valueOf(version));
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            Log.e("Error creating lock file", e);
        }
        finally {
            Log.d("initializeNativeLibs: " + inited, new Object[0]);
            Log.d("loadLibs time: " + (double)(System.currentTimeMillis() - begin) / 1000.0, new Object[0]);
            IOUtils.closeSilently(fw);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String copyCompressedLib(Context ctx, int rawID, String destName) {
        byte[] buffer = new byte[1024];
        InputStream is = null;
        BufferedInputStream bis = null;
        FileOutputStream fos = null;
        String destPath = null;
        try {
            try {
                String destDir = Vitamio.getLibraryPath();
                destPath = destDir + destName;
                File f = new File(destDir);
                if (f.exists() && !f.isDirectory()) {
                    f.delete();
                }
                if (!f.exists()) {
                    f.mkdirs();
                }
                if ((f = new File(destPath)).exists() && !f.isFile()) {
                    f.delete();
                }
                if (!f.exists()) {
                    f.createNewFile();
                }
            }
            catch (Exception fe) {
                Log.e("loadLib", fe);
            }
            is = ctx.getResources().openRawResource(rawID);
            bis = new BufferedInputStream(is);
            fos = new FileOutputStream(destPath);
            while (bis.read(buffer) != -1) {
                fos.write(buffer);
            }
        }
        catch (Exception e) {
            String string;
            try {
                Log.e("loadLib", e);
                string = null;
            }
            catch (Throwable throwable) {
                IOUtils.closeSilently(fos);
                IOUtils.closeSilently(bis);
                IOUtils.closeSilently(is);
                throw throwable;
            }
            IOUtils.closeSilently(fos);
            IOUtils.closeSilently(bis);
            IOUtils.closeSilently(is);
            return string;
        }
        IOUtils.closeSilently(fos);
        IOUtils.closeSilently(bis);
        IOUtils.closeSilently(is);
        return destPath;
    }

    private static native boolean native_initializeLibs(String var0, String var1, String var2);

    static {
        int cpu = CPU.getFeature();
        vitamioType = (cpu & 0x20) > 0 ? 71 : ((cpu & 0x10) > 0 && (cpu & 8) > 0 ? 70 : ((cpu & 4) > 0 && (cpu & 2) > 0 ? 61 : ((cpu & 2) > 0 ? 60 : ((cpu & 0x40) > 0 ? 50 : ((cpu & 0x80) > 0 ? 40 : -1)))));
        System.loadLibrary("vinit");
    }
}

