/*
 * Decompiled with CFR 0.152.
 */
package io.vov.vitamio.provider;

import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.Context;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.os.ParcelFileDescriptor;
import android.provider.BaseColumns;
import io.vov.vitamio.provider.MiniThumbFile;
import io.vov.vitamio.utils.Log;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;

public final class MediaStore {
    public static final String AUTHORITY = "me.abitno.vplayer.mediaprovider";
    public static final String MEDIA_SCANNER_VOLUME = "volume";
    public static final String CONTENT_AUTHORITY_SLASH = "content://me.abitno.vplayer.mediaprovider/";
    public static final Uri CONTENT_URI = Uri.parse((String)"content://me.abitno.vplayer.mediaprovider/");
    private static final String BASE_SQL_FIELDS = "_id INTEGER PRIMARY KEY,_data TEXT NOT NULL,_directory TEXT NOT NULL,_directory_name TEXT NOT NULL,_size INTEGER,_display_name TEXT,title TEXT,title_key TEXT,date_added INTEGER,date_modified INTEGER,mime_type TEXT,available_size INTEGER default 0,play_status INTEGER ,";

    public static Uri getMediaScannerUri() {
        return Uri.parse((String)"content://me.abitno.vplayer.mediaprovider/media_scanner");
    }

    public static Uri getVolumeUri() {
        return Uri.parse((String)"content://me.abitno.vplayer.mediaprovider/volume");
    }

    private static class InternalThumbnails
    implements BaseColumns {
        static final int DEFAULT_GROUP_ID = 0;
        private static final int MINI_KIND = 1;
        private static final int MICRO_KIND = 3;
        private static final String[] PROJECTION = new String[]{"_id", "_data"};
        private static final Object sThumbBufLock = new Object();
        private static byte[] sThumbBuf;

        private InternalThumbnails() {
        }

        private static Bitmap getMiniThumbFromFile(Cursor c, Uri baseUri, ContentResolver cr, BitmapFactory.Options options) {
            Bitmap bitmap = null;
            Uri thumbUri = null;
            try {
                long thumbId = c.getLong(0);
                thumbUri = ContentUris.withAppendedId((Uri)baseUri, (long)thumbId);
                ParcelFileDescriptor pfdInput = cr.openFileDescriptor(thumbUri, "r");
                bitmap = BitmapFactory.decodeFileDescriptor((FileDescriptor)pfdInput.getFileDescriptor(), null, (BitmapFactory.Options)options);
                pfdInput.close();
            }
            catch (FileNotFoundException ex) {
                Log.e("getMiniThumbFromFile", ex);
            }
            catch (IOException ex) {
                Log.e("getMiniThumbFromFile", ex);
            }
            catch (OutOfMemoryError ex) {
                Log.e("getMiniThumbFromFile", ex);
            }
            return bitmap;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static void cancelThumbnailRequest(ContentResolver cr, long origId, Uri baseUri, long groupId) {
            Uri cancelUri = baseUri.buildUpon().appendQueryParameter("cancel", "1").appendQueryParameter("orig_id", String.valueOf(origId)).appendQueryParameter("group_id", String.valueOf(groupId)).build();
            try (Cursor c = null;){
                c = cr.query(cancelUri, PROJECTION, null, null, null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static String getThumbnailPath(Context ctx, ContentResolver cr, long origId, Uri baseUri) {
            String column = "video_id=";
            String path = "";
            try (Cursor c = null;){
                c = cr.query(baseUri, PROJECTION, column + origId, null, null);
                if (c != null && c.moveToFirst()) {
                    path = c.getString(c.getColumnIndex("_data"));
                }
            }
            return path;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static Bitmap getThumbnail(Context ctx, ContentResolver cr, long origId, long groupId, int kind, BitmapFactory.Options options, Uri baseUri) {
            Bitmap bitmap;
            block30: {
                bitmap = null;
                MiniThumbFile thumbFile = MiniThumbFile.instance(baseUri);
                long magic = thumbFile.getMagic(origId);
                if (magic != 0L) {
                    if (kind == 3) {
                        Object object = sThumbBufLock;
                        synchronized (object) {
                            if (sThumbBuf == null) {
                                sThumbBuf = new byte[10000];
                            }
                            if (thumbFile.getMiniThumbFromFile(origId, sThumbBuf) != null && (bitmap = BitmapFactory.decodeByteArray((byte[])sThumbBuf, (int)0, (int)sThumbBuf.length)) == null) {
                                Log.d("couldn't decode byte array.", new Object[0]);
                            }
                        }
                        return bitmap;
                    }
                    if (kind == 1) {
                        String column = "video_id=";
                        try (Cursor c = null;){
                            c = cr.query(baseUri, PROJECTION, column + origId, null, null);
                            if (c != null && c.moveToFirst() && (bitmap = InternalThumbnails.getMiniThumbFromFile(c, baseUri, cr, options)) != null) {
                                Bitmap bitmap2 = bitmap;
                                return bitmap2;
                            }
                        }
                    }
                }
                try (Cursor c = null;){
                    Uri blockingUri = baseUri.buildUpon().appendQueryParameter("blocking", "1").appendQueryParameter("orig_id", String.valueOf(origId)).appendQueryParameter("group_id", String.valueOf(groupId)).build();
                    c = cr.query(blockingUri, PROJECTION, null, null, null);
                    if (c == null) {
                        Bitmap bitmap3 = null;
                        return bitmap3;
                    }
                    if (kind == 3) {
                        Object object = sThumbBufLock;
                        synchronized (object) {
                            if (sThumbBuf == null) {
                                sThumbBuf = new byte[10000];
                            }
                            if (thumbFile.getMiniThumbFromFile(origId, sThumbBuf) != null && (bitmap = BitmapFactory.decodeByteArray((byte[])sThumbBuf, (int)0, (int)sThumbBuf.length)) == null) {
                                Log.d("couldn't decode byte array.", new Object[0]);
                            }
                            break block30;
                        }
                    }
                    if (kind == 1) {
                        if (c.moveToFirst()) {
                            bitmap = InternalThumbnails.getMiniThumbFromFile(c, baseUri, cr, options);
                        }
                        break block30;
                    }
                    throw new IllegalArgumentException("Unsupported kind: " + kind);
                }
            }
            return bitmap;
        }
    }

    public static final class Video {

        public static class Thumbnails
        implements BaseColumns {
            public static final int MINI_KIND = 1;
            public static final int MICRO_KIND = 3;
            public static final Uri CONTENT_URI = Uri.parse((String)"content://me.abitno.vplayer.mediaprovider/videos/thumbnails");
            public static final String THUMBNAILS_DIRECTORY = "Android/data/me.abitno.vplayer.t/thumbnails";
            public static final String DATA = "_data";
            public static final String VIDEO_ID = "video_id";
            public static final String KIND = "kind";
            public static final String WIDTH = "width";
            public static final String HEIGHT = "height";
            protected static final String TABLE_NAME = "videothumbnails";
            protected static final String SQL_FIELDS = "_id INTEGER PRIMARY KEY,_data TEXT,video_id INTEGER,kind INTEGER,width INTEGER,height INTEGER";
            protected static final String SQL_INDEX_VIDEO_ID = "CREATE INDEX IF NOT EXISTS video_id_index on videothumbnails(video_id);";
            protected static final String SQL_TRIGGER_VIDEO_THUMBNAILS_CLEANUP = "CREATE TRIGGER IF NOT EXISTS videothumbnails_cleanup DELETE ON videothumbnails BEGIN SELECT _DELETE_FILE(old._data);END";

            public static void cancelThumbnailRequest(ContentResolver cr, long origId) {
                InternalThumbnails.cancelThumbnailRequest(cr, origId, CONTENT_URI, 0L);
            }

            public static Bitmap getThumbnail(Context ctx, ContentResolver cr, long origId, int kind, BitmapFactory.Options options) {
                return InternalThumbnails.getThumbnail(ctx, cr, origId, 0L, kind, options, CONTENT_URI);
            }

            public static Bitmap getThumbnail(Context ctx, ContentResolver cr, long origId, long groupId, int kind, BitmapFactory.Options options) {
                return InternalThumbnails.getThumbnail(ctx, cr, origId, groupId, kind, options, CONTENT_URI);
            }

            public static String getThumbnailPath(Context ctx, ContentResolver cr, long origId) {
                return InternalThumbnails.getThumbnailPath(ctx, cr, origId, CONTENT_URI);
            }

            public static void cancelThumbnailRequest(ContentResolver cr, long origId, long groupId) {
                InternalThumbnails.cancelThumbnailRequest(cr, origId, CONTENT_URI, groupId);
            }
        }

        public static final class Media
        implements VideoColumns {
            public static final Uri CONTENT_URI = Uri.parse((String)"content://me.abitno.vplayer.mediaprovider/videos/media");
            public static final String CONTENT_TYPE = "vnd.android.cursor.dir/video";
            protected static final String TABLE_NAME = "videos";
            protected static final String SQL_FIELDS = "_id INTEGER PRIMARY KEY,_data TEXT NOT NULL,_directory TEXT NOT NULL,_directory_name TEXT NOT NULL,_size INTEGER,_display_name TEXT,title TEXT,title_key TEXT,date_added INTEGER,date_modified INTEGER,mime_type TEXT,available_size INTEGER default 0,play_status INTEGER ,duration INTEGER,artist TEXT,album TEXT,width INTEGER,height INTEGER,description TEXT,language TEXT,latitude DOUBLE,longitude DOUBLE,datetaken INTEGER,bookmark INTEGER,mini_thumb_magic INTEGER,hidden INTEGER default 0,sub_track TEXT,audio_track INTEGER";
            protected static final String SQL_TRIGGER_VIDEO_CLEANUP = "CREATE TRIGGER IF NOT EXISTS video_cleanup AFTER DELETE ON videos BEGIN SELECT _DELETE_FILE(old._data);SELECT _DELETE_FILE(old._data || '.ssi');END";
            protected static final String SQL_TRIGGER_VIDEO_UPDATE = "CREATE TRIGGER IF NOT EXISTS video_update AFTER UPDATE ON videos WHEN new._data <> old._data BEGIN SELECT _DELETE_FILE(old._data || '.ssi');END";
        }

        public static interface VideoColumns
        extends MediaColumns {
            public static final String DURATION = "duration";
            public static final String ARTIST = "artist";
            public static final String ALBUM = "album";
            public static final String WIDTH = "width";
            public static final String HEIGHT = "height";
            public static final String DESCRIPTION = "description";
            public static final String LANGUAGE = "language";
            public static final String LATITUDE = "latitude";
            public static final String LONGITUDE = "longitude";
            public static final String DATE_TAKEN = "datetaken";
            public static final String BOOKMARK = "bookmark";
            public static final String MINI_THUMB_MAGIC = "mini_thumb_magic";
            public static final String HIDDEN = "hidden";
            public static final String SUBTRACK = "sub_track";
            public static final String AUDIO_TRACK = "audio_track";
        }
    }

    public static final class Audio {

        public static final class Media
        implements AudioColumns {
            public static final Uri CONTENT_URI = Uri.parse((String)"content://me.abitno.vplayer.mediaprovider/audios/media");
            public static final String CONTENT_TYPE = "vnd.android.cursor.dir/audio";
        }

        public static interface AudioColumns
        extends MediaColumns {
            public static final String DURATION = "duration";
            public static final String BOOKMARK = "bookmark";
            public static final String ARTIST = "artist";
            public static final String COMPOSER = "composer";
            public static final String ALBUM = "album";
            public static final String TRACK = "track";
            public static final String YEAR = "year";
        }
    }

    public static interface MediaColumns
    extends BaseColumns {
        public static final String DATA = "_data";
        public static final String DIRECTORY = "_directory";
        public static final String DIRECTORY_NAME = "_directory_name";
        public static final String SIZE = "_size";
        public static final String DISPLAY_NAME = "_display_name";
        public static final String TITLE = "title";
        public static final String TITLE_KEY = "title_key";
        public static final String DATE_ADDED = "date_added";
        public static final String DATE_MODIFIED = "date_modified";
        public static final String MIME_TYPE = "mime_type";
        public static final String AVAILABLE_SIZE = "available_size";
        public static final String PLAY_STATUS = "play_status";
    }
}

