/*
 * Decompiled with CFR 0.152.
 */
package io.vov.vitamio.provider;

import android.net.Uri;
import android.os.Environment;
import io.vov.vitamio.utils.Log;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.Hashtable;

public class MiniThumbFile {
    protected static final int BYTES_PER_MINTHUMB = 10000;
    private static final int MINI_THUMB_DATA_FILE_VERSION = 7;
    private static final int HEADER_SIZE = 13;
    private static Hashtable<String, MiniThumbFile> sThumbFiles = new Hashtable();
    private Uri mUri;
    private RandomAccessFile mMiniThumbFile;
    private FileChannel mChannel;
    private ByteBuffer mBuffer;

    public MiniThumbFile(Uri uri) {
        this.mUri = uri;
        this.mBuffer = ByteBuffer.allocateDirect(10000);
    }

    protected static synchronized void reset() {
        for (MiniThumbFile file : sThumbFiles.values()) {
            file.deactivate();
        }
        sThumbFiles.clear();
    }

    protected static synchronized MiniThumbFile instance(Uri uri) {
        String type = (String)uri.getPathSegments().get(0);
        MiniThumbFile file = sThumbFiles.get(type);
        if (file == null) {
            file = new MiniThumbFile(Uri.parse((String)("content://me.abitno.vplayer.mediaprovider/" + type + "/media")));
            sThumbFiles.put(type, file);
        }
        return file;
    }

    private String randomAccessFilePath(int version) {
        String directoryName = Environment.getExternalStorageDirectory().toString() + "/" + "Android/data/me.abitno.vplayer.t/thumbnails";
        return directoryName + "/.thumbdata" + version + "-" + this.mUri.hashCode();
    }

    private void removeOldFile() {
        String oldPath = this.randomAccessFilePath(6);
        File oldFile = new File(oldPath);
        if (oldFile.exists()) {
            try {
                oldFile.delete();
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
    }

    private RandomAccessFile miniThumbDataFile() {
        if (this.mMiniThumbFile == null) {
            this.removeOldFile();
            String path = this.randomAccessFilePath(7);
            File directory = new File(path).getParentFile();
            if (!directory.isDirectory() && !directory.mkdirs()) {
                Log.e("Unable to create .thumbnails directory %s", directory.toString());
            }
            File f = new File(path);
            try {
                this.mMiniThumbFile = new RandomAccessFile(f, "rw");
            }
            catch (IOException ex) {
                try {
                    this.mMiniThumbFile = new RandomAccessFile(f, "r");
                }
                catch (IOException ex2) {
                    // empty catch block
                }
            }
            if (this.mMiniThumbFile != null) {
                this.mChannel = this.mMiniThumbFile.getChannel();
            }
        }
        return this.mMiniThumbFile;
    }

    protected synchronized void deactivate() {
        if (this.mMiniThumbFile != null) {
            try {
                this.mMiniThumbFile.close();
                this.mMiniThumbFile = null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized long getMagic(long id) {
        RandomAccessFile r = this.miniThumbDataFile();
        if (r != null) {
            long pos = id * 10000L;
            FileLock lock = null;
            try {
                this.mBuffer.clear();
                this.mBuffer.limit(9);
                lock = this.mChannel.lock(pos, 9L, true);
                if (this.mChannel.read(this.mBuffer, pos) == 9) {
                    this.mBuffer.position(0);
                    if (this.mBuffer.get() == 1) {
                        long l = this.mBuffer.getLong();
                        return l;
                    }
                }
            }
            catch (IOException ex) {
                Log.e("Got exception checking file magic: ", ex);
            }
            catch (RuntimeException ex) {
                Log.e("Got exception when reading magic, id = %d, disk full or mount read-only? %s", id, ex.getClass().toString());
            }
            finally {
                try {
                    if (lock != null) {
                        lock.release();
                    }
                }
                catch (IOException ex) {}
            }
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void saveMiniThumbToFile(byte[] data, long id, long magic) throws IOException {
        RandomAccessFile r = this.miniThumbDataFile();
        if (r == null) {
            return;
        }
        long pos = id * 10000L;
        FileLock lock = null;
        try {
            if (data != null) {
                if (data.length > 9987) {
                    return;
                }
                this.mBuffer.clear();
                this.mBuffer.put((byte)1);
                this.mBuffer.putLong(magic);
                this.mBuffer.putInt(data.length);
                this.mBuffer.put(data);
                this.mBuffer.flip();
                lock = this.mChannel.lock(pos, 10000L, false);
                this.mChannel.write(this.mBuffer, pos);
            }
        }
        catch (IOException ex) {
            Log.e("couldn't save mini thumbnail data for %d; %s", id, ex.getMessage());
            throw ex;
        }
        catch (RuntimeException ex) {
            Log.e("couldn't save mini thumbnail data for %d, disk full or mount read-only? %s", id, ex.getClass().toString());
        }
        finally {
            try {
                if (lock != null) {
                    lock.release();
                }
            }
            catch (IOException ex) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized byte[] getMiniThumbFromFile(long id, byte[] data) {
        RandomAccessFile r = this.miniThumbDataFile();
        if (r == null) {
            return null;
        }
        long pos = id * 10000L;
        FileLock lock = null;
        try {
            this.mBuffer.clear();
            lock = this.mChannel.lock(pos, 10000L, true);
            int size = this.mChannel.read(this.mBuffer, pos);
            if (size > 13) {
                this.mBuffer.position(9);
                int length = this.mBuffer.getInt();
                if (size >= 13 + length && data.length >= length) {
                    this.mBuffer.get(data, 0, length);
                    byte[] byArray = data;
                    return byArray;
                }
            }
        }
        catch (IOException ex) {
            Log.e("got exception when reading thumbnail id = %d, exception: %s", id, ex.getMessage());
        }
        catch (RuntimeException ex) {
            Log.e("Got exception when reading thumbnail, id = %d, disk full or mount read-only? %s", id, ex.getClass().toString());
        }
        finally {
            try {
                if (lock != null) {
                    lock.release();
                }
            }
            catch (IOException ex) {}
        }
        return null;
    }
}

