/*
 * Decompiled with CFR 0.152.
 */
package io.vov.vitamio.utils;

import android.os.Build;
import android.text.TextUtils;
import io.vov.vitamio.utils.Log;
import io.vov.vitamio.utils.StringUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class CPU {
    private static final Map<String, String> cpuinfo = new HashMap<String, String>();
    private static int cachedFeature = -1;
    private static String cachedFeatureString = null;
    public static final int FEATURE_ARM_V5TE = 1;
    public static final int FEATURE_ARM_V6 = 2;
    public static final int FEATURE_ARM_VFP = 4;
    public static final int FEATURE_ARM_V7A = 8;
    public static final int FEATURE_ARM_VFPV3 = 16;
    public static final int FEATURE_ARM_NEON = 32;
    public static final int FEATURE_X86 = 64;
    public static final int FEATURE_MIPS = 128;

    public static String getFeatureString() {
        CPU.getFeature();
        return cachedFeatureString;
    }

    public static int getFeature() {
        if (cachedFeature > 0) {
            return CPU.getCachedFeature();
        }
        cachedFeature = 1;
        if (cpuinfo.isEmpty()) {
            Object bis = null;
            try {
                String line;
                bis = new BufferedReader(new FileReader(new File("/proc/cpuinfo")));
                while ((line = ((BufferedReader)bis).readLine()) != null) {
                    String[] pairs;
                    if (line.trim().equals("") || (pairs = line.split(":")).length <= 1) continue;
                    cpuinfo.put(pairs[0].trim(), pairs[1].trim());
                }
            }
            catch (Exception e) {
                Log.e("getCPUFeature", e);
            }
            finally {
                try {
                    if (bis != null) {
                        ((BufferedReader)bis).close();
                    }
                }
                catch (IOException e) {
                    Log.e("getCPUFeature", e);
                }
            }
        }
        if (!cpuinfo.isEmpty()) {
            for (String key : cpuinfo.keySet()) {
                Log.d("%s:%s", key, cpuinfo.get(key));
            }
            boolean hasARMv6 = false;
            boolean hasARMv7 = false;
            String val = cpuinfo.get("CPU architecture");
            if (!TextUtils.isEmpty((CharSequence)val)) {
                try {
                    int i = StringUtils.convertToInt(val);
                    Log.d("CPU architecture: %s", i);
                    if (i >= 7) {
                        hasARMv6 = true;
                        hasARMv7 = true;
                    } else if (i >= 6) {
                        hasARMv6 = true;
                        hasARMv7 = false;
                    }
                }
                catch (NumberFormatException ex) {
                    Log.e("getCPUFeature", ex);
                }
                val = cpuinfo.get("Processor");
                if (val != null && (val.contains("(v7l)") || val.contains("ARMv7"))) {
                    hasARMv6 = true;
                    hasARMv7 = true;
                }
                if (val != null && (val.contains("(v6l)") || val.contains("ARMv6"))) {
                    hasARMv6 = true;
                    hasARMv7 = false;
                }
                if (hasARMv6) {
                    cachedFeature |= 2;
                }
                if (hasARMv7) {
                    cachedFeature |= 8;
                }
                if ((val = cpuinfo.get("Features")) != null) {
                    if (val.contains("neon")) {
                        cachedFeature |= 0x34;
                    } else if (val.contains("vfpv3")) {
                        cachedFeature |= 0x14;
                    } else if (val.contains("vfp")) {
                        cachedFeature |= 4;
                    }
                }
            } else {
                String vendor_id = cpuinfo.get("vendor_id");
                String mips = cpuinfo.get("cpu model");
                if (!TextUtils.isEmpty((CharSequence)vendor_id) && vendor_id.contains("GenuineIntel")) {
                    cachedFeature |= 0x40;
                } else if (!TextUtils.isEmpty((CharSequence)mips) && mips.contains("MIPS")) {
                    cachedFeature |= 0x80;
                }
            }
        }
        return CPU.getCachedFeature();
    }

    private static int getCachedFeature() {
        if (cachedFeatureString == null) {
            StringBuffer sb = new StringBuffer();
            if ((cachedFeature & 1) > 0) {
                sb.append("V5TE ");
            }
            if ((cachedFeature & 2) > 0) {
                sb.append("V6 ");
            }
            if ((cachedFeature & 4) > 0) {
                sb.append("VFP ");
            }
            if ((cachedFeature & 8) > 0) {
                sb.append("V7A ");
            }
            if ((cachedFeature & 0x10) > 0) {
                sb.append("VFPV3 ");
            }
            if ((cachedFeature & 0x20) > 0) {
                sb.append("NEON ");
            }
            if ((cachedFeature & 0x40) > 0) {
                sb.append("X86 ");
            }
            if ((cachedFeature & 0x80) > 0) {
                sb.append("MIPS ");
            }
            cachedFeatureString = sb.toString();
        }
        Log.d("GET CPU FATURE: %s", cachedFeatureString);
        return cachedFeature;
    }

    public static boolean isDroidXDroid2() {
        return Build.MODEL.trim().equalsIgnoreCase("DROIDX") || Build.MODEL.trim().equalsIgnoreCase("DROID2") || Build.FINGERPRINT.toLowerCase().contains("shadow") || Build.FINGERPRINT.toLowerCase().contains("droid2");
    }
}

