/*
 * Decompiled with CFR 0.152.
 */
package io.vov.vitamio.utils;

import io.vov.vitamio.utils.Base64;
import io.vov.vitamio.utils.Log;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.Key;
import java.security.MessageDigest;
import java.security.PublicKey;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class Crypto {
    private Cipher ecipher;

    public Crypto(String key) {
        try {
            SecretKeySpec skey = new SecretKeySpec(Crypto.generateKey(key), "AES");
            this.setupCrypto(skey);
        }
        catch (Exception e) {
            Log.e("Crypto", e);
        }
    }

    private void setupCrypto(SecretKey key) {
        byte[] iv = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
        IvParameterSpec paramSpec = new IvParameterSpec(iv);
        try {
            this.ecipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            this.ecipher.init(1, (Key)key, paramSpec);
        }
        catch (Exception e) {
            this.ecipher = null;
            Log.e("setupCrypto", e);
        }
    }

    public String encrypt(String plaintext) {
        if (this.ecipher == null) {
            return "";
        }
        try {
            byte[] ciphertext = this.ecipher.doFinal(plaintext.getBytes("UTF-8"));
            return Base64.encodeToString(ciphertext, 2);
        }
        catch (Exception e) {
            Log.e("encryp", e);
            return "";
        }
    }

    public static String md5(String plain) {
        try {
            MessageDigest m = MessageDigest.getInstance("MD5");
            m.update(plain.getBytes());
            byte[] digest = m.digest();
            BigInteger bigInt = new BigInteger(1, digest);
            String hashtext = bigInt.toString(16);
            while (hashtext.length() < 32) {
                hashtext = "0" + hashtext;
            }
            return hashtext;
        }
        catch (Exception e) {
            return "";
        }
    }

    private static byte[] generateKey(String input) {
        try {
            byte[] bytesOfMessage = input.getBytes("UTF-8");
            MessageDigest md = MessageDigest.getInstance("SHA256");
            return md.digest(bytesOfMessage);
        }
        catch (Exception e) {
            Log.e("generateKey", e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PublicKey readKeyFromStream(InputStream keyStream) throws IOException {
        try (ObjectInputStream oin = new ObjectInputStream(new BufferedInputStream(keyStream));){
            PublicKey pubKey;
            PublicKey publicKey = pubKey = (PublicKey)oin.readObject();
            return publicKey;
        }
    }

    public String rsaEncrypt(InputStream keyStream, String data) {
        try {
            return this.rsaEncrypt(keyStream, data.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
    }

    public String rsaEncrypt(InputStream keyStream, byte[] data) {
        try {
            PublicKey pubKey = this.readKeyFromStream(keyStream);
            Cipher cipher = Cipher.getInstance("RSA/ECB/NoPadding");
            cipher.init(1, pubKey);
            byte[] cipherData = cipher.doFinal(data);
            return Base64.encodeToString(cipherData, 2);
        }
        catch (Exception e) {
            Log.e("rsaEncrypt", e);
            return "";
        }
    }
}

