/*
 * Decompiled with CFR 0.152.
 */
package io.vov.vitamio.utils;

import android.annotation.SuppressLint;
import android.content.ContentResolver;
import android.content.Context;
import android.net.ConnectivityManager;
import android.os.Build;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import android.util.DisplayMetrics;
import io.vov.vitamio.utils.CPU;
import io.vov.vitamio.utils.Crypto;
import io.vov.vitamio.utils.Log;
import java.util.Locale;

public class Device {
    public static String getLocale() {
        Locale locale = Locale.getDefault();
        if (locale != null) {
            String lo = locale.getLanguage();
            Log.i("getLocale " + lo, new Object[0]);
            if (lo != null) {
                return lo.toLowerCase();
            }
        }
        return "en";
    }

    public static String getDeviceFeatures(Context ctx) {
        return Device.getIdentifiers(ctx) + Device.getSystemFeatures() + Device.getScreenFeatures(ctx);
    }

    @SuppressLint(value={"NewApi"})
    public static String getIdentifiers(Context ctx) {
        StringBuilder sb = new StringBuilder();
        if (Build.VERSION.SDK_INT > 8) {
            sb.append(Device.getPair("serial", Build.SERIAL));
        } else {
            sb.append(Device.getPair("serial", "No Serial"));
        }
        sb.append(Device.getPair("android_id", Settings.Secure.getString((ContentResolver)ctx.getContentResolver(), (String)"android_id")));
        TelephonyManager tel = (TelephonyManager)ctx.getSystemService("phone");
        sb.append(Device.getPair("sim_country_iso", tel.getSimCountryIso()));
        sb.append(Device.getPair("network_operator_name", tel.getNetworkOperatorName()));
        sb.append(Device.getPair("unique_id", Crypto.md5(sb.toString())));
        ConnectivityManager cm = (ConnectivityManager)ctx.getSystemService("connectivity");
        sb.append(Device.getPair("network_type", cm.getActiveNetworkInfo() == null ? "-1" : String.valueOf(cm.getActiveNetworkInfo().getType())));
        return sb.toString();
    }

    public static String getSystemFeatures() {
        StringBuilder sb = new StringBuilder();
        sb.append(Device.getPair("android_release", Build.VERSION.RELEASE));
        sb.append(Device.getPair("android_sdk_int", "" + Build.VERSION.SDK_INT));
        sb.append(Device.getPair("device_cpu_abi", Build.CPU_ABI));
        sb.append(Device.getPair("device_model", Build.MODEL));
        sb.append(Device.getPair("device_manufacturer", Build.MANUFACTURER));
        sb.append(Device.getPair("device_board", Build.BOARD));
        sb.append(Device.getPair("device_fingerprint", Build.FINGERPRINT));
        sb.append(Device.getPair("device_cpu_feature", CPU.getFeatureString()));
        return sb.toString();
    }

    public static String getScreenFeatures(Context ctx) {
        StringBuilder sb = new StringBuilder();
        DisplayMetrics disp = ctx.getResources().getDisplayMetrics();
        sb.append(Device.getPair("screen_density", "" + disp.density));
        sb.append(Device.getPair("screen_density_dpi", "" + disp.densityDpi));
        sb.append(Device.getPair("screen_height_pixels", "" + disp.heightPixels));
        sb.append(Device.getPair("screen_width_pixels", "" + disp.widthPixels));
        sb.append(Device.getPair("screen_scaled_density", "" + disp.scaledDensity));
        sb.append(Device.getPair("screen_xdpi", "" + disp.xdpi));
        sb.append(Device.getPair("screen_ydpi", "" + disp.ydpi));
        return sb.toString();
    }

    private static String getPair(String key, String value) {
        key = key == null ? "" : key.trim();
        value = value == null ? "" : value.trim();
        return "&" + key + "=" + value;
    }
}

