/*
 * Decompiled with CFR 0.152.
 */
package io.vov.vitamio.utils;

import android.net.Uri;
import android.text.TextUtils;
import io.vov.vitamio.utils.Crypto;
import io.vov.vitamio.utils.Log;
import java.io.File;
import java.io.IOException;

public class FileUtils {
    private static final String FILE_NAME_RESERVED = "|\\?*<\":>+[]/'";

    public static String getUniqueFileName(String name, String id) {
        StringBuilder sb = new StringBuilder();
        char[] cArray = name.toCharArray();
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            Character c = Character.valueOf(cArray[i]);
            if (FILE_NAME_RESERVED.indexOf(c.charValue()) != -1) continue;
            sb.append(c);
        }
        name = sb.toString();
        if (name.length() > 16) {
            name = name.substring(0, 16);
        }
        id = Crypto.md5(id);
        name = name + id;
        try {
            File f = File.createTempFile(name, null);
            if (f.exists()) {
                f.delete();
                return name;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return id;
    }

    public static String getCanonical(File f) {
        if (f == null) {
            return null;
        }
        try {
            return f.getCanonicalPath();
        }
        catch (IOException e) {
            return f.getAbsolutePath();
        }
    }

    public static String getPath(String uri) {
        Log.i("FileUtils#getPath(%s)", uri);
        if (TextUtils.isEmpty((CharSequence)uri)) {
            return null;
        }
        if (uri.startsWith("file://") && uri.length() > 7) {
            return Uri.decode((String)uri.substring(7));
        }
        return Uri.decode((String)uri);
    }

    public static String getName(String uri) {
        String path = FileUtils.getPath(uri);
        if (path != null) {
            return new File(path).getName();
        }
        return null;
    }

    public static void deleteDir(File f) {
        if (f.exists() && f.isDirectory()) {
            for (File file : f.listFiles()) {
                if (file.isDirectory()) {
                    FileUtils.deleteDir(file);
                }
                file.delete();
            }
            f.delete();
        }
    }
}

