/*
 * Decompiled with CFR 0.152.
 */
package io.vov.vitamio.utils;

import io.vov.vitamio.utils.Log;
import java.util.Arrays;
import java.util.Iterator;

public class StringUtils {
    public static String join(Object[] elements, CharSequence separator) {
        return StringUtils.join(Arrays.asList(elements), separator);
    }

    public static String join(Iterable<? extends Object> elements, CharSequence separator) {
        Iterator<? extends Object> iter;
        StringBuilder builder = new StringBuilder();
        if (elements != null && (iter = elements.iterator()).hasNext()) {
            builder.append(String.valueOf(iter.next()));
            while (iter.hasNext()) {
                builder.append(separator).append(String.valueOf(iter.next()));
            }
        }
        return builder.toString();
    }

    public static String fixLastSlash(String str) {
        String res;
        String string = res = str == null ? "/" : str.trim() + "/";
        if (res.length() > 2 && res.charAt(res.length() - 2) == '/') {
            res = res.substring(0, res.length() - 1);
        }
        return res;
    }

    public static int convertToInt(String str) throws NumberFormatException {
        int e;
        int s;
        for (s = 0; s < str.length() && !Character.isDigit(str.charAt(s)); ++s) {
        }
        for (e = str.length(); e > 0 && !Character.isDigit(str.charAt(e - 1)); --e) {
        }
        if (e > s) {
            try {
                return Integer.parseInt(str.substring(s, e));
            }
            catch (NumberFormatException ex) {
                Log.e("convertToInt", ex);
                throw new NumberFormatException();
            }
        }
        throw new NumberFormatException();
    }

    public static String generateTime(long time) {
        int totalSeconds = (int)(time / 1000L);
        int seconds = totalSeconds % 60;
        int minutes = totalSeconds / 60 % 60;
        int hours = totalSeconds / 3600;
        return hours > 0 ? String.format("%02d:%02d:%02d", hours, minutes, seconds) : String.format("%02d:%02d", minutes, seconds);
    }
}

