/*
 * Decompiled with CFR 0.152.
 */
package io.vov.vitamio.widget;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RemoteViews;

@RemoteViews.RemoteView
public class CenterLayout
extends ViewGroup {
    private int mPaddingLeft = 0;
    private int mPaddingRight = 0;
    private int mPaddingTop = 0;
    private int mPaddingBottom = 0;
    private int mWidth;
    private int mHeight;

    public CenterLayout(Context context) {
        super(context);
    }

    public CenterLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public CenterLayout(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int count = this.getChildCount();
        int maxHeight = 0;
        int maxWidth = 0;
        this.measureChildren(widthMeasureSpec, heightMeasureSpec);
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            int childRight = lp.x + child.getMeasuredWidth();
            int childBottom = lp.y + child.getMeasuredHeight();
            maxWidth = Math.max(maxWidth, childRight);
            maxHeight = Math.max(maxHeight, childBottom);
        }
        maxWidth += this.mPaddingLeft + this.mPaddingRight;
        maxHeight += this.mPaddingTop + this.mPaddingBottom;
        maxHeight = Math.max(maxHeight, this.getSuggestedMinimumHeight());
        maxWidth = Math.max(maxWidth, this.getSuggestedMinimumWidth());
        this.setMeasuredDimension(CenterLayout.resolveSize((int)maxWidth, (int)widthMeasureSpec), CenterLayout.resolveSize((int)maxHeight, (int)heightMeasureSpec));
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        int count = this.getChildCount();
        this.mWidth = this.getMeasuredWidth();
        this.mHeight = this.getMeasuredHeight();
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            int childLeft = this.mPaddingLeft + lp.x;
            childLeft = lp.width > 0 ? (childLeft += (int)((double)(this.mWidth - lp.width) / 2.0)) : (childLeft += (int)((double)(this.mWidth - child.getMeasuredWidth()) / 2.0));
            int childTop = this.mPaddingTop + lp.y;
            childTop = lp.height > 0 ? (childTop += (int)((double)(this.mHeight - lp.height) / 2.0)) : (childTop += (int)((double)(this.mHeight - child.getMeasuredHeight()) / 2.0));
            child.layout(childLeft, childTop, childLeft + child.getMeasuredWidth(), childTop + child.getMeasuredHeight());
        }
    }

    protected boolean checkLayoutParams(ViewGroup.LayoutParams p) {
        return p instanceof LayoutParams;
    }

    protected ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams p) {
        return new LayoutParams(p);
    }

    public static class LayoutParams
    extends ViewGroup.LayoutParams {
        public int x;
        public int y;

        public LayoutParams(int width, int height, int x, int y) {
            super(width, height);
            this.x = x;
            this.y = y;
        }

        public LayoutParams(ViewGroup.LayoutParams source) {
            super(source);
        }
    }
}

