/*
 * Decompiled with CFR 0.152.
 */
package io.vov.vitamio.widget;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Rect;
import android.media.AudioManager;
import android.os.Build;
import android.os.Handler;
import android.os.Message;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageButton;
import android.widget.PopupWindow;
import android.widget.SeekBar;
import android.widget.TextView;
import io.vov.vitamio.utils.Log;
import io.vov.vitamio.utils.StringUtils;
import io.vov.vitamio.widget.OutlineTextView;
import java.lang.reflect.Method;

public class MediaController
extends FrameLayout {
    private static final int sDefaultTimeout = 3000;
    private static final int FADE_OUT = 1;
    private static final int SHOW_PROGRESS = 2;
    private MediaPlayerControl mPlayer;
    private Context mContext;
    private PopupWindow mWindow;
    private int mAnimStyle;
    private View mAnchor;
    private View mRoot;
    private SeekBar mProgress;
    private TextView mEndTime;
    private TextView mCurrentTime;
    private TextView mFileName;
    private OutlineTextView mInfoView;
    private String mTitle;
    private long mDuration;
    private boolean mShowing;
    private boolean mDragging;
    private boolean mInstantSeeking = false;
    private boolean mFromXml = false;
    private ImageButton mPauseButton;
    private AudioManager mAM;
    private OnShownListener mShownListener;
    private OnHiddenListener mHiddenListener;
    @SuppressLint(value={"HandlerLeak"})
    private Handler mHandler = new Handler(){

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    MediaController.this.hide();
                    break;
                }
                case 2: {
                    long pos = MediaController.this.setProgress();
                    if (MediaController.this.mDragging || !MediaController.this.mShowing) break;
                    msg = this.obtainMessage(2);
                    this.sendMessageDelayed(msg, 1000L - pos % 1000L);
                    MediaController.this.updatePausePlay();
                }
            }
        }
    };
    private View.OnClickListener mPauseListener = new View.OnClickListener(){

        public void onClick(View v) {
            MediaController.this.doPauseResume();
            MediaController.this.show(3000);
        }
    };
    private SeekBar.OnSeekBarChangeListener mSeekListener = new SeekBar.OnSeekBarChangeListener(){

        public void onStartTrackingTouch(SeekBar bar) {
            MediaController.this.mDragging = true;
            MediaController.this.show(3600000);
            MediaController.this.mHandler.removeMessages(2);
            if (MediaController.this.mInstantSeeking) {
                MediaController.this.mAM.setStreamMute(3, true);
            }
            if (MediaController.this.mInfoView != null) {
                MediaController.this.mInfoView.setText("");
                MediaController.this.mInfoView.setVisibility(0);
            }
        }

        public void onProgressChanged(SeekBar bar, int progress, boolean fromuser) {
            if (!fromuser) {
                return;
            }
            long newposition = MediaController.this.mDuration * (long)progress / 1000L;
            String time = StringUtils.generateTime(newposition);
            if (MediaController.this.mInstantSeeking) {
                MediaController.this.mPlayer.seekTo(newposition);
            }
            if (MediaController.this.mInfoView != null) {
                MediaController.this.mInfoView.setText(time);
            }
            if (MediaController.this.mCurrentTime != null) {
                MediaController.this.mCurrentTime.setText((CharSequence)time);
            }
        }

        public void onStopTrackingTouch(SeekBar bar) {
            if (!MediaController.this.mInstantSeeking) {
                MediaController.this.mPlayer.seekTo(MediaController.this.mDuration * (long)bar.getProgress() / 1000L);
            }
            if (MediaController.this.mInfoView != null) {
                MediaController.this.mInfoView.setText("");
                MediaController.this.mInfoView.setVisibility(8);
            }
            MediaController.this.show(3000);
            MediaController.this.mHandler.removeMessages(2);
            MediaController.this.mAM.setStreamMute(3, false);
            MediaController.this.mDragging = false;
            MediaController.this.mHandler.sendEmptyMessageDelayed(2, 1000L);
        }
    };

    public MediaController(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mRoot = this;
        this.mFromXml = true;
        this.initController(context);
    }

    public MediaController(Context context) {
        super(context);
        if (!this.mFromXml && this.initController(context)) {
            this.initFloatingWindow();
        }
    }

    private boolean initController(Context context) {
        this.mContext = context;
        this.mAM = (AudioManager)this.mContext.getSystemService("audio");
        return true;
    }

    public void onFinishInflate() {
        if (this.mRoot != null) {
            this.initControllerView(this.mRoot);
        }
    }

    private void initFloatingWindow() {
        this.mWindow = new PopupWindow(this.mContext);
        this.mWindow.setFocusable(false);
        this.mWindow.setBackgroundDrawable(null);
        this.mWindow.setOutsideTouchable(true);
        this.mAnimStyle = 0x1030000;
    }

    @TargetApi(value=16)
    public void setWindowLayoutType() {
        if (Build.VERSION.SDK_INT >= 14) {
            try {
                this.mAnchor.setSystemUiVisibility(512);
                Method setWindowLayoutType = PopupWindow.class.getMethod("setWindowLayoutType", Integer.TYPE);
                setWindowLayoutType.invoke((Object)this.mWindow, 1003);
            }
            catch (Exception e) {
                Log.e("setWindowLayoutType", e);
            }
        }
    }

    public void setAnchorView(View view) {
        this.mAnchor = view;
        if (!this.mFromXml) {
            this.removeAllViews();
            this.mRoot = this.makeControllerView();
            this.mWindow.setContentView(this.mRoot);
            this.mWindow.setWidth(-1);
            this.mWindow.setHeight(-2);
        }
        this.initControllerView(this.mRoot);
    }

    protected View makeControllerView() {
        return ((LayoutInflater)this.mContext.getSystemService("layout_inflater")).inflate(this.getResources().getIdentifier("mediacontroller", "layout", this.mContext.getPackageName()), (ViewGroup)this);
    }

    private void initControllerView(View v) {
        this.mPauseButton = (ImageButton)v.findViewById(this.getResources().getIdentifier("mediacontroller_play_pause", "id", this.mContext.getPackageName()));
        if (this.mPauseButton != null) {
            this.mPauseButton.requestFocus();
            this.mPauseButton.setOnClickListener(this.mPauseListener);
        }
        this.mProgress = (SeekBar)v.findViewById(this.getResources().getIdentifier("mediacontroller_seekbar", "id", this.mContext.getPackageName()));
        if (this.mProgress != null) {
            if (this.mProgress instanceof SeekBar) {
                SeekBar seeker = this.mProgress;
                seeker.setOnSeekBarChangeListener(this.mSeekListener);
            }
            this.mProgress.setMax(1000);
        }
        this.mEndTime = (TextView)v.findViewById(this.getResources().getIdentifier("mediacontroller_time_total", "id", this.mContext.getPackageName()));
        this.mCurrentTime = (TextView)v.findViewById(this.getResources().getIdentifier("mediacontroller_time_current", "id", this.mContext.getPackageName()));
        this.mFileName = (TextView)v.findViewById(this.getResources().getIdentifier("mediacontroller_file_name", "id", this.mContext.getPackageName()));
        if (this.mFileName != null) {
            this.mFileName.setText((CharSequence)this.mTitle);
        }
    }

    public void setMediaPlayer(MediaPlayerControl player) {
        this.mPlayer = player;
        this.updatePausePlay();
    }

    public void setInstantSeeking(boolean seekWhenDragging) {
        this.mInstantSeeking = seekWhenDragging;
    }

    public void show() {
        this.show(3000);
    }

    public void setFileName(String name) {
        this.mTitle = name;
        if (this.mFileName != null) {
            this.mFileName.setText((CharSequence)this.mTitle);
        }
    }

    public void setInfoView(OutlineTextView v) {
        this.mInfoView = v;
    }

    public void setAnimationStyle(int animationStyle) {
        this.mAnimStyle = animationStyle;
    }

    public void show(int timeout) {
        if (!this.mShowing && this.mAnchor != null && this.mAnchor.getWindowToken() != null) {
            if (this.mPauseButton != null) {
                this.mPauseButton.requestFocus();
            }
            if (this.mFromXml) {
                this.setVisibility(0);
            } else {
                int[] location = new int[2];
                this.mAnchor.getLocationOnScreen(location);
                Rect anchorRect = new Rect(location[0], location[1], location[0] + this.mAnchor.getWidth(), location[1] + this.mAnchor.getHeight());
                this.mWindow.setAnimationStyle(this.mAnimStyle);
                this.setWindowLayoutType();
                this.mWindow.showAtLocation(this.mAnchor, 0, anchorRect.left, anchorRect.bottom);
            }
            this.mShowing = true;
            if (this.mShownListener != null) {
                this.mShownListener.onShown();
            }
        }
        this.updatePausePlay();
        this.mHandler.sendEmptyMessage(2);
        if (timeout != 0) {
            this.mHandler.removeMessages(1);
            this.mHandler.sendMessageDelayed(this.mHandler.obtainMessage(1), (long)timeout);
        }
    }

    public boolean isShowing() {
        return this.mShowing;
    }

    public void hide() {
        if (this.mAnchor == null) {
            return;
        }
        if (this.mShowing) {
            try {
                this.mHandler.removeMessages(2);
                if (this.mFromXml) {
                    this.setVisibility(8);
                } else {
                    this.mWindow.dismiss();
                }
            }
            catch (IllegalArgumentException ex) {
                Log.d("MediaController already removed", new Object[0]);
            }
            this.mShowing = false;
            if (this.mHiddenListener != null) {
                this.mHiddenListener.onHidden();
            }
        }
    }

    public void setOnShownListener(OnShownListener l) {
        this.mShownListener = l;
    }

    public void setOnHiddenListener(OnHiddenListener l) {
        this.mHiddenListener = l;
    }

    private long setProgress() {
        if (this.mPlayer == null || this.mDragging) {
            return 0L;
        }
        long position = this.mPlayer.getCurrentPosition();
        long duration = this.mPlayer.getDuration();
        if (this.mProgress != null) {
            if (duration > 0L) {
                long pos = 1000L * position / duration;
                this.mProgress.setProgress((int)pos);
            }
            int percent = this.mPlayer.getBufferPercentage();
            this.mProgress.setSecondaryProgress(percent * 10);
        }
        this.mDuration = duration;
        if (this.mEndTime != null) {
            this.mEndTime.setText((CharSequence)StringUtils.generateTime(this.mDuration));
        }
        if (this.mCurrentTime != null) {
            this.mCurrentTime.setText((CharSequence)StringUtils.generateTime(position));
        }
        return position;
    }

    public boolean onTouchEvent(MotionEvent event) {
        this.show(3000);
        return true;
    }

    public boolean onTrackballEvent(MotionEvent ev) {
        this.show(3000);
        return false;
    }

    public boolean dispatchKeyEvent(KeyEvent event) {
        int keyCode = event.getKeyCode();
        if (event.getRepeatCount() == 0 && (keyCode == 79 || keyCode == 85 || keyCode == 62)) {
            this.doPauseResume();
            this.show(3000);
            if (this.mPauseButton != null) {
                this.mPauseButton.requestFocus();
            }
            return true;
        }
        if (keyCode == 86) {
            if (this.mPlayer.isPlaying()) {
                this.mPlayer.pause();
                this.updatePausePlay();
            }
            return true;
        }
        if (keyCode == 4 || keyCode == 82) {
            this.hide();
            return true;
        }
        this.show(3000);
        return super.dispatchKeyEvent(event);
    }

    private void updatePausePlay() {
        if (this.mRoot == null || this.mPauseButton == null) {
            return;
        }
        if (this.mPlayer.isPlaying()) {
            this.mPauseButton.setImageResource(this.getResources().getIdentifier("mediacontroller_pause", "drawable", this.mContext.getPackageName()));
        } else {
            this.mPauseButton.setImageResource(this.getResources().getIdentifier("mediacontroller_play", "drawable", this.mContext.getPackageName()));
        }
    }

    private void doPauseResume() {
        if (this.mPlayer.isPlaying()) {
            this.mPlayer.pause();
        } else {
            this.mPlayer.start();
        }
        this.updatePausePlay();
    }

    public void setEnabled(boolean enabled) {
        if (this.mPauseButton != null) {
            this.mPauseButton.setEnabled(enabled);
        }
        if (this.mProgress != null) {
            this.mProgress.setEnabled(enabled);
        }
        super.setEnabled(enabled);
    }

    public static interface MediaPlayerControl {
        public void start();

        public void pause();

        public long getDuration();

        public long getCurrentPosition();

        public void seekTo(long var1);

        public boolean isPlaying();

        public int getBufferPercentage();
    }

    public static interface OnHiddenListener {
        public void onHidden();
    }

    public static interface OnShownListener {
        public void onShown();
    }
}

