/*
 * Decompiled with CFR 0.152.
 */
package io.vov.vitamio.widget;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Typeface;
import android.text.Layout;
import android.text.StaticLayout;
import android.text.TextPaint;
import android.util.AttributeSet;
import android.view.View;
import android.widget.TextView;

public class OutlineTextView
extends TextView {
    private TextPaint mTextPaint;
    private TextPaint mTextPaintOutline;
    private String mText = "";
    private int mAscent = 0;
    private float mBorderSize;
    private int mBorderColor;
    private int mColor;
    private float mSpacingMult = 1.0f;
    private float mSpacingAdd = 0.0f;
    private boolean mIncludePad = true;

    public OutlineTextView(Context context) {
        super(context);
        this.initPaint();
    }

    public OutlineTextView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initPaint();
    }

    public OutlineTextView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initPaint();
    }

    private void initPaint() {
        this.mTextPaint = new TextPaint();
        this.mTextPaint.setAntiAlias(true);
        this.mTextPaint.setTextSize(this.getTextSize());
        this.mTextPaint.setColor(this.mColor);
        this.mTextPaint.setStyle(Paint.Style.FILL);
        this.mTextPaint.setTypeface(this.getTypeface());
        this.mTextPaintOutline = new TextPaint();
        this.mTextPaintOutline.setAntiAlias(true);
        this.mTextPaintOutline.setTextSize(this.getTextSize());
        this.mTextPaintOutline.setColor(this.mBorderColor);
        this.mTextPaintOutline.setStyle(Paint.Style.STROKE);
        this.mTextPaintOutline.setTypeface(this.getTypeface());
        this.mTextPaintOutline.setStrokeWidth(this.mBorderSize);
    }

    public void setText(String text) {
        super.setText((CharSequence)text);
        this.mText = text.toString();
        this.requestLayout();
        this.invalidate();
    }

    public void setTextSize(float size) {
        super.setTextSize(size);
        this.requestLayout();
        this.invalidate();
        this.initPaint();
    }

    public void setTextColor(int color) {
        super.setTextColor(color);
        this.mColor = color;
        this.invalidate();
        this.initPaint();
    }

    public void setShadowLayer(float radius, float dx, float dy, int color) {
        super.setShadowLayer(radius, dx, dy, color);
        this.mBorderSize = radius;
        this.mBorderColor = color;
        this.requestLayout();
        this.invalidate();
        this.initPaint();
    }

    public void setTypeface(Typeface tf, int style2) {
        super.setTypeface(tf, style2);
        this.requestLayout();
        this.invalidate();
        this.initPaint();
    }

    public void setTypeface(Typeface tf) {
        super.setTypeface(tf);
        this.requestLayout();
        this.invalidate();
        this.initPaint();
    }

    protected void onDraw(Canvas canvas) {
        StaticLayout layout = new StaticLayout(this.getText(), this.mTextPaintOutline, this.getWidth(), Layout.Alignment.ALIGN_CENTER, this.mSpacingMult, this.mSpacingAdd, this.mIncludePad);
        layout.draw(canvas);
        layout = new StaticLayout(this.getText(), this.mTextPaint, this.getWidth(), Layout.Alignment.ALIGN_CENTER, this.mSpacingMult, this.mSpacingAdd, this.mIncludePad);
        layout.draw(canvas);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        StaticLayout layout = new StaticLayout(this.getText(), this.mTextPaintOutline, this.measureWidth(widthMeasureSpec), Layout.Alignment.ALIGN_CENTER, this.mSpacingMult, this.mSpacingAdd, this.mIncludePad);
        int ex = (int)(this.mBorderSize * 2.0f + 1.0f);
        this.setMeasuredDimension(this.measureWidth(widthMeasureSpec) + ex, this.measureHeight(heightMeasureSpec) * layout.getLineCount() + ex);
    }

    private int measureWidth(int measureSpec) {
        int result = 0;
        int specMode = View.MeasureSpec.getMode((int)measureSpec);
        int specSize = View.MeasureSpec.getSize((int)measureSpec);
        if (specMode == 0x40000000) {
            result = specSize;
        } else {
            result = (int)this.mTextPaintOutline.measureText(this.mText) + this.getPaddingLeft() + this.getPaddingRight();
            if (specMode == Integer.MIN_VALUE) {
                result = Math.min(result, specSize);
            }
        }
        return result;
    }

    private int measureHeight(int measureSpec) {
        int result = 0;
        int specMode = View.MeasureSpec.getMode((int)measureSpec);
        int specSize = View.MeasureSpec.getSize((int)measureSpec);
        this.mAscent = (int)this.mTextPaintOutline.ascent();
        if (specMode == 0x40000000) {
            result = specSize;
        } else {
            result = (int)((float)(-this.mAscent) + this.mTextPaintOutline.descent()) + this.getPaddingTop() + this.getPaddingBottom();
            if (specMode == Integer.MIN_VALUE) {
                result = Math.min(result, specSize);
            }
        }
        return result;
    }
}

