/*
 * Decompiled with CFR 0.152.
 */
package io.vov.vitamio.widget;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.SparseArray;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewGroup;
import io.vov.vitamio.MediaFormat;
import io.vov.vitamio.MediaPlayer;
import io.vov.vitamio.Vitamio;
import io.vov.vitamio.utils.Log;
import io.vov.vitamio.widget.MediaController;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class VideoView
extends SurfaceView
implements MediaController.MediaPlayerControl {
    public static final int VIDEO_LAYOUT_ORIGIN = 0;
    public static final int VIDEO_LAYOUT_SCALE = 1;
    public static final int VIDEO_LAYOUT_STRETCH = 2;
    public static final int VIDEO_LAYOUT_ZOOM = 3;
    private static final int STATE_ERROR = -1;
    private static final int STATE_IDLE = 0;
    private static final int STATE_PREPARING = 1;
    private static final int STATE_PREPARED = 2;
    private static final int STATE_PLAYING = 3;
    private static final int STATE_PAUSED = 4;
    private static final int STATE_PLAYBACK_COMPLETED = 5;
    private static final int STATE_SUSPEND = 6;
    private static final int STATE_RESUME = 7;
    private static final int STATE_SUSPEND_UNSUPPORTED = 8;
    MediaPlayer.OnVideoSizeChangedListener mSizeChangedListener = new MediaPlayer.OnVideoSizeChangedListener(){

        @Override
        public void onVideoSizeChanged(MediaPlayer mp, int width, int height) {
            Log.d("onVideoSizeChanged: (%dx%d)", width, height);
            VideoView.this.mVideoWidth = mp.getVideoWidth();
            VideoView.this.mVideoHeight = mp.getVideoHeight();
            VideoView.this.mVideoAspectRatio = mp.getVideoAspectRatio();
            if (VideoView.this.mVideoWidth != 0 && VideoView.this.mVideoHeight != 0) {
                VideoView.this.setVideoLayout(VideoView.this.mVideoLayout, VideoView.this.mAspectRatio);
            }
        }
    };
    MediaPlayer.OnPreparedListener mPreparedListener = new MediaPlayer.OnPreparedListener(){

        @Override
        public void onPrepared(MediaPlayer mp) {
            Log.d("onPrepared", new Object[0]);
            VideoView.this.mCurrentState = 2;
            if (VideoView.this.mOnPreparedListener != null) {
                VideoView.this.mOnPreparedListener.onPrepared(VideoView.this.mMediaPlayer);
            }
            if (VideoView.this.mMediaController != null) {
                VideoView.this.mMediaController.setEnabled(true);
            }
            VideoView.this.mVideoWidth = mp.getVideoWidth();
            VideoView.this.mVideoHeight = mp.getVideoHeight();
            VideoView.this.mVideoAspectRatio = mp.getVideoAspectRatio();
            long seekToPosition = VideoView.this.mSeekWhenPrepared;
            if (seekToPosition != 0L) {
                VideoView.this.seekTo(seekToPosition);
            }
            if (VideoView.this.mVideoWidth != 0 && VideoView.this.mVideoHeight != 0) {
                VideoView.this.setVideoLayout(VideoView.this.mVideoLayout, VideoView.this.mAspectRatio);
                if (VideoView.this.mSurfaceWidth == VideoView.this.mVideoWidth && VideoView.this.mSurfaceHeight == VideoView.this.mVideoHeight) {
                    if (VideoView.this.mTargetState == 3) {
                        VideoView.this.start();
                        if (VideoView.this.mMediaController != null) {
                            VideoView.this.mMediaController.show();
                        }
                    } else if (!(VideoView.this.isPlaying() || seekToPosition == 0L && VideoView.this.getCurrentPosition() <= 0L || VideoView.this.mMediaController == null)) {
                        VideoView.this.mMediaController.show(0);
                    }
                }
            } else if (VideoView.this.mTargetState == 3) {
                VideoView.this.start();
            }
        }
    };
    SurfaceHolder.Callback mSHCallback = new SurfaceHolder.Callback(){

        public void surfaceChanged(SurfaceHolder holder, int format, int w, int h) {
            boolean hasValidSize;
            VideoView.this.mSurfaceWidth = w;
            VideoView.this.mSurfaceHeight = h;
            boolean isValidState = VideoView.this.mTargetState == 3;
            boolean bl = hasValidSize = VideoView.this.mVideoWidth == w && VideoView.this.mVideoHeight == h;
            if (VideoView.this.mMediaPlayer != null && isValidState && hasValidSize) {
                if (VideoView.this.mSeekWhenPrepared != 0L) {
                    VideoView.this.seekTo(VideoView.this.mSeekWhenPrepared);
                }
                VideoView.this.start();
                if (VideoView.this.mMediaController != null) {
                    if (VideoView.this.mMediaController.isShowing()) {
                        VideoView.this.mMediaController.hide();
                    }
                    VideoView.this.mMediaController.show();
                }
            }
        }

        public void surfaceCreated(SurfaceHolder holder) {
            VideoView.this.mSurfaceHolder = holder;
            if (VideoView.this.mMediaPlayer != null && VideoView.this.mCurrentState == 6 && VideoView.this.mTargetState == 7) {
                VideoView.this.mMediaPlayer.setDisplay(VideoView.this.mSurfaceHolder);
                VideoView.this.resume();
            } else {
                VideoView.this.openVideo();
            }
        }

        public void surfaceDestroyed(SurfaceHolder holder) {
            VideoView.this.mSurfaceHolder = null;
            if (VideoView.this.mMediaController != null) {
                VideoView.this.mMediaController.hide();
            }
            VideoView.this.release(true);
        }
    };
    private Uri mUri;
    private long mDuration;
    private int mCurrentState = 0;
    private int mTargetState = 0;
    private float mAspectRatio = 0.0f;
    private int mVideoLayout = 1;
    private SurfaceHolder mSurfaceHolder = null;
    private MediaPlayer mMediaPlayer = null;
    private int mVideoWidth;
    private int mVideoHeight;
    private float mVideoAspectRatio;
    private int mVideoChroma = 1;
    private boolean mHardwareDecoder = false;
    private int mSurfaceWidth;
    private int mSurfaceHeight;
    private MediaController mMediaController;
    private View mMediaBufferingIndicator;
    private MediaPlayer.OnCompletionListener mOnCompletionListener;
    private MediaPlayer.OnPreparedListener mOnPreparedListener;
    private MediaPlayer.OnErrorListener mOnErrorListener;
    private MediaPlayer.OnSeekCompleteListener mOnSeekCompleteListener;
    private MediaPlayer.OnTimedTextListener mOnTimedTextListener;
    private MediaPlayer.OnInfoListener mOnInfoListener;
    private MediaPlayer.OnBufferingUpdateListener mOnBufferingUpdateListener;
    private int mCurrentBufferPercentage;
    private long mSeekWhenPrepared;
    private Context mContext;
    private Map<String, String> mHeaders;
    private int mBufSize;
    private MediaPlayer.OnCompletionListener mCompletionListener = new MediaPlayer.OnCompletionListener(){

        @Override
        public void onCompletion(MediaPlayer mp) {
            Log.d("onCompletion", new Object[0]);
            VideoView.this.mCurrentState = 5;
            VideoView.this.mTargetState = 5;
            if (VideoView.this.mMediaController != null) {
                VideoView.this.mMediaController.hide();
            }
            if (VideoView.this.mOnCompletionListener != null) {
                VideoView.this.mOnCompletionListener.onCompletion(VideoView.this.mMediaPlayer);
            }
        }
    };
    private MediaPlayer.OnErrorListener mErrorListener = new MediaPlayer.OnErrorListener(){

        @Override
        public boolean onError(MediaPlayer mp, int framework_err, int impl_err) {
            Log.d("Error: %d, %d", framework_err, impl_err);
            VideoView.this.mCurrentState = -1;
            VideoView.this.mTargetState = -1;
            if (VideoView.this.mMediaController != null) {
                VideoView.this.mMediaController.hide();
            }
            if (VideoView.this.mOnErrorListener != null && VideoView.this.mOnErrorListener.onError(VideoView.this.mMediaPlayer, framework_err, impl_err)) {
                return true;
            }
            if (VideoView.this.getWindowToken() != null) {
                int message = framework_err == 200 ? VideoView.this.getResources().getIdentifier("VideoView_error_text_invalid_progressive_playback", "string", VideoView.this.mContext.getPackageName()) : VideoView.this.getResources().getIdentifier("VideoView_error_text_unknown", "string", VideoView.this.mContext.getPackageName());
                new AlertDialog.Builder(VideoView.this.mContext).setTitle(VideoView.this.getResources().getIdentifier("VideoView_error_title", "string", VideoView.this.mContext.getPackageName())).setMessage(message).setPositiveButton(VideoView.this.getResources().getIdentifier("VideoView_error_button", "string", VideoView.this.mContext.getPackageName()), new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int whichButton) {
                        if (VideoView.this.mOnCompletionListener != null) {
                            VideoView.this.mOnCompletionListener.onCompletion(VideoView.this.mMediaPlayer);
                        }
                    }
                }).setCancelable(false).show();
            }
            return true;
        }
    };
    private MediaPlayer.OnBufferingUpdateListener mBufferingUpdateListener = new MediaPlayer.OnBufferingUpdateListener(){

        @Override
        public void onBufferingUpdate(MediaPlayer mp, int percent) {
            VideoView.this.mCurrentBufferPercentage = percent;
            if (VideoView.this.mOnBufferingUpdateListener != null) {
                VideoView.this.mOnBufferingUpdateListener.onBufferingUpdate(mp, percent);
            }
        }
    };
    private MediaPlayer.OnInfoListener mInfoListener = new MediaPlayer.OnInfoListener(){

        @Override
        public boolean onInfo(MediaPlayer mp, int what, int extra) {
            Log.d("onInfo: (%d, %d)", what, extra);
            if (VideoView.this.mOnInfoListener != null) {
                VideoView.this.mOnInfoListener.onInfo(mp, what, extra);
            } else if (VideoView.this.mMediaPlayer != null) {
                if (what == 701) {
                    VideoView.this.mMediaPlayer.pause();
                    if (VideoView.this.mMediaBufferingIndicator != null) {
                        VideoView.this.mMediaBufferingIndicator.setVisibility(0);
                    }
                } else if (what == 702) {
                    VideoView.this.mMediaPlayer.start();
                    if (VideoView.this.mMediaBufferingIndicator != null) {
                        VideoView.this.mMediaBufferingIndicator.setVisibility(8);
                    }
                }
            }
            return true;
        }
    };
    private MediaPlayer.OnSeekCompleteListener mSeekCompleteListener = new MediaPlayer.OnSeekCompleteListener(){

        @Override
        public void onSeekComplete(MediaPlayer mp) {
            Log.d("onSeekComplete", new Object[0]);
            if (VideoView.this.mOnSeekCompleteListener != null) {
                VideoView.this.mOnSeekCompleteListener.onSeekComplete(mp);
            }
        }
    };
    private MediaPlayer.OnTimedTextListener mTimedTextListener = new MediaPlayer.OnTimedTextListener(){

        @Override
        public void onTimedTextUpdate(byte[] pixels, int width, int height) {
            Log.i("onSubtitleUpdate: bitmap subtitle, %dx%d", width, height);
            if (VideoView.this.mOnTimedTextListener != null) {
                VideoView.this.mOnTimedTextListener.onTimedTextUpdate(pixels, width, height);
            }
        }

        @Override
        public void onTimedText(String text) {
            Log.i("onSubtitleUpdate: %s", text);
            if (VideoView.this.mOnTimedTextListener != null) {
                VideoView.this.mOnTimedTextListener.onTimedText(text);
            }
        }
    };

    public VideoView(Context context) {
        super(context);
        this.initVideoView(context);
    }

    public VideoView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
        this.initVideoView(context);
    }

    public VideoView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initVideoView(context);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int width = VideoView.getDefaultSize((int)this.mVideoWidth, (int)widthMeasureSpec);
        int height = VideoView.getDefaultSize((int)this.mVideoHeight, (int)heightMeasureSpec);
        this.setMeasuredDimension(width, height);
    }

    public void setVideoLayout(int layout, float aspectRatio) {
        ViewGroup.LayoutParams lp = this.getLayoutParams();
        DisplayMetrics disp = this.mContext.getResources().getDisplayMetrics();
        int windowWidth = disp.widthPixels;
        int windowHeight = disp.heightPixels;
        float windowRatio = (float)windowWidth / (float)windowHeight;
        float videoRatio = aspectRatio <= 0.01f ? this.mVideoAspectRatio : aspectRatio;
        this.mSurfaceHeight = this.mVideoHeight;
        this.mSurfaceWidth = this.mVideoWidth;
        if (0 == layout && this.mSurfaceWidth < windowWidth && this.mSurfaceHeight < windowHeight) {
            lp.width = (int)((float)this.mSurfaceHeight * videoRatio);
            lp.height = this.mSurfaceHeight;
        } else if (layout == 3) {
            lp.width = windowRatio > videoRatio ? windowWidth : (int)(videoRatio * (float)windowHeight);
            lp.height = windowRatio < videoRatio ? windowHeight : (int)((float)windowWidth / videoRatio);
        } else {
            boolean full = layout == 2;
            lp.width = full || windowRatio < videoRatio ? windowWidth : (int)(videoRatio * (float)windowHeight);
            lp.height = full || windowRatio > videoRatio ? windowHeight : (int)((float)windowWidth / videoRatio);
        }
        this.setLayoutParams(lp);
        this.getHolder().setFixedSize(this.mSurfaceWidth, this.mSurfaceHeight);
        Log.d("VIDEO: %dx%dx%f, Surface: %dx%d, LP: %dx%d, Window: %dx%dx%f", this.mVideoWidth, this.mVideoHeight, Float.valueOf(this.mVideoAspectRatio), this.mSurfaceWidth, this.mSurfaceHeight, lp.width, lp.height, windowWidth, windowHeight, Float.valueOf(windowRatio));
        this.mVideoLayout = layout;
        this.mAspectRatio = aspectRatio;
    }

    private void initVideoView(Context ctx) {
        this.mContext = ctx;
        this.mVideoWidth = 0;
        this.mVideoHeight = 0;
        this.getHolder().setFormat(1);
        this.getHolder().addCallback(this.mSHCallback);
        if (Build.VERSION.SDK_INT < 11 && this.mHardwareDecoder) {
            this.getHolder().setType(3);
        }
        this.setFocusable(true);
        this.setFocusableInTouchMode(true);
        this.requestFocus();
        this.mCurrentState = 0;
        this.mTargetState = 0;
        if (ctx instanceof Activity) {
            ((Activity)ctx).setVolumeControlStream(3);
        }
    }

    public boolean isValid() {
        return this.mSurfaceHolder != null && this.mSurfaceHolder.getSurface().isValid();
    }

    public void setVideoPath(String path) {
        this.setVideoURI(Uri.parse((String)path));
    }

    public void setVideoURI(Uri uri) {
        this.setVideoURI(uri, null);
    }

    public void setVideoURI(Uri uri, Map<String, String> headers) {
        this.mUri = uri;
        this.mHeaders = headers;
        this.mSeekWhenPrepared = 0L;
        this.openVideo();
        this.requestLayout();
        this.invalidate();
    }

    public void stopPlayback() {
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.stop();
            this.mMediaPlayer.release();
            this.mMediaPlayer = null;
            this.mCurrentState = 0;
            this.mTargetState = 0;
        }
    }

    private void openVideo() {
        if (this.mUri == null || this.mSurfaceHolder == null || !Vitamio.isInitialized(this.mContext)) {
            return;
        }
        Intent i = new Intent("com.android.music.musicservicecommand");
        i.putExtra("command", "pause");
        this.mContext.sendBroadcast(i);
        this.release(false);
        try {
            this.mDuration = -1L;
            this.mCurrentBufferPercentage = 0;
            this.mMediaPlayer = new MediaPlayer(this.mContext, this.mHardwareDecoder);
            this.mMediaPlayer.setOnPreparedListener(this.mPreparedListener);
            this.mMediaPlayer.setOnVideoSizeChangedListener(this.mSizeChangedListener);
            this.mMediaPlayer.setOnCompletionListener(this.mCompletionListener);
            this.mMediaPlayer.setOnErrorListener(this.mErrorListener);
            this.mMediaPlayer.setOnBufferingUpdateListener(this.mBufferingUpdateListener);
            this.mMediaPlayer.setOnInfoListener(this.mInfoListener);
            this.mMediaPlayer.setOnSeekCompleteListener(this.mSeekCompleteListener);
            this.mMediaPlayer.setOnTimedTextListener(this.mTimedTextListener);
            this.mMediaPlayer.setDataSource(this.mContext, this.mUri, this.mHeaders);
            this.mMediaPlayer.setDisplay(this.mSurfaceHolder);
            this.mMediaPlayer.setBufferSize(this.mBufSize);
            this.mMediaPlayer.setVideoChroma(this.mVideoChroma == 0 ? 0 : 1);
            this.mMediaPlayer.setScreenOnWhilePlaying(true);
            this.mMediaPlayer.prepareAsync();
            this.mCurrentState = 1;
            this.attachMediaController();
        }
        catch (IOException ex) {
            Log.e("Unable to open content: " + this.mUri, ex);
            this.mCurrentState = -1;
            this.mTargetState = -1;
            this.mErrorListener.onError(this.mMediaPlayer, 1, 0);
            return;
        }
        catch (IllegalArgumentException ex) {
            Log.e("Unable to open content: " + this.mUri, ex);
            this.mCurrentState = -1;
            this.mTargetState = -1;
            this.mErrorListener.onError(this.mMediaPlayer, 1, 0);
            return;
        }
    }

    public void setMediaController(MediaController controller) {
        if (this.mMediaController != null) {
            this.mMediaController.hide();
        }
        this.mMediaController = controller;
        this.attachMediaController();
    }

    public void setMediaBufferingIndicator(View mediaBufferingIndicator) {
        if (this.mMediaBufferingIndicator != null) {
            this.mMediaBufferingIndicator.setVisibility(8);
        }
        this.mMediaBufferingIndicator = mediaBufferingIndicator;
    }

    private void attachMediaController() {
        if (this.mMediaPlayer != null && this.mMediaController != null) {
            this.mMediaController.setMediaPlayer(this);
            VideoView anchorView = this.getParent() instanceof View ? (View)this.getParent() : this;
            this.mMediaController.setAnchorView((View)anchorView);
            this.mMediaController.setEnabled(this.isInPlaybackState());
            if (this.mUri != null) {
                List paths = this.mUri.getPathSegments();
                String name = paths == null || paths.isEmpty() ? "null" : (String)paths.get(paths.size() - 1);
                this.mMediaController.setFileName(name);
            }
        }
    }

    public void setOnPreparedListener(MediaPlayer.OnPreparedListener l) {
        this.mOnPreparedListener = l;
    }

    public void setOnCompletionListener(MediaPlayer.OnCompletionListener l) {
        this.mOnCompletionListener = l;
    }

    public void setOnErrorListener(MediaPlayer.OnErrorListener l) {
        this.mOnErrorListener = l;
    }

    public void setOnBufferingUpdateListener(MediaPlayer.OnBufferingUpdateListener l) {
        this.mOnBufferingUpdateListener = l;
    }

    public void setOnSeekCompleteListener(MediaPlayer.OnSeekCompleteListener l) {
        this.mOnSeekCompleteListener = l;
    }

    public void setOnTimedTextListener(MediaPlayer.OnTimedTextListener l) {
        this.mOnTimedTextListener = l;
    }

    public void setOnInfoListener(MediaPlayer.OnInfoListener l) {
        this.mOnInfoListener = l;
    }

    private void release(boolean cleartargetstate) {
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.reset();
            this.mMediaPlayer.release();
            this.mMediaPlayer = null;
            this.mCurrentState = 0;
            if (cleartargetstate) {
                this.mTargetState = 0;
            }
        }
    }

    public boolean onTouchEvent(MotionEvent ev) {
        if (this.isInPlaybackState() && this.mMediaController != null) {
            this.toggleMediaControlsVisiblity();
        }
        return false;
    }

    public boolean onTrackballEvent(MotionEvent ev) {
        if (this.isInPlaybackState() && this.mMediaController != null) {
            this.toggleMediaControlsVisiblity();
        }
        return false;
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        boolean isKeyCodeSupported;
        boolean bl = isKeyCodeSupported = keyCode != 4 && keyCode != 24 && keyCode != 25 && keyCode != 82 && keyCode != 5 && keyCode != 6;
        if (this.isInPlaybackState() && isKeyCodeSupported && this.mMediaController != null) {
            if (keyCode == 79 || keyCode == 85 || keyCode == 62) {
                if (this.mMediaPlayer.isPlaying()) {
                    this.pause();
                    this.mMediaController.show();
                } else {
                    this.start();
                    this.mMediaController.hide();
                }
                return true;
            }
            if (keyCode == 126) {
                if (!this.mMediaPlayer.isPlaying()) {
                    this.start();
                    this.mMediaController.hide();
                }
                return true;
            }
            if (keyCode == 86 || keyCode == 127) {
                if (this.mMediaPlayer.isPlaying()) {
                    this.pause();
                    this.mMediaController.show();
                }
                return true;
            }
            this.toggleMediaControlsVisiblity();
        }
        return super.onKeyDown(keyCode, event);
    }

    private void toggleMediaControlsVisiblity() {
        if (this.mMediaController.isShowing()) {
            this.mMediaController.hide();
        } else {
            this.mMediaController.show();
        }
    }

    @Override
    public void start() {
        if (this.isInPlaybackState()) {
            this.mMediaPlayer.start();
            this.mCurrentState = 3;
        }
        this.mTargetState = 3;
    }

    @Override
    public void pause() {
        if (this.isInPlaybackState() && this.mMediaPlayer.isPlaying()) {
            this.mMediaPlayer.pause();
            this.mCurrentState = 4;
        }
        this.mTargetState = 4;
    }

    public void suspend() {
        if (this.isInPlaybackState()) {
            this.release(false);
            this.mCurrentState = 8;
            Log.d("Unable to suspend video. Release MediaPlayer.", new Object[0]);
        }
    }

    public void resume() {
        if (this.mSurfaceHolder == null && this.mCurrentState == 6) {
            this.mTargetState = 7;
        } else if (this.mCurrentState == 8) {
            this.openVideo();
        }
    }

    @Override
    public long getDuration() {
        if (this.isInPlaybackState()) {
            if (this.mDuration > 0L) {
                return this.mDuration;
            }
            this.mDuration = this.mMediaPlayer.getDuration();
            return this.mDuration;
        }
        this.mDuration = -1L;
        return this.mDuration;
    }

    @Override
    public long getCurrentPosition() {
        if (this.isInPlaybackState()) {
            return this.mMediaPlayer.getCurrentPosition();
        }
        return 0L;
    }

    @Override
    public void seekTo(long msec) {
        if (this.isInPlaybackState()) {
            this.mMediaPlayer.seekTo(msec);
            this.mSeekWhenPrepared = 0L;
        } else {
            this.mSeekWhenPrepared = msec;
        }
    }

    @Override
    public boolean isPlaying() {
        return this.isInPlaybackState() && this.mMediaPlayer.isPlaying();
    }

    @Override
    public int getBufferPercentage() {
        if (this.mMediaPlayer != null) {
            return this.mCurrentBufferPercentage;
        }
        return 0;
    }

    public void setVolume(float leftVolume, float rightVolume) {
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.setVolume(leftVolume, rightVolume);
        }
    }

    public int getVideoWidth() {
        return this.mVideoWidth;
    }

    public int getVideoHeight() {
        return this.mVideoHeight;
    }

    public float getVideoAspectRatio() {
        return this.mVideoAspectRatio;
    }

    public void setVideoChroma(int chroma) {
        this.getHolder().setFormat(chroma == 0 ? 4 : 1);
        this.mVideoChroma = chroma;
    }

    public void setHardwareDecoder(boolean hardware) {
        this.mHardwareDecoder = hardware;
    }

    public void setVideoQuality(int quality) {
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.setVideoQuality(quality);
        }
    }

    public void setBufferSize(int bufSize) {
        this.mBufSize = bufSize;
    }

    public boolean isBuffering() {
        if (this.mMediaPlayer != null) {
            return this.mMediaPlayer.isBuffering();
        }
        return false;
    }

    public String getMetaEncoding() {
        if (this.mMediaPlayer != null) {
            return this.mMediaPlayer.getMetaEncoding();
        }
        return null;
    }

    public void setMetaEncoding(String encoding) {
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.setMetaEncoding(encoding);
        }
    }

    public SparseArray<MediaFormat> getAudioTrackMap(String encoding) {
        if (this.mMediaPlayer != null) {
            return this.mMediaPlayer.findTrackFromTrackInfo(2, this.mMediaPlayer.getTrackInfo(encoding));
        }
        return null;
    }

    public int getAudioTrack() {
        if (this.mMediaPlayer != null) {
            return this.mMediaPlayer.getAudioTrack();
        }
        return -1;
    }

    public void setAudioTrack(int audioIndex) {
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.selectTrack(audioIndex);
        }
    }

    public void setTimedTextShown(boolean shown) {
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.setTimedTextShown(shown);
        }
    }

    public void setTimedTextEncoding(String encoding) {
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.setTimedTextEncoding(encoding);
        }
    }

    public int getTimedTextLocation() {
        if (this.mMediaPlayer != null) {
            return this.mMediaPlayer.getTimedTextLocation();
        }
        return -1;
    }

    public void addTimedTextSource(String subPath) {
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.addTimedTextSource(subPath);
        }
    }

    public String getTimedTextPath() {
        if (this.mMediaPlayer != null) {
            return this.mMediaPlayer.getTimedTextPath();
        }
        return null;
    }

    public void setSubTrack(int trackId) {
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.selectTrack(trackId);
        }
    }

    public int getTimedTextTrack() {
        if (this.mMediaPlayer != null) {
            return this.mMediaPlayer.getTimedTextTrack();
        }
        return -1;
    }

    public SparseArray<MediaFormat> getSubTrackMap(String encoding) {
        if (this.mMediaPlayer != null) {
            return this.mMediaPlayer.findTrackFromTrackInfo(3, this.mMediaPlayer.getTrackInfo(encoding));
        }
        return null;
    }

    protected boolean isInPlaybackState() {
        return this.mMediaPlayer != null && this.mCurrentState != -1 && this.mCurrentState != 0 && this.mCurrentState != 1;
    }
}

