/*
 * Decompiled with CFR 0.152.
 */
package me.noroutine.dust4j;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

class CharResponseWrapper
extends HttpServletResponseWrapper {
    private ByteArrayOutputStream out = new ByteArrayOutputStream();
    private PrintWriter printWriter;
    private ServletOutputStream servletOutputStream;

    public String toString() {
        try {
            return this.out.toString("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public CharResponseWrapper(HttpServletResponse response) {
        super(response);
    }

    public ServletOutputStream getOutputStream() {
        if (this.printWriter != null) {
            throw new IllegalStateException("getWriter() was already called");
        }
        if (this.servletOutputStream == null) {
            this.servletOutputStream = this.createServletOutputStream();
        }
        return this.servletOutputStream;
    }

    public PrintWriter getWriter() throws UnsupportedEncodingException {
        if (this.servletOutputStream != null) {
            throw new IllegalStateException("getOutputStream() was already called");
        }
        if (this.printWriter == null) {
            this.printWriter = this.createPrintWriter();
        }
        return this.printWriter;
    }

    private PrintWriter createPrintWriter() throws UnsupportedEncodingException {
        return new PrintWriter(new OutputStreamWriter((OutputStream)this.out, "UTF-8"));
    }

    private ServletOutputStream createServletOutputStream() {
        return new ServletOutputStream(){

            public void write(int b) throws IOException {
                CharResponseWrapper.this.out.write(b);
            }
        };
    }
}

