/*
 * Decompiled with CFR 0.152.
 */
package me.noroutine.dust4j;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import me.noroutine.dust4j.CharResponseWrapper;
import me.noroutine.dust4j.DefaultDustCompilerFactory;
import me.noroutine.dust4j.DustCompiler;
import me.noroutine.dust4j.DustCompilerFactory;

public class DustCompilingFilter
implements Filter {
    private static final Logger log = Logger.getLogger(DustCompilingFilter.class.getCanonicalName());
    private static final String DUST_TEMPLATE_CACHE_ATTR = "com.noroutine.dust4j.dustTemplateCache";
    private static final String DEFAULT_NAME_REGEX = "/(.*).dust.js$";
    private static final String PARAM_COMPILER_FACTORY = "compilerFactory";
    private static final String PARAM_CACHE = "cache";
    private static final String PARAM_ETAG = "eTag";
    private static final String PARAM_NAME_REGEX = "templateNameRegex";
    private DustCompilerFactory compilerFactory = new DefaultDustCompilerFactory();
    private DustCompiler compiler;
    private String templateNameRegex = "/(.*).dust.js$";
    private boolean cacheEnabled = true;
    private boolean eTagEnabled = false;

    public void init(FilterConfig filterConfig) throws ServletException {
        String appCtx = filterConfig.getServletContext().getContextPath();
        if (filterConfig.getInitParameter(PARAM_CACHE) != null) {
            this.cacheEnabled = Boolean.valueOf(filterConfig.getInitParameter(PARAM_CACHE));
        }
        if (filterConfig.getInitParameter(PARAM_ETAG) != null) {
            this.eTagEnabled = Boolean.valueOf(filterConfig.getInitParameter(PARAM_ETAG));
        }
        if (filterConfig.getInitParameter(PARAM_NAME_REGEX) != null) {
            this.templateNameRegex = filterConfig.getInitParameter(PARAM_NAME_REGEX);
        }
        try {
            if (filterConfig.getInitParameter(PARAM_COMPILER_FACTORY) != null) {
                Class<?> compilerFactoryClass = Class.forName(filterConfig.getInitParameter(PARAM_COMPILER_FACTORY));
                this.compilerFactory = (DustCompilerFactory)compilerFactoryClass.newInstance();
            }
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain chain) throws IOException, ServletException {
        if (req instanceof HttpServletRequest) {
            String uriRegex;
            HttpServletRequest request = (HttpServletRequest)req;
            HttpServletResponse response = (HttpServletResponse)resp;
            String appCtx = request.getSession().getServletContext().getContextPath();
            String uri = DustCompilingFilter.getURL(request);
            if (uri.matches(uriRegex = DustCompilingFilter.getTemplateNameRegex(appCtx, this.templateNameRegex))) {
                if (this.compiler == null) {
                    this.compiler = this.compilerFactory.createDustCompiler();
                }
                if (this.compiler == null) {
                    log.log(Level.SEVERE, "Failed to obtain compiler instance, skipping for this request");
                } else {
                    String template;
                    boolean cache = Boolean.valueOf(request.getParameter(PARAM_CACHE));
                    String version = request.getParameter("version");
                    String clientETag = request.getHeader("If-None-Match");
                    if (cache && this.eTagEnabled && version != null && clientETag != null && version.equals(clientETag)) {
                        response.setStatus(304);
                        return;
                    }
                    PrintWriter out = response.getWriter();
                    Map<String, String> templateCache = this.getDustTemplateCache(request);
                    String templateName = uri.replaceFirst(uriRegex, "$1");
                    if (cache && this.cacheEnabled && templateCache.containsKey(templateName)) {
                        log.info("Template cache hit for " + templateName);
                        template = templateCache.get(templateName);
                    } else {
                        CharResponseWrapper responseWrapper = new CharResponseWrapper(response);
                        chain.doFilter(req, (ServletResponse)responseWrapper);
                        String dustTemplate = responseWrapper.toString();
                        log.info("Compiling output with dust.js");
                        try {
                            long startTimeMs = System.currentTimeMillis();
                            template = this.compiler.compile(templateName, dustTemplate);
                            long compileTimeMs = System.currentTimeMillis() - startTimeMs;
                            log.info("Compiling time for " + templateName + " (ms): " + compileTimeMs);
                            if (cache && this.cacheEnabled) {
                                templateCache.put(templateName, template);
                            } else {
                                log.info("Template cache is disabled, this will slow down template load significantly");
                            }
                        }
                        catch (Exception e) {
                            log.log(Level.SEVERE, "Failed to compile template " + templateName, e);
                            template = this.getErrorTemplate(templateName);
                        }
                    }
                    response.setContentType("application/json");
                    response.setContentLength(template.getBytes("UTF-8").length);
                    if (cache && this.eTagEnabled && version != null) {
                        response.setHeader("ETag", version);
                    }
                    out.write(template);
                    out.close();
                    return;
                }
            }
        }
        chain.doFilter(req, resp);
    }

    public void destroy() {
    }

    private Map<String, String> getDustTemplateCache(HttpServletRequest request) {
        HashMap cache = (HashMap)request.getSession().getAttribute(DUST_TEMPLATE_CACHE_ATTR);
        if (cache == null) {
            cache = new HashMap();
            request.getSession().setAttribute(DUST_TEMPLATE_CACHE_ATTR, cache);
        }
        return cache;
    }

    private String getErrorTemplate(String templateName) {
        return "(function(){dust.register(\"" + templateName + "\",body_0);function body_0(chk,ctx){return chk.write(\"Failed to compile template\");}return body_0;})();";
    }

    private static String getTemplateNameRegex(String appCtx, String relativeRegex) {
        StringBuilder sb = new StringBuilder("^").append(appCtx);
        if (relativeRegex != null) {
            sb.append(relativeRegex.startsWith("^") ? relativeRegex.substring(1) : relativeRegex);
        } else {
            sb.append(DEFAULT_NAME_REGEX);
        }
        return sb.toString();
    }

    public void setCacheEnabled(boolean cacheEnabled) {
        this.cacheEnabled = cacheEnabled;
    }

    public void setETagEnabled(boolean eTagEnabled) {
        this.eTagEnabled = eTagEnabled;
    }

    public void setCompilerFactory(DustCompilerFactory compilerFactory) {
        if (compilerFactory == null) {
            throw new IllegalArgumentException("compilerFactory bust be not null");
        }
        this.compilerFactory = compilerFactory;
        this.compiler = null;
    }

    public void setTemplateNameRegex(String templateNameRegex) {
        this.templateNameRegex = templateNameRegex;
    }

    public static String getURL(HttpServletRequest req) {
        String contextPath = req.getContextPath();
        String servletPath = req.getServletPath();
        String pathInfo = req.getPathInfo();
        String queryString = req.getQueryString();
        StringBuffer url = new StringBuffer();
        url.append(contextPath).append(servletPath);
        if (pathInfo != null) {
            url.append(pathInfo);
        }
        if (queryString != null) {
            url.append("?").append(queryString);
        }
        return url.toString();
    }
}

