/*
 * Decompiled with CFR 0.152.
 */
package me.obsilabor.alert;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import me.obsilabor.alert.Event;
import me.obsilabor.alert.Subscribe;
import me.obsilabor.alert.kotlin.KotlinListener;

public class EventManager {
    private static final ConcurrentHashMap<Object, List<Method>> listeners = new ConcurrentHashMap();

    public static <T extends Event> T callEvent(T event) {
        return EventManager.callEvent(event, false);
    }

    public static <T extends Event> T callEvent(T event, boolean printException) {
        for (Object listener : listeners.keySet()) {
            try {
                Method method = listener.getClass().getMethod("isActive", new Class[0]);
                boolean isActive = (Boolean)method.invoke(listener, new Object[0]);
                if (!isActive) {
                    continue;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            for (Method method : listeners.get(listener)) {
                if (method.getParameterCount() != 1) {
                    System.out.println("[ALERT]: @Subscribe method with more or less then 1 arguments can't be invoked: " + method.getName());
                    continue;
                }
                if (!Arrays.asList(method.getParameterTypes()).contains(event.getClass()) && !(listener instanceof KotlinListener)) continue;
                try {
                    method.invoke(listener, event);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    if (e.getCause() instanceof ClassCastException || !printException) continue;
                    e.printStackTrace();
                }
            }
        }
        return event;
    }

    public static void registerListener(Object listener) {
        HashMap<Object, Integer> priorityMap = new HashMap<Object, Integer>();
        int globalPriority = -1;
        try {
            Method method = listener.getClass().getMethod("getPriority", new Class[0]);
            globalPriority = (Integer)method.invoke(listener, new Object[0]);
        }
        catch (Exception method) {
            // empty catch block
        }
        for (Method method : listener.getClass().getDeclaredMethods()) {
            Subscribe subscribe = method.getAnnotation(Subscribe.class);
            if (subscribe == null) continue;
            priorityMap.put(method, globalPriority == -1 ? subscribe.priority() : globalPriority);
        }
        List list = priorityMap.entrySet().stream().sorted(Map.Entry.comparingByValue()).map(Map.Entry::getKey).collect(Collectors.toList());
        Collections.reverse(list);
        listeners.put(listener, list);
    }

    public static void registerListeners(Object ... listeners) {
        for (Object listener : listeners) {
            EventManager.registerListener(listener);
        }
    }

    public static void unregisterListener(Object listener) {
        listeners.remove(listener);
    }
}

