/*
 * Decompiled with CFR 0.152.
 */
package bloomfilter.mutable;

import bloomfilter.CanGenerateHashFrom;
import bloomfilter.mutable.BloomFilter;
import bloomfilter.mutable.UnsafeBitArray;
import java.io.DataInputStream;
import java.io.InputStream;
import scala.Serializable;
import scala.math.package$;

public final class BloomFilter$
implements Serializable {
    public static BloomFilter$ MODULE$;

    static {
        new BloomFilter$();
    }

    public <T> BloomFilter<T> apply(long numberOfItems, double falsePositiveRate, CanGenerateHashFrom<T> canGenerateHash) {
        long nb = this.optimalNumberOfBits(numberOfItems, falsePositiveRate);
        int nh = this.optimalNumberOfHashes(numberOfItems, nb);
        return new BloomFilter<T>(nb, nh, canGenerateHash);
    }

    public long optimalNumberOfBits(long numberOfItems, double falsePositiveRate) {
        return (long)package$.MODULE$.ceil((double)(-1L * numberOfItems) * package$.MODULE$.log(falsePositiveRate) / package$.MODULE$.log(2.0) / package$.MODULE$.log(2.0));
    }

    public int optimalNumberOfHashes(long numberOfItems, long numberOfBits) {
        return (int)package$.MODULE$.ceil((double)(numberOfBits / numberOfItems) * package$.MODULE$.log(2.0));
    }

    public <T> BloomFilter<T> readFrom(InputStream in, CanGenerateHashFrom<T> canGenerateHash) {
        DataInputStream din = new DataInputStream(in);
        long numberOfBits = din.readLong();
        int numberOfHashes = din.readInt();
        UnsafeBitArray bits = new UnsafeBitArray(numberOfBits);
        bits.readFrom(in);
        return new BloomFilter<T>(numberOfBits, numberOfHashes, bits, canGenerateHash);
    }

    private Object readResolve() {
        return MODULE$;
    }

    private BloomFilter$() {
        MODULE$ = this;
    }
}

