/*
 * Decompiled with CFR 0.152.
 */
package bloomfilter.mutable;

import bloomfilter.CanGenerateHashFrom;
import bloomfilter.mutable.BloomFilter$;
import bloomfilter.mutable.UnsafeBitArray;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.math.package$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u00055d\u0001B\r\u001b\u0001}A\u0001B\u000b\u0001\u0003\u0006\u0004%\ta\u000b\u0005\t_\u0001\u0011\t\u0011)A\u0005Y!A\u0001\u0007\u0001BC\u0002\u0013\u0005\u0011\u0007\u0003\u00056\u0001\t\u0005\t\u0015!\u00033\u0011!1\u0004A!b\u0001\n\u00139\u0004\u0002\u0003\u001f\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001d\t\u0011u\u0002!\u0011!Q\u0001\fyBQ!\u0014\u0001\u0005\n9CQ!\u0014\u0001\u0005\u0002UCQA\u0017\u0001\u0005\u0002mCQ!\u0019\u0001\u0005\u0002\tDQ!\u001a\u0001\u0005\u0002\u0019DQ\u0001\u001b\u0001\u0005\u0002%DQA\u001c\u0001\u0005\u0002=DQa\u001d\u0001\u0005\u0002QDaa \u0001\u0005\u0002\u0005\u0005qaBA\b5!\u0005\u0011\u0011\u0003\u0004\u00073iA\t!a\u0005\t\r5\u0013B\u0011AA\u000b\u0011\u001d\t9B\u0005C\u0001\u00033Aq!!\r\u0013\t\u0003\t\u0019\u0004C\u0004\u0002:I!\t!a\u000f\t\u000f\u0005\u0005#\u0003\"\u0001\u0002D!I\u0011Q\f\n\u0002\u0002\u0013%\u0011q\f\u0002\f\u00052|w.\u001c$jYR,'O\u0003\u0002\u001c9\u00059Q.\u001e;bE2,'\"A\u000f\u0002\u0017\tdwn\\7gS2$XM]\u0002\u0001+\t\u0001CiE\u0002\u0001C\u001d\u0002\"AI\u0013\u000e\u0003\rR\u0011\u0001J\u0001\u0006g\u000e\fG.Y\u0005\u0003M\r\u0012a!\u00118z%\u00164\u0007C\u0001\u0012)\u0013\tI3E\u0001\u0007TKJL\u0017\r\\5{C\ndW-\u0001\u0007ok6\u0014WM](g\u0005&$8/F\u0001-!\t\u0011S&\u0003\u0002/G\t!Aj\u001c8h\u00035qW/\u001c2fe>3')\u001b;tA\u0005qa.^7cKJ|e\rS1tQ\u0016\u001cX#\u0001\u001a\u0011\u0005\t\u001a\u0014B\u0001\u001b$\u0005\rIe\u000e^\u0001\u0010]Vl'-\u001a:PM\"\u000b7\u000f[3tA\u0005!!-\u001b;t+\u0005A\u0004CA\u001d;\u001b\u0005Q\u0012BA\u001e\u001b\u00059)fn]1gK\nKG/\u0011:sCf\fQAY5ug\u0002\nqbY1o\u000f\u0016tWM]1uK\"\u000b7\u000f\u001b\t\u0004\u007f\u0001\u0013U\"\u0001\u000f\n\u0005\u0005c\"aE\"b]\u001e+g.\u001a:bi\u0016D\u0015m\u001d5Ge>l\u0007CA\"E\u0019\u0001!Q!\u0012\u0001C\u0002\u0019\u0013\u0011\u0001V\t\u0003\u000f*\u0003\"A\t%\n\u0005%\u001b#a\u0002(pi\"Lgn\u001a\t\u0003E-K!\u0001T\u0012\u0003\u0007\u0005s\u00170\u0001\u0004=S:LGO\u0010\u000b\u0005\u001fJ\u001bF\u000b\u0006\u0002Q#B\u0019\u0011\b\u0001\"\t\u000buB\u00019\u0001 \t\u000b)B\u0001\u0019\u0001\u0017\t\u000bAB\u0001\u0019\u0001\u001a\t\u000bYB\u0001\u0019\u0001\u001d\u0015\u0007YC\u0016\f\u0006\u0002Q/\")Q(\u0003a\u0002}!)!&\u0003a\u0001Y!)\u0001'\u0003a\u0001e\u0005\u0019\u0011\r\u001a3\u0015\u0005q{\u0006C\u0001\u0012^\u0013\tq6E\u0001\u0003V]&$\b\"\u00021\u000b\u0001\u0004\u0011\u0015!\u0001=\u0002\u000bUt\u0017n\u001c8\u0015\u0005A\u001b\u0007\"\u00023\f\u0001\u0004\u0001\u0016\u0001\u0002;iCR\f\u0011\"\u001b8uKJ\u001cXm\u0019;\u0015\u0005A;\u0007\"\u00023\r\u0001\u0004\u0001\u0016\u0001D7jO\"$8i\u001c8uC&tGC\u00016n!\t\u00113.\u0003\u0002mG\t9!i\\8mK\u0006t\u0007\"\u00021\u000e\u0001\u0004\u0011\u0015!G3ya\u0016\u001cG/\u001a3GC2\u001cX\rU8tSRLg/\u001a*bi\u0016$\u0012\u0001\u001d\t\u0003EEL!A]\u0012\u0003\r\u0011{WO\u00197f\u0003\u001d9(/\u001b;f)>$\"\u0001X;\t\u000bY|\u0001\u0019A<\u0002\u0007=,H\u000f\u0005\u0002y{6\t\u0011P\u0003\u0002{w\u0006\u0011\u0011n\u001c\u0006\u0002y\u0006!!.\u0019<b\u0013\tq\u0018P\u0001\u0007PkR\u0004X\u000f^*ue\u0016\fW.A\u0004eSN\u0004xn]3\u0015\u0003qCs\u0001AA\u0003\u0003\u0017\ti\u0001E\u0002#\u0003\u000fI1!!\u0003$\u0005A\u0019VM]5bYZ+'o]5p]VKE)A\u0003wC2,XMH\u0001\u0002\u0003-\u0011En\\8n\r&dG/\u001a:\u0011\u0005e\u00122c\u0001\n\"OQ\u0011\u0011\u0011C\u0001\u0006CB\u0004H._\u000b\u0005\u00037\t\u0019\u0003\u0006\u0004\u0002\u001e\u0005%\u0012Q\u0006\u000b\u0005\u0003?\t)\u0003\u0005\u0003:\u0001\u0005\u0005\u0002cA\"\u0002$\u0011)Q\t\u0006b\u0001\r\"1Q\b\u0006a\u0002\u0003O\u0001Ba\u0010!\u0002\"!1\u00111\u0006\u000bA\u00021\nQB\\;nE\u0016\u0014xJZ%uK6\u001c\bBBA\u0018)\u0001\u0007\u0001/A\tgC2\u001cX\rU8tSRLg/\u001a*bi\u0016\f1c\u001c9uS6\fGNT;nE\u0016\u0014xJ\u001a\"jiN$R\u0001LA\u001b\u0003oAa!a\u000b\u0016\u0001\u0004a\u0003BBA\u0018+\u0001\u0007\u0001/A\u000bpaRLW.\u00197Ok6\u0014WM](g\u0011\u0006\u001c\b.Z:\u0015\u000bI\ni$a\u0010\t\r\u0005-b\u00031\u0001-\u0011\u0015Qc\u00031\u0001-\u0003!\u0011X-\u00193Ge>lW\u0003BA#\u0003\u001b\"B!a\u0012\u0002TQ!\u0011\u0011JA(!\u0011I\u0004!a\u0013\u0011\u0007\r\u000bi\u0005B\u0003F/\t\u0007a\t\u0003\u0004>/\u0001\u000f\u0011\u0011\u000b\t\u0005\u007f\u0001\u000bY\u0005C\u0004\u0002V]\u0001\r!a\u0016\u0002\u0005%t\u0007c\u0001=\u0002Z%\u0019\u00111L=\u0003\u0017%s\u0007/\u001e;TiJ,\u0017-\\\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0002bA!\u00111MA5\u001b\t\t)GC\u0002\u0002hm\fA\u0001\\1oO&!\u00111NA3\u0005\u0019y%M[3di\u0002")
public class BloomFilter<T>
implements Serializable {
    public static final long serialVersionUID = 1L;
    private final long numberOfBits;
    private final int numberOfHashes;
    private final UnsafeBitArray bits;
    private final CanGenerateHashFrom<T> canGenerateHash;

    public static <T> BloomFilter<T> readFrom(InputStream inputStream, CanGenerateHashFrom<T> canGenerateHashFrom) {
        return BloomFilter$.MODULE$.readFrom(inputStream, canGenerateHashFrom);
    }

    public static int optimalNumberOfHashes(long l, long l2) {
        return BloomFilter$.MODULE$.optimalNumberOfHashes(l, l2);
    }

    public static long optimalNumberOfBits(long l, double d) {
        return BloomFilter$.MODULE$.optimalNumberOfBits(l, d);
    }

    public static <T> BloomFilter<T> apply(long l, double d, CanGenerateHashFrom<T> canGenerateHashFrom) {
        return BloomFilter$.MODULE$.apply(l, d, canGenerateHashFrom);
    }

    public long numberOfBits() {
        return this.numberOfBits;
    }

    public int numberOfHashes() {
        return this.numberOfHashes;
    }

    private UnsafeBitArray bits() {
        return this.bits;
    }

    public void add(T x) {
        long hash = this.canGenerateHash.generateHash(x);
        long hash1 = hash >>> 32;
        long hash2 = hash << 32 >> 32;
        for (int i = 0; i < this.numberOfHashes(); ++i) {
            long computedHash = hash1 + (long)i * hash2;
            this.bits().set((computedHash & Long.MAX_VALUE) % this.numberOfBits());
        }
    }

    public BloomFilter<T> union(BloomFilter<T> that) {
        Predef$.MODULE$.require(this.numberOfBits() == that.numberOfBits() && this.numberOfHashes() == that.numberOfHashes(), (Function0 & java.io.Serializable & Serializable)() -> "Union works only on BloomFilters with the same number of hashes and of bits");
        return new BloomFilter<T>(this.numberOfBits(), this.numberOfHashes(), this.bits().$bar(super.bits()), this.canGenerateHash);
    }

    public BloomFilter<T> intersect(BloomFilter<T> that) {
        Predef$.MODULE$.require(this.numberOfBits() == that.numberOfBits() && this.numberOfHashes() == that.numberOfHashes(), (Function0 & java.io.Serializable & Serializable)() -> "Intersect works only on BloomFilters with the same number of hashes and of bits");
        return new BloomFilter<T>(this.numberOfBits(), this.numberOfHashes(), this.bits().$amp(super.bits()), this.canGenerateHash);
    }

    public boolean mightContain(T x) {
        long hash = this.canGenerateHash.generateHash(x);
        long hash1 = hash >>> 32;
        long hash2 = hash << 32 >> 32;
        for (int i = 0; i < this.numberOfHashes(); ++i) {
            long computedHash = hash1 + (long)i * hash2;
            if (this.bits().get((computedHash & Long.MAX_VALUE) % this.numberOfBits())) continue;
            return false;
        }
        return true;
    }

    public double expectedFalsePositiveRate() {
        return package$.MODULE$.pow((double)this.bits().getBitCount() / (double)this.numberOfBits(), (double)this.numberOfHashes());
    }

    public void writeTo(OutputStream out) {
        DataOutputStream dataOutputStream = new DataOutputStream(out);
        dataOutputStream.writeLong(this.numberOfBits());
        dataOutputStream.writeInt(this.numberOfHashes());
        this.bits().writeTo(out);
    }

    public void dispose() {
        this.bits().dispose();
    }

    public BloomFilter(long numberOfBits, int numberOfHashes, UnsafeBitArray bits, CanGenerateHashFrom<T> canGenerateHash) {
        this.numberOfBits = numberOfBits;
        this.numberOfHashes = numberOfHashes;
        this.bits = bits;
        this.canGenerateHash = canGenerateHash;
    }

    public BloomFilter(long numberOfBits, int numberOfHashes, CanGenerateHashFrom<T> canGenerateHash) {
        this(numberOfBits, numberOfHashes, new UnsafeBitArray(numberOfBits), canGenerateHash);
    }
}

