/*
 * Decompiled with CFR 0.152.
 */
package bloomfilter.mutable._128bit;

import bloomfilter.CanGenerate128HashFrom;
import bloomfilter.mutable.UnsafeBitArray;
import bloomfilter.mutable._128bit.BloomFilter$;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import scala.Serializable;
import scala.Tuple2;
import scala.math.package$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005d\u0001B\f\u0019\u0001}A\u0001B\u000b\u0001\u0003\u0006\u0004%\ta\u000b\u0005\t_\u0001\u0011\t\u0011)A\u0005Y!A\u0001\u0007\u0001BC\u0002\u0013\u0005\u0011\u0007\u0003\u00056\u0001\t\u0005\t\u0015!\u00033\u0011!1\u0004A!b\u0001\n\u00139\u0004\u0002\u0003\u001f\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001d\t\u0011u\u0002!\u0011!Q\u0001\fyBQ!\u0014\u0001\u0005\n9CQ!\u0014\u0001\u0005\u0002YCQa\u0017\u0001\u0005\u0002qCQA\u0019\u0001\u0005\u0002\rDQ\u0001\u001b\u0001\u0005\u0002%DQ!\u001c\u0001\u0005\u00029DQ!\u001f\u0001\u0005\u0002i<q!a\u0001\u0019\u0011\u0003\t)A\u0002\u0004\u00181!\u0005\u0011q\u0001\u0005\u0007\u001bB!\t!!\u0003\t\u000f\u0005-\u0001\u0003\"\u0001\u0002\u000e!9\u0011Q\u0005\t\u0005\u0002\u0005\u001d\u0002bBA\u0017!\u0011\u0005\u0011q\u0006\u0005\b\u0003k\u0001B\u0011AA\u001c\u0011%\t\t\u0006EA\u0001\n\u0013\t\u0019FA\u0006CY>|WNR5mi\u0016\u0014(BA\r\u001b\u0003\u001dy\u0016G\r\u001dcSRT!a\u0007\u000f\u0002\u000f5,H/\u00192mK*\tQ$A\u0006cY>|WNZ5mi\u0016\u00148\u0001A\u000b\u0003A\u0011\u001b2\u0001A\u0011(!\t\u0011S%D\u0001$\u0015\u0005!\u0013!B:dC2\f\u0017B\u0001\u0014$\u0005\u0019\te.\u001f*fMB\u0011!\u0005K\u0005\u0003S\r\u0012AbU3sS\u0006d\u0017N_1cY\u0016\fAB\\;nE\u0016\u0014xJ\u001a\"jiN,\u0012\u0001\f\t\u0003E5J!AL\u0012\u0003\t1{gnZ\u0001\u000e]Vl'-\u001a:PM\nKGo\u001d\u0011\u0002\u001d9,XNY3s\u001f\u001aD\u0015m\u001d5fgV\t!\u0007\u0005\u0002#g%\u0011Ag\t\u0002\u0004\u0013:$\u0018a\u00048v[\n,'o\u00144ICNDWm\u001d\u0011\u0002\t\tLGo]\u000b\u0002qA\u0011\u0011HO\u0007\u00025%\u00111H\u0007\u0002\u000f+:\u001c\u0018MZ3CSR\f%O]1z\u0003\u0015\u0011\u0017\u000e^:!\u0003=\u0019\u0017M\\$f]\u0016\u0014\u0018\r^3ICND\u0007cA A\u00056\tA$\u0003\u0002B9\t12)\u00198HK:,'/\u0019;fcIB\u0004*Y:i\rJ|W\u000e\u0005\u0002D\t2\u0001A!B#\u0001\u0005\u00041%!\u0001+\u0012\u0005\u001dS\u0005C\u0001\u0012I\u0013\tI5EA\u0004O_RD\u0017N\\4\u0011\u0005\tZ\u0015B\u0001'$\u0005\r\te._\u0001\u0007y%t\u0017\u000e\u001e \u0015\t=\u001bF+\u0016\u000b\u0003!J\u00032!\u0015\u0001C\u001b\u0005A\u0002\"B\u001f\t\u0001\bq\u0004\"\u0002\u0016\t\u0001\u0004a\u0003\"\u0002\u0019\t\u0001\u0004\u0011\u0004\"\u0002\u001c\t\u0001\u0004ADcA,Z5R\u0011\u0001\u000b\u0017\u0005\u0006{%\u0001\u001dA\u0010\u0005\u0006U%\u0001\r\u0001\f\u0005\u0006a%\u0001\rAM\u0001\u0004C\u0012$GCA/a!\t\u0011c,\u0003\u0002`G\t!QK\\5u\u0011\u0015\t'\u00021\u0001C\u0003\u0005A\u0018\u0001D7jO\"$8i\u001c8uC&tGC\u00013h!\t\u0011S-\u0003\u0002gG\t9!i\\8mK\u0006t\u0007\"B1\f\u0001\u0004\u0011\u0015!G3ya\u0016\u001cG/\u001a3GC2\u001cX\rU8tSRLg/\u001a*bi\u0016$\u0012A\u001b\t\u0003E-L!\u0001\\\u0012\u0003\r\u0011{WO\u00197f\u0003\u001d9(/\u001b;f)>$\"!X8\t\u000bAl\u0001\u0019A9\u0002\u0007=,H\u000f\u0005\u0002so6\t1O\u0003\u0002uk\u0006\u0011\u0011n\u001c\u0006\u0002m\u0006!!.\u0019<b\u0013\tA8O\u0001\u0007PkR\u0004X\u000f^*ue\u0016\fW.A\u0004eSN\u0004xn]3\u0015\u0003uCS\u0001\u0001?\u0000\u0003\u0003\u0001\"AI?\n\u0005y\u001c#\u0001E*fe&\fGNV3sg&|g.V%E\u0003\u00151\u0018\r\\;f=\u0005\t\u0011a\u0003\"m_>lg)\u001b7uKJ\u0004\"!\u0015\t\u0014\u0007A\ts\u0005\u0006\u0002\u0002\u0006\u0005)\u0011\r\u001d9msV!\u0011qBA\f)\u0019\t\t\"!\b\u0002\"Q!\u00111CA\r!\u0011\t\u0006!!\u0006\u0011\u0007\r\u000b9\u0002B\u0003F%\t\u0007a\t\u0003\u0004>%\u0001\u000f\u00111\u0004\t\u0005\u007f\u0001\u000b)\u0002\u0003\u0004\u0002 I\u0001\r\u0001L\u0001\u000e]Vl'-\u001a:PM&#X-\\:\t\r\u0005\r\"\u00031\u0001k\u0003E1\u0017\r\\:f!>\u001c\u0018\u000e^5wKJ\u000bG/Z\u0001\u0014_B$\u0018.\\1m\u001dVl'-\u001a:PM\nKGo\u001d\u000b\u0006Y\u0005%\u00121\u0006\u0005\u0007\u0003?\u0019\u0002\u0019\u0001\u0017\t\r\u0005\r2\u00031\u0001k\u0003Uy\u0007\u000f^5nC2tU/\u001c2fe>3\u0007*Y:iKN$RAMA\u0019\u0003gAa!a\b\u0015\u0001\u0004a\u0003\"\u0002\u0016\u0015\u0001\u0004a\u0013\u0001\u0003:fC\u00124%o\\7\u0016\t\u0005e\u0012\u0011\t\u000b\u0005\u0003w\t9\u0005\u0006\u0003\u0002>\u0005\r\u0003\u0003B)\u0001\u0003\u007f\u00012aQA!\t\u0015)UC1\u0001G\u0011\u0019iT\u0003q\u0001\u0002FA!q\bQA \u0011\u001d\tI%\u0006a\u0001\u0003\u0017\n!!\u001b8\u0011\u0007I\fi%C\u0002\u0002PM\u00141\"\u00138qkR\u001cFO]3b[\u0006Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\t)\u0006\u0005\u0003\u0002X\u0005uSBAA-\u0015\r\tY&^\u0001\u0005Y\u0006tw-\u0003\u0003\u0002`\u0005e#AB(cU\u0016\u001cG\u000f")
public class BloomFilter<T>
implements Serializable {
    public static final long serialVersionUID = 1L;
    private final long numberOfBits;
    private final int numberOfHashes;
    private final UnsafeBitArray bits;
    private final CanGenerate128HashFrom<T> canGenerateHash;

    public static <T> BloomFilter<T> readFrom(InputStream inputStream, CanGenerate128HashFrom<T> canGenerate128HashFrom) {
        return BloomFilter$.MODULE$.readFrom(inputStream, canGenerate128HashFrom);
    }

    public static int optimalNumberOfHashes(long l, long l2) {
        return BloomFilter$.MODULE$.optimalNumberOfHashes(l, l2);
    }

    public static long optimalNumberOfBits(long l, double d) {
        return BloomFilter$.MODULE$.optimalNumberOfBits(l, d);
    }

    public static <T> BloomFilter<T> apply(long l, double d, CanGenerate128HashFrom<T> canGenerate128HashFrom) {
        return BloomFilter$.MODULE$.apply(l, d, canGenerate128HashFrom);
    }

    public long numberOfBits() {
        return this.numberOfBits;
    }

    public int numberOfHashes() {
        return this.numberOfHashes;
    }

    private UnsafeBitArray bits() {
        return this.bits;
    }

    public void add(T x) {
        Tuple2<Object, Object> hash = this.canGenerateHash.generateHash(x);
        for (int i = 0; i < this.numberOfHashes(); ++i) {
            long computedHash = hash._1$mcJ$sp() + (long)i * hash._2$mcJ$sp();
            this.bits().set((computedHash & Long.MAX_VALUE) % this.numberOfBits());
        }
    }

    public boolean mightContain(T x) {
        Tuple2<Object, Object> hash = this.canGenerateHash.generateHash(x);
        for (int i = 0; i < this.numberOfHashes(); ++i) {
            long computedHash = hash._1$mcJ$sp() + (long)i * hash._2$mcJ$sp();
            if (this.bits().get((computedHash & Long.MAX_VALUE) % this.numberOfBits())) continue;
            return false;
        }
        return true;
    }

    public double expectedFalsePositiveRate() {
        return package$.MODULE$.pow((double)this.bits().getBitCount() / (double)this.numberOfBits(), (double)this.numberOfHashes());
    }

    public void writeTo(OutputStream out) {
        DataOutputStream dout = new DataOutputStream(out);
        dout.writeLong(this.numberOfBits());
        dout.writeInt(this.numberOfHashes());
        this.bits().writeTo(out);
    }

    public void dispose() {
        this.bits().dispose();
    }

    public BloomFilter(long numberOfBits, int numberOfHashes, UnsafeBitArray bits, CanGenerate128HashFrom<T> canGenerateHash) {
        this.numberOfBits = numberOfBits;
        this.numberOfHashes = numberOfHashes;
        this.bits = bits;
        this.canGenerateHash = canGenerateHash;
    }

    public BloomFilter(long numberOfBits, int numberOfHashes, CanGenerate128HashFrom<T> canGenerateHash) {
        this(numberOfBits, numberOfHashes, new UnsafeBitArray(numberOfBits), canGenerateHash);
    }
}

