/*
 * Decompiled with CFR 0.152.
 */
package console;

import console.AsciiBarFormat;
import console.BarFormatter$;
import console.Scaling;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.concurrent.TimeUnit;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005ma\u0001\u0002\f\u0018\u0001iA\u0001\u0002\u000b\u0001\u0003\u0002\u0003\u0006I!\u000b\u0005\ti\u0001\u0011\t\u0011)A\u0005k!)\u0001\b\u0001C\u0001s!9Q\b\u0001b\u0001\n\u0013q\u0004BB%\u0001A\u0003%q\bC\u0004K\u0001\t\u0007I\u0011\u0002 \t\r-\u0003\u0001\u0015!\u0003@\u0011\u0015\u0011\u0005\u0001\"\u0001M\u0011\u0015\u0011\u0005\u0001\"\u0001W\u0011\u0015I\u0006\u0001\"\u0003[\u0011\u0015i\u0006\u0001\"\u0003_\u0011\u0015\t\u0007\u0001\"\u0003c\u0011\u00159\u0007\u0001\"\u0003i\u0011\u00159\u0007\u0001\"\u0003m\u0011\u0015y\u0007\u0001\"\u0011q\u0011\u00151\b\u0001\"\u0003x\u000f\u001dQx#!A\t\u0002m4qAF\f\u0002\u0002#\u0005A\u0010C\u00039%\u0011\u0005Q\u0010C\u0004\u007f%E\u0005I\u0011A@\t\u0013\u0005U!#%A\u0005\u0002\u0005]!\u0001\u0004\"be\u001a{'/\\1ui\u0016\u0014(\"\u0001\r\u0002\u000f\r|gn]8mK\u000e\u00011\u0003\u0002\u0001\u001cC\u0015\u0002\"\u0001H\u0010\u000e\u0003uQ\u0011AH\u0001\u0006g\u000e\fG.Y\u0005\u0003Au\u0011a!\u00118z%\u00164\u0007C\u0001\u0012$\u001b\u00059\u0012B\u0001\u0013\u0018\u0005\u001d\u00196-\u00197j]\u001e\u0004\"A\t\u0014\n\u0005\u001d:\"AD!tG&L')\u0019:G_Jl\u0017\r^\u0001\u0005k:LG\u000f\u0005\u0002+c9\u00111f\f\t\u0003Yui\u0011!\f\u0006\u0003]e\ta\u0001\u0010:p_Rt\u0014B\u0001\u0019\u001e\u0003\u0019\u0001&/\u001a3fM&\u0011!g\r\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005Aj\u0012!\u00028d_2\u001c\bC\u0001\u000f7\u0013\t9TDA\u0002J]R\fa\u0001P5oSRtDc\u0001\u001e<yA\u0011!\u0005\u0001\u0005\bQ\r\u0001\n\u00111\u0001*\u0011\u001d!4\u0001%AA\u0002U\nq\u0001\\8oO\u001akG/F\u0001@!\t\u0001u)D\u0001B\u0015\t\u00115)\u0001\u0004g_Jl\u0017\r\u001e\u0006\u0003\t\u0016\u000bA\u0001^5nK*\ta)\u0001\u0003kCZ\f\u0017B\u0001%B\u0005E!\u0015\r^3US6,gi\u001c:nCR$XM]\u0001\tY>twMR7uA\u0005A1\u000f[8si\u001akG/A\u0005tQ>\u0014HOR7uAQ!\u0011&T(R\u0011\u0015q\u0005\u00021\u00016\u0003\u0005q\u0007\"\u0002)\t\u0001\u0004)\u0014!\u0002;pi\u0006d\u0007\"\u0002*\t\u0001\u0004\u0019\u0016aB3mCB\u001cX\r\u001a\t\u00039QK!!V\u000f\u0003\t1{gn\u001a\u000b\u0004S]C\u0006\"\u0002(\n\u0001\u0004)\u0004\"\u0002*\n\u0001\u0004\u0019\u0016A\u00044pe6\fG/\u00138uKJ4\u0018\r\u001c\u000b\u0003SmCQ\u0001\u0018\u0006A\u0002M\u000b1!\u001b8u\u0003\u001daWM\u001a;CCJ$2!K0a\u0011\u0015q5\u00021\u00016\u0011\u0015\u00016\u00021\u00016\u0003-\u0001(o\\4sKN\u001c()\u0019:\u0015\t%\u001aG-\u001a\u0005\u0006\u001d2\u0001\r!\u000e\u0005\u0006!2\u0001\r!\u000e\u0005\u0006M2\u0001\r!N\u0001\u0006]\n\u000b'o]\u0001\te&<\u0007\u000e\u001e\"beR!\u0011&\u001b6l\u0011\u0015qU\u00021\u00016\u0011\u0015\u0001V\u00021\u00016\u0011\u0015\u0011V\u00021\u0001T)\rISN\u001c\u0005\u0006\u001d:\u0001\r!\u000e\u0005\u0006%:\u0001\raU\u0001\u0006g\u000e\fG.\u001a\u000b\u0003SEDQA]\bA\u0002M\f1A\\;n!\taB/\u0003\u0002v;\t1Ai\\;cY\u0016\f!BZ8s[\u0006$(+\u0019;f)\tI\u0003\u0010C\u0003z!\u0001\u00071/\u0001\u0003sCR,\u0017\u0001\u0004\"be\u001a{'/\\1ui\u0016\u0014\bC\u0001\u0012\u0013'\t\u00112\u0004F\u0001|\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011\u0011\u0001\u0016\u0004S\u0005\r1FAA\u0003!\u0011\t9!!\u0005\u000e\u0005\u0005%!\u0002BA\u0006\u0003\u001b\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005=Q$\u0001\u0006b]:|G/\u0019;j_:LA!a\u0005\u0002\n\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00133+\t\tIBK\u00026\u0003\u0007\u0001")
public class BarFormatter
implements Scaling,
AsciiBarFormat {
    private final String unit;
    private final int ncols;
    private final DateTimeFormatter longFmt;
    private final DateTimeFormatter shortFmt;

    public static int $lessinit$greater$default$2() {
        return BarFormatter$.MODULE$.$lessinit$greater$default$2();
    }

    public static String $lessinit$greater$default$1() {
        return BarFormatter$.MODULE$.$lessinit$greater$default$1();
    }

    @Override
    public String leftBoundary() {
        return AsciiBarFormat.leftBoundary$(this);
    }

    @Override
    public String bar() {
        return AsciiBarFormat.bar$(this);
    }

    @Override
    public String empty() {
        return AsciiBarFormat.empty$(this);
    }

    @Override
    public String rightBoundary() {
        return AsciiBarFormat.rightBoundary$(this);
    }

    private DateTimeFormatter longFmt() {
        return this.longFmt;
    }

    private DateTimeFormatter shortFmt() {
        return this.shortFmt;
    }

    public String format(int n, int total, long elapsed) {
        Predef$.MODULE$.require(n <= total && total > 0, (Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(24).append("Current n is ").append(n).append(", total is ").append(total).toString());
        Predef$.MODULE$.require(n >= 0, (Function0 & java.io.Serializable & Serializable)() -> "n should be greater or equal to 0");
        String leftBarStr = this.leftBar(n, total);
        String rightBarStr = this.rightBar(n, total, elapsed);
        int nBars = Math.max(1, this.ncols - leftBarStr.length() - rightBarStr.length() - 2);
        String bar = nBars > 6 ? new StringBuilder(2).append(" ").append(this.progressBar(n, total, nBars)).append(" ").toString() : "|";
        return new StringBuilder(0).append(leftBarStr).append(bar).append(rightBarStr).toString();
    }

    public String format(int n, long elapsed) {
        return this.rightBar(n, elapsed);
    }

    private String formatInterval(long l) {
        LocalDateTime inst = Instant.ofEpochMilli(l).atZone(ZoneId.systemDefault()).toLocalDateTime();
        return TimeUnit.MILLISECONDS.toHours(l) >= 1L ? this.longFmt().format(inst) : this.shortFmt().format(inst);
    }

    private String leftBar(int n, int total) {
        double v;
        double arg$macro$1 = v = 100.0 * (double)n / (double)total;
        return new StringOps("%5.1f%%").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)arg$macro$1)}));
    }

    private String progressBar(int n, int total, int nBars) {
        int bodyLength = nBars - this.leftBoundary().length() - this.rightBoundary().length();
        double frac = (double)n / (double)total;
        int done = (int)(frac * (double)bodyLength);
        int remaining = bodyLength - done;
        return new StringBuilder(0).append(this.leftBoundary()).append(new StringOps(Predef$.MODULE$.augmentString(this.bar())).$times(done)).append(new StringOps(Predef$.MODULE$.augmentString(this.empty())).$times(remaining)).append(this.rightBoundary()).toString();
    }

    private String rightBar(int n, int total, long elapsed) {
        double elapsedSecs = 1.0 * (double)elapsed / (double)1000;
        double rate = (double)n / elapsedSecs;
        String elapsedFmt = this.formatInterval(elapsed);
        String remainingFmt = this.formatInterval((long)((double)(1000 * (total - n)) / rate));
        return new StringBuilder(9).append(this.scale(n)).append("/").append(this.scale(total)).append(" [").append(elapsedFmt).append(" < ").append(remainingFmt).append(", ").append(this.formatRate(rate)).append("]").toString();
    }

    private String rightBar(int n, long elapsed) {
        double elapsedSecs = 1.0 * (double)elapsed / (double)1000;
        double rate = (double)n / elapsedSecs;
        return new StringBuilder(5).append(this.scale(n)).append(" [").append(this.formatInterval(elapsed)).append(", ").append(this.formatRate(rate)).append("]").toString();
    }

    @Override
    public String scale(double num) {
        double arg$macro$1 = num;
        return new StringOps("%.1f").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)arg$macro$1)}));
    }

    private String formatRate(double rate) {
        return new StringBuilder(3).append(this.scale(rate)).append(" ").append(this.unit).append("/s").toString();
    }

    public BarFormatter(String unit, int ncols) {
        this.unit = unit;
        this.ncols = ncols;
        AsciiBarFormat.$init$(this);
        this.longFmt = DateTimeFormatter.ofPattern("HH:mm:ss");
        this.shortFmt = DateTimeFormatter.ofPattern("mm:ss");
    }
}

