/*
 * Decompiled with CFR 0.152.
 */
package console;

import console.BarFormatter;
import console.ProgressBar$;
import console.Updater;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.concurrent.TimeUnit;
import scala.Function1;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005-b\u0001\u0002\u0012$\u0001\u0019B\u0001\"\f\u0001\u0003\u0002\u0003\u0006IA\f\u0005\tc\u0001\u0011\t\u0011)A\u0005e!)a\u0007\u0001C\u0005o!AA\u0005\u0001EC\u0002\u0013%1\bC\u0004E\u0001\t\u0007I\u0011B#\t\r%\u0003\u0001\u0015!\u0003G\u0011%Q\u0005\u00011AA\u0002\u0013%Q\tC\u0005L\u0001\u0001\u0007\t\u0019!C\u0005\u0019\"I!\u000b\u0001a\u0001\u0002\u0003\u0006KA\u0012\u0005\b'\u0002\u0001\r\u0011\"\u0003U\u0011\u001d)\u0006\u00011A\u0005\nYCa\u0001\u0017\u0001!B\u0013q\u0003bB-\u0001\u0001\u0004%I\u0001\u0016\u0005\b5\u0002\u0001\r\u0011\"\u0003\\\u0011\u0019i\u0006\u0001)Q\u0005]!9a\f\u0001a\u0001\n\u0013)\u0005bB0\u0001\u0001\u0004%I\u0001\u0019\u0005\u0007E\u0002\u0001\u000b\u0015\u0002$\t\u000b\r\u0004A\u0011\u00023\t\u000b\u0015\u0004A\u0011\u00014\t\u000b%\u0004A\u0011\u00026\t\u000b5\u0004A\u0011\u00018\t\u000f\u0005\u001d\u0001\u0001\"\u0001\u0002\n!9\u00111\u0002\u0001\u0005\u0002\u0005%qaBA\u0007G!\u0005\u0011q\u0002\u0004\u0007E\rB\t!!\u0005\t\rYRB\u0011AA\n\u0011!\t)B\u0007b\u0001\n\u0013!\u0006bBA\f5\u0001\u0006IA\f\u0005\b\u00033QB\u0011AA\u000e\u0011\u001d\tIB\u0007C\u0001\u0003CAq!!\u0007\u001b\t\u0003\t)\u0003C\u0004\u0002\u001ai!\t!!\u000b\u0003\u0017A\u0013xn\u001a:fgN\u0014\u0015M\u001d\u0006\u0002I\u000591m\u001c8t_2,7\u0001A\n\u0003\u0001\u001d\u0002\"\u0001K\u0016\u000e\u0003%R\u0011AK\u0001\u0006g\u000e\fG.Y\u0005\u0003Y%\u0012a!\u00118z%\u00164\u0017!\u0002;pi\u0006d\u0007C\u0001\u00150\u0013\t\u0001\u0014FA\u0002J]R\fABY1s\r>\u0014X.\u0019;uKJ\u0004\"a\r\u001b\u000e\u0003\rJ!!N\u0012\u0003\u0019\t\u000b'OR8s[\u0006$H/\u001a:\u0002\rqJg.\u001b;?)\rA\u0014H\u000f\t\u0003g\u0001AQ!L\u0002A\u00029BQ!M\u0002A\u0002I*\u0012\u0001\u0010\t\u0003{\tk\u0011A\u0010\u0006\u0003\u007f\u0001\u000b!![8\u000b\u0003\u0005\u000bAA[1wC&\u00111I\u0010\u0002\f!JLg\u000e^*ue\u0016\fW.\u0001\bsK:$WM]%oi\u0016\u0014h/\u00197\u0016\u0003\u0019\u0003\"\u0001K$\n\u0005!K#\u0001\u0002'p]\u001e\fqB]3oI\u0016\u0014\u0018J\u001c;feZ\fG\u000eI\u0001\ngR\f'\u000f\u001e+j[\u0016\fQb\u001d;beR$\u0016.\\3`I\u0015\fHCA'Q!\tAc*\u0003\u0002PS\t!QK\\5u\u0011\u001d\t\u0006\"!AA\u0002\u0019\u000b1\u0001\u001f\u00132\u0003)\u0019H/\u0019:u)&lW\rI\u0001\u0002]V\ta&A\u0003o?\u0012*\u0017\u000f\u0006\u0002N/\"9\u0011kCA\u0001\u0002\u0004q\u0013A\u00018!\u0003\u001da\u0017m\u001d;MK:\f1\u0002\\1ti2+gn\u0018\u0013fcR\u0011Q\n\u0018\u0005\b#:\t\t\u00111\u0001/\u0003!a\u0017m\u001d;MK:\u0004\u0013A\u00047bgR\u0014VM\u001c3feRKW.Z\u0001\u0013Y\u0006\u001cHOU3oI\u0016\u0014H+[7f?\u0012*\u0017\u000f\u0006\u0002NC\"9\u0011+EA\u0001\u0002\u00041\u0015a\u00047bgR\u0014VM\u001c3feRKW.\u001a\u0011\u0002\u00079|w\u000fF\u0001G\u0003\u0019)\b\u000fZ1uKR\u0011Qj\u001a\u0005\u0006QR\u0001\rAL\u0001\u0005S:\u001c'/\u0001\u0004sK:$WM\u001d\u000b\u0003\u001b.DQ\u0001\\\u000bA\u0002\u0019\u000bq!\u001a7baN,G-A\u0003nKR,'/\u0006\u0002puR\u0011Q\n\u001d\u0005\u0006cZ\u0001\rA]\u0001\u0006E2|7m\u001b\t\u0005QM,\b0\u0003\u0002uS\tIa)\u001e8di&|g.\r\t\u0003gYL!a^\u0012\u0003\u000fU\u0003H-\u0019;feB\u0011\u0011P\u001f\u0007\u0001\t\u0015YhC1\u0001}\u0005\u0005\t\u0015cA?\u0002\u0002A\u0011\u0001F`\u0005\u0003\u007f&\u0012qAT8uQ&tw\rE\u0002)\u0003\u0007I1!!\u0002*\u0005\r\te._\u0001\u0006gR\f'\u000f\u001e\u000b\u0002\u001b\u0006!1\u000f^8q\u0003-\u0001&o\\4sKN\u001c()\u0019:\u0011\u0005MR2C\u0001\u000e()\t\ty!\u0001\u0007V].twn\u001e8U_R\fG.A\u0007V].twn\u001e8U_R\fG\u000eI\u0001\u0006CB\u0004H.\u001f\u000b\u0006q\u0005u\u0011q\u0004\u0005\u0006[y\u0001\rA\f\u0005\u0006cy\u0001\rA\r\u000b\u0004q\u0005\r\u0002\"B\u0017 \u0001\u0004qCc\u0001\u001d\u0002(!)\u0011\u0007\ta\u0001eQ\t\u0001\b")
public class ProgressBar {
    private PrintStream console;
    private final int total;
    private final BarFormatter barFormatter;
    private final long renderInterval;
    private long startTime;
    private int n;
    private int lastLen;
    private long lastRenderTime;
    private volatile boolean bitmap$0;

    public static ProgressBar apply() {
        return ProgressBar$.MODULE$.apply();
    }

    public static ProgressBar apply(BarFormatter barFormatter) {
        return ProgressBar$.MODULE$.apply(barFormatter);
    }

    public static ProgressBar apply(int n) {
        return ProgressBar$.MODULE$.apply(n);
    }

    public static ProgressBar apply(int n, BarFormatter barFormatter) {
        return ProgressBar$.MODULE$.apply(n, barFormatter);
    }

    private PrintStream console$lzycompute() {
        ProgressBar progressBar = this;
        synchronized (progressBar) {
            if (!this.bitmap$0) {
                this.console = new PrintStream((OutputStream)System.err, true, "UTF-8");
                this.bitmap$0 = true;
            }
        }
        return this.console;
    }

    private PrintStream console() {
        return !this.bitmap$0 ? this.console$lzycompute() : this.console;
    }

    private long renderInterval() {
        return this.renderInterval;
    }

    private long startTime() {
        return this.startTime;
    }

    private void startTime_$eq(long x$1) {
        this.startTime = x$1;
    }

    private int n() {
        return this.n;
    }

    private void n_$eq(int x$1) {
        this.n = x$1;
    }

    private int lastLen() {
        return this.lastLen;
    }

    private void lastLen_$eq(int x$1) {
        this.lastLen = x$1;
    }

    private long lastRenderTime() {
        return this.lastRenderTime;
    }

    private void lastRenderTime_$eq(long x$1) {
        this.lastRenderTime = x$1;
    }

    private long now() {
        return TimeUnit.NANOSECONDS.toMillis(System.nanoTime());
    }

    public void update(int incr) {
        block0: {
            Predef$.MODULE$.require(incr >= 0);
            this.n_$eq(this.n() + incr);
            long curTime = this.now();
            if (curTime - this.lastRenderTime() <= this.renderInterval() && this.n() != this.total) break block0;
            long elapsed = curTime - this.startTime();
            this.render(elapsed);
            this.lastRenderTime_$eq(curTime);
        }
    }

    private void render(long elapsed) {
        String barLine = this.total == ProgressBar$.MODULE$.console$ProgressBar$$UnknownTotal() ? this.barFormatter.format(this.n(), elapsed) : this.barFormatter.format(this.n(), this.total, elapsed);
        String padding = new StringOps(Predef$.MODULE$.augmentString(" ")).$times(Math.max(this.lastLen() - barLine.length(), 0));
        this.console().print(new StringBuilder(1).append("\r").append(barLine).append(padding).toString());
        this.lastLen_$eq(barLine.length());
    }

    public <A> void meter(Function1<Updater, A> block) {
        this.start();
        block.apply(incr -> this.update(incr));
        this.stop();
    }

    public void start() {
        this.startTime_$eq(this.now());
        this.n_$eq(0);
        this.lastLen_$eq(0);
    }

    public void stop() {
        this.console().println(" Done.");
    }

    public ProgressBar(int total, BarFormatter barFormatter) {
        this.total = total;
        this.barFormatter = barFormatter;
        this.renderInterval = 100L;
        this.n = 0;
        this.lastLen = 0;
        this.lastRenderTime = 0L;
    }
}

