/*
 * Decompiled with CFR 0.152.
 */
package hash;

import hash.Hash;
import java.nio.ByteBuffer;
import unsafe.package$;

public final class XxHash64$
implements Hash<Object> {
    public static XxHash64$ MODULE$;
    private final long Prime1;
    private final long Prime2;
    private final long Prime3;
    private final long Prime4;
    private final long Prime5;

    static {
        new XxHash64$();
    }

    @Override
    public final Object hashByteArray(byte[] input, Object seed) {
        return Hash.hashByteArray$(this, input, seed);
    }

    @Override
    public final Object hashByteArray(byte[] input, int offset, int length, Object seed) {
        return Hash.hashByteArray$(this, input, offset, length, seed);
    }

    @Override
    public final Object hashByteBuffer(ByteBuffer input, Object seed) {
        return Hash.hashByteBuffer$(this, input, seed);
    }

    @Override
    public final Object hashByteBuffer(ByteBuffer input, int offset, int length, Object seed) {
        return Hash.hashByteBuffer$(this, input, offset, length, seed);
    }

    public long Prime1() {
        return this.Prime1;
    }

    public long Prime2() {
        return this.Prime2;
    }

    public long Prime3() {
        return this.Prime3;
    }

    public long Prime4() {
        return this.Prime4;
    }

    public long Prime5() {
        return this.Prime5;
    }

    @Override
    public final long hashByte(byte input, long seed) {
        return this.avalanche(this.processByte(seed + this.Prime5() + 1L, input & 0xFF));
    }

    @Override
    public final long hashInt(int input, long seed) {
        return this.avalanche(this.processInt(seed + this.Prime5() + 4L, (long)input & 0xFFFFFFFFL));
    }

    @Override
    public final long hashLong(long input, long seed) {
        return this.avalanche(this.processLong(seed + this.Prime5() + 8L, input));
    }

    public final long round(long acc, long input) {
        return Long.rotateLeft(acc + input * this.Prime2(), 31) * this.Prime1();
    }

    public final long mergeRound(long acc, long v) {
        return (acc ^ this.round(0L, v)) * this.Prime1() + this.Prime4();
    }

    public final long finalize(long hash, byte[] input, long offset, int length) {
        int unprocessed;
        long h = hash;
        long off = offset;
        for (unprocessed = length; unprocessed >= 8; unprocessed -= 8) {
            h = this.processLong(h, package$.MODULE$.getLong(input, off));
            off += 8L;
        }
        if (unprocessed >= 4) {
            h = this.processInt(h, package$.MODULE$.getUnsignedInt(input, off));
            off += 4L;
            unprocessed -= 4;
        }
        while (unprocessed > 0) {
            h = this.processByte(h, package$.MODULE$.getUnsignedByte(input, off));
            ++off;
            --unprocessed;
        }
        return this.avalanche(h);
    }

    @Override
    public final long hashBytes(byte[] input, long offset, int length, long seed) {
        long hash = 0L;
        long off = offset;
        int unprocessed = length;
        if (length >= 32) {
            long v1 = seed + this.Prime1() + this.Prime2();
            long v2 = seed + this.Prime2();
            long v3 = seed;
            long v4 = seed - this.Prime1();
            do {
                v1 = this.round(v1, package$.MODULE$.getLong(input, off));
                v2 = this.round(v2, package$.MODULE$.getLong(input, off + 8L));
                v3 = this.round(v3, package$.MODULE$.getLong(input, off + 16L));
                v4 = this.round(v4, package$.MODULE$.getLong(input, off + 24L));
                off += 32L;
            } while ((unprocessed -= 32) >= 32);
            hash = Long.rotateLeft(v1, 1) + Long.rotateLeft(v2, 7) + Long.rotateLeft(v3, 12) + Long.rotateLeft(v4, 18);
            hash = this.mergeRound(hash, v1);
            hash = this.mergeRound(hash, v2);
            hash = this.mergeRound(hash, v3);
            hash = this.mergeRound(hash, v4);
        } else {
            hash = seed + this.Prime5();
        }
        return this.finalize(hash += (long)length, input, off, unprocessed);
    }

    private final long processByte(long hash, int input) {
        return Long.rotateLeft(hash ^ (long)input * this.Prime5(), 11) * this.Prime1();
    }

    private final long processInt(long hash, long input) {
        return Long.rotateLeft(hash ^ input * this.Prime1(), 23) * this.Prime2() + this.Prime3();
    }

    private final long processLong(long hash, long input) {
        return Long.rotateLeft(hash ^ this.round(0L, input), 27) * this.Prime1() + this.Prime4();
    }

    private final long avalanche(long hash) {
        long k1 = (hash ^ hash >>> 33) * this.Prime2();
        long k2 = (k1 ^ k1 >>> 29) * this.Prime3();
        return k2 ^ k2 >>> 32;
    }

    private XxHash64$() {
        MODULE$ = this;
        Hash.$init$(this);
        this.Prime1 = -7046029288634856825L;
        this.Prime2 = -4417276706812531889L;
        this.Prime3 = 1609587929392839161L;
        this.Prime4 = -8796714831421723037L;
        this.Prime5 = 2870177450012600261L;
    }
}

